/*
 * Decompiled with CFR 0.152.
 */
package freemarker.core;

import freemarker.core.BuiltIn;
import freemarker.core.Environment;
import freemarker.core.NestedContentNotSupportedException;
import freemarker.core.TemplateElement;
import freemarker.core.TemplatePostProcessorException;
import freemarker.core.TextBlock;
import freemarker.core.ThreadInterruptionSupportTemplatePostProcessor;
import freemarker.core._TemplateModelException;
import freemarker.template.Template;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModelException;
import freemarker.template._TemplateAPI;
import freemarker.template.utility.ClassUtil;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class _CoreAPI {
    public static final String ERROR_MESSAGE_HR = "----";
    public static final Set BUILT_IN_DIRECTIVE_NAMES;

    private _CoreAPI() {
    }

    public static Set getSupportedBuiltInNames() {
        return Collections.unmodifiableSet(BuiltIn.builtins.keySet());
    }

    public static void appendInstructionStackItem(TemplateElement stackEl, StringBuilder sb) {
        Environment.appendInstructionStackItem(stackEl, sb);
    }

    public static TemplateElement[] getInstructionStackSnapshot(Environment env) {
        return env.getInstructionStackSnapshot();
    }

    public static void outputInstructionStack(TemplateElement[] instructionStackSnapshot, boolean terseMode, Writer pw) {
        Environment.outputInstructionStack(instructionStackSnapshot, terseMode, pw);
    }

    public static final void addThreadInterruptedChecks(Template template) {
        try {
            new ThreadInterruptionSupportTemplatePostProcessor().postProcess(template);
        }
        catch (TemplatePostProcessorException e) {
            throw new RuntimeException("Template post-processing failed", e);
        }
    }

    public static final void checkHasNoNestedContent(TemplateDirectiveBody body) throws NestedContentNotSupportedException {
        NestedContentNotSupportedException.check(body);
    }

    public static final void replaceText(TextBlock textBlock, String text) {
        textBlock.replaceText(text);
    }

    public static void checkSettingValueItemsType(String somethingsSentenceStart, Class<?> expectedClass, Collection<? extends Object> values) {
        if (values == null) {
            return;
        }
        for (Object object : values) {
            if (expectedClass.isInstance(object)) continue;
            throw new IllegalArgumentException(somethingsSentenceStart + " must be instances of " + ClassUtil.getShortClassName(expectedClass) + ", but one of them was a(n) " + ClassUtil.getShortClassNameOfObject(object) + ".");
        }
    }

    public static TemplateModelException ensureIsTemplateModelException(String modelOpMsg, TemplateException e) {
        if (e instanceof TemplateModelException) {
            return (TemplateModelException)e;
        }
        return new _TemplateModelException(_TemplateAPI.getBlamedExpression(e), e.getCause(), e.getEnvironment(), modelOpMsg);
    }

    public static TemplateElement getParentElement(TemplateElement te) {
        return te.getParentElement();
    }

    public static TemplateElement getChildElement(TemplateElement te, int index) {
        return te.getChild(index);
    }

    static {
        TreeSet<String> names = new TreeSet<String>();
        names.add("assign");
        names.add("attempt");
        names.add("autoEsc");
        names.add("autoesc");
        names.add("break");
        names.add("call");
        names.add("case");
        names.add("comment");
        names.add("compress");
        names.add("default");
        names.add("else");
        names.add("elseif");
        names.add("elseIf");
        names.add("escape");
        names.add("fallback");
        names.add("flush");
        names.add("foreach");
        names.add("forEach");
        names.add("ftl");
        names.add("function");
        names.add("global");
        names.add("if");
        names.add("import");
        names.add("include");
        names.add("items");
        names.add("list");
        names.add("local");
        names.add("lt");
        names.add("macro");
        names.add("nested");
        names.add("noautoesc");
        names.add("noAutoEsc");
        names.add("noescape");
        names.add("noEscape");
        names.add("noparse");
        names.add("noParse");
        names.add("nt");
        names.add("outputformat");
        names.add("outputFormat");
        names.add("recover");
        names.add("recurse");
        names.add("return");
        names.add("rt");
        names.add("sep");
        names.add("setting");
        names.add("stop");
        names.add("switch");
        names.add("t");
        names.add("transform");
        names.add("visit");
        BUILT_IN_DIRECTIVE_NAMES = Collections.unmodifiableSet(names);
    }
}

