/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateConfigurerFactory;
import freemarker.cache.TemplateConfigurerFactoryException;
import freemarker.core.TemplateConfigurer;
import freemarker.template.Configuration;
import java.io.IOException;

public class MergingTemplateConfigurerFactory
extends TemplateConfigurerFactory {
    private final TemplateConfigurerFactory[] templateConfigurerFactories;

    public MergingTemplateConfigurerFactory(TemplateConfigurerFactory ... templateConfigurerFactories) {
        this.templateConfigurerFactories = templateConfigurerFactories;
    }

    public TemplateConfigurer get(String sourceName, Object templateSource) throws IOException, TemplateConfigurerFactoryException {
        TemplateConfigurer mergedTC = null;
        TemplateConfigurer resultTC = null;
        for (TemplateConfigurerFactory tcf : this.templateConfigurerFactories) {
            TemplateConfigurer tc = tcf.get(sourceName, templateSource);
            if (tc == null) continue;
            if (resultTC == null) {
                resultTC = tc;
                continue;
            }
            if (mergedTC == null) {
                Configuration cfg = this.getConfiguration();
                if (cfg == null) {
                    throw new IllegalStateException("The TemplateConfigurerFactory wasn't associated to a Configuration yet.");
                }
                mergedTC = new TemplateConfigurer();
                mergedTC.setParentConfiguration(cfg);
                mergedTC.merge(resultTC);
                resultTC = mergedTC;
            }
            mergedTC.merge(tc);
        }
        return resultTC;
    }

    protected void setConfigurationOfChildren(Configuration cfg) {
        for (TemplateConfigurerFactory templateConfigurerFactory : this.templateConfigurerFactories) {
            templateConfigurerFactory.setConfiguration(cfg);
        }
    }
}

