/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateConfigurerFactory;
import freemarker.cache.TemplateConfigurerFactoryException;
import freemarker.core.TemplateConfigurer;
import freemarker.template.Configuration;
import freemarker.template.utility.StringUtil;
import java.io.IOException;

public class FirstMatchTemplateConfigurerFactory
extends TemplateConfigurerFactory {
    private final TemplateConfigurerFactory[] templateConfigurerFactories;
    private boolean allowNoMatch;
    private String noMatchErrorDetails;

    public FirstMatchTemplateConfigurerFactory(TemplateConfigurerFactory ... templateConfigurerFactories) {
        this.templateConfigurerFactories = templateConfigurerFactories;
    }

    public TemplateConfigurer get(String sourceName, Object templateSource) throws IOException, TemplateConfigurerFactoryException {
        for (TemplateConfigurerFactory tcf : this.templateConfigurerFactories) {
            TemplateConfigurer tc = tcf.get(sourceName, templateSource);
            if (tc == null) continue;
            return tc;
        }
        if (!this.allowNoMatch) {
            throw new TemplateConfigurerFactoryException(FirstMatchTemplateConfigurerFactory.class.getSimpleName() + " has found no matching choice for source name " + StringUtil.jQuote(sourceName) + ". " + (this.noMatchErrorDetails != null ? "Error details: " + this.noMatchErrorDetails : "(Set the noMatchErrorDetails property of the factory bean to give a more specific error message. Set allowNoMatch to true if this shouldn't be an error.)"));
        }
        return null;
    }

    public boolean getAllowNoMatch() {
        return this.allowNoMatch;
    }

    public void setAllowNoMatch(boolean allowNoMatch) {
        this.allowNoMatch = allowNoMatch;
    }

    public String getNoMatchErrorDetails() {
        return this.noMatchErrorDetails;
    }

    public void setNoMatchErrorDetails(String noMatchErrorDetails) {
        this.noMatchErrorDetails = noMatchErrorDetails;
    }

    public FirstMatchTemplateConfigurerFactory allowNoMatch(boolean allow) {
        this.setAllowNoMatch(allow);
        return this;
    }

    public FirstMatchTemplateConfigurerFactory noMatchErrorDetails(String message) {
        this.setNoMatchErrorDetails(message);
        return this;
    }

    protected void setConfigurationOfChildren(Configuration cfg) {
        for (TemplateConfigurerFactory templateConfigurerFactory : this.templateConfigurerFactories) {
            templateConfigurerFactory.setConfiguration(cfg);
        }
    }
}

