/*
 * Decompiled with CFR 0.152.
 */
package freemarker.cache;

import freemarker.cache.TemplateConfigurerFactory;
import freemarker.cache.TemplateConfigurerFactoryException;
import freemarker.cache.TemplateSourceMatcher;
import freemarker.core.TemplateConfigurer;
import freemarker.template.Configuration;
import java.io.IOException;

public class ConditionalTemplateConfigurerFactory
extends TemplateConfigurerFactory {
    private final TemplateSourceMatcher matcher;
    private final TemplateConfigurer templateConfigurer;
    private final TemplateConfigurerFactory templateConfigurerFactory;

    public ConditionalTemplateConfigurerFactory(TemplateSourceMatcher matcher, TemplateConfigurerFactory templateConfigurerFactory) {
        this.matcher = matcher;
        this.templateConfigurer = null;
        this.templateConfigurerFactory = templateConfigurerFactory;
    }

    public ConditionalTemplateConfigurerFactory(TemplateSourceMatcher matcher, TemplateConfigurer templateConfigurer) {
        this.matcher = matcher;
        this.templateConfigurer = templateConfigurer;
        this.templateConfigurerFactory = null;
    }

    public TemplateConfigurer get(String sourceName, Object templateSource) throws IOException, TemplateConfigurerFactoryException {
        if (this.matcher.matches(sourceName, templateSource)) {
            if (this.templateConfigurerFactory != null) {
                return this.templateConfigurerFactory.get(sourceName, templateSource);
            }
            return this.templateConfigurer;
        }
        return null;
    }

    protected void setConfigurationOfChildren(Configuration cfg) {
        if (this.templateConfigurer != null) {
            this.templateConfigurer.setParentConfiguration(cfg);
        }
        if (this.templateConfigurerFactory != null) {
            this.templateConfigurerFactory.setConfiguration(cfg);
        }
    }
}

