/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.freemarker.docgen.BugException;
import org.freemarker.docgen.DocgenException;
import org.freemarker.docgen.DocgenLogger;
import org.freemarker.docgen.DocgenValidationOptions;
import org.freemarker.docgen.Transform;
import org.freemarker.docgen.ValidatingDOMBuilderWithLocations;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

final class XMLUtil {
    private static Boolean cachedIsJingAvilable;

    private XMLUtil() {
    }

    static boolean isJingAvilable() {
        if (cachedIsJingAvilable == null) {
            ClassLoader cl = Transform.class.getClassLoader();
            cachedIsJingAvilable = Boolean.TRUE;
            try {
                cl.loadClass("com.thaiopensource.validate.Schema");
            }
            catch (ClassNotFoundException e) {
                cachedIsJingAvilable = Boolean.FALSE;
            }
        }
        return cachedIsJingAvilable;
    }

    static SAXParserFactory newSAXParserFactory() throws SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        try {
            spf.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            throw new SAXException("The default SAX parser (XML) implementation doesn't support XInclude. Updating your Java installation will possibly fix this.");
        }
        spf.setValidating(false);
        return spf;
    }

    static DocumentBuilderFactory newDocumentBuilderFactory() throws SAXException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            dbf.setXIncludeAware(true);
        }
        catch (UnsupportedOperationException e) {
            throw new SAXException("The default Document builder (XML) implementation doesn't support XInclude. Updating your Java installation will possibly fix this.");
        }
        dbf.setValidating(false);
        return dbf;
    }

    static Document loadDocBook5XML(File bookFile, boolean validate, DocgenValidationOptions validationOps, DocgenLogger logger) throws SAXException, IOException, DocgenException {
        DocumentBuilder db;
        logger.info("Loading " + bookFile.getAbsolutePath() + "...");
        if (validate) {
            Method vm;
            if (!XMLUtil.isJingAvilable()) {
                throw new DocgenException("Jing classes are reqired for the validation but couldn't be found.");
            }
            try {
                vm = Transform.class.getClassLoader().loadClass("org.freemarker.docgen.RelaxNGValidator").getMethod("load", File.class, DocgenValidationOptions.class);
            }
            catch (Throwable e) {
                throw new BugException("Failed to get the org.freemarker.docgen.RelaxNGValidator.validate method (see cause exception).", e);
            }
            try {
                return (Document)vm.invoke(null, bookFile, validationOps);
            }
            catch (InvocationTargetException e) {
                Throwable te = e.getTargetException();
                if (te instanceof SAXException) {
                    throw (SAXException)te;
                }
                if (te instanceof IOException) {
                    throw (IOException)te;
                }
                throw new BugException("Failed to setup Relax NG validation (see cause exception).", e);
            }
            catch (Throwable e) {
                throw new BugException("Failed to invoke docgen.RelaxNGValidator method (see cause exception).", e);
            }
        }
        logger.info("Validation disabled. Be sure the source is valid Docgen-restricted DocBook 5.");
        DraconianErrorHandler eh = new DraconianErrorHandler(logger);
        DocumentBuilderFactory dbf = XMLUtil.newDocumentBuilderFactory();
        SchemaFactory schemaFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        schemaFact.setErrorHandler(eh);
        Schema schema = schemaFact.newSchema(Transform.class.getResource("schema/docbook.xsd"));
        if (validate) {
            dbf.setSchema(schema);
        }
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new BugException(e);
        }
        db.setErrorHandler(eh);
        return db.parse(bookFile);
    }

    public static String getAttribute(Element elem, String att) {
        String res = elem.getAttribute(att);
        return res.length() == 0 && !elem.hasAttribute(att) ? null : res;
    }

    public static String getAttributeNS(Element elem, String namespace, String att) {
        String res = elem.getAttributeNS(namespace, att);
        return res.length() == 0 && !elem.hasAttributeNS(namespace, att) ? null : res;
    }

    public static Iterable<Element> childrenElementsOf(final Node parent) {
        return new Iterable<Element>(){

            @Override
            public Iterator<Element> iterator() {
                return new ElementIterator();
            }

            class ElementIterator
            implements Iterator<Element> {
                private Node continueFrom;
                private Element curNode;

                ElementIterator() {
                    this.continueFrom = parent.getFirstChild();
                    this.fetch();
                }

                @Override
                public boolean hasNext() {
                    return this.curNode != null;
                }

                @Override
                public Element next() {
                    Element res = this.curNode;
                    this.fetch();
                    return res;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }

                private void fetch() {
                    while (this.continueFrom != null && !(this.continueFrom instanceof Element)) {
                        this.continueFrom = this.continueFrom.getNextSibling();
                    }
                    if (this.continueFrom != null) {
                        this.curNode = (Element)this.continueFrom;
                        this.continueFrom = this.curNode.getNextSibling();
                    } else {
                        this.curNode = null;
                    }
                }
            }
        };
    }

    public static String theSomethingElement(Element elem) {
        return XMLUtil.theSomethingElement(elem, false);
    }

    public static String theSomethingElement(Element elem, boolean capFirst) {
        ValidatingDOMBuilderWithLocations.Location loc;
        String id = XMLUtil.getAttribute(elem, "id");
        if (id == null) {
            id = XMLUtil.getAttribute(elem, "xml:id");
        }
        if (id != null && (id.startsWith("autoid_") || id.startsWith("docgen_"))) {
            id = null;
        }
        StringBuilder sb = new StringBuilder();
        if (id != null || elem.getParentNode() instanceof Document) {
            sb.append("the \"");
        } else {
            sb.append("a(n) \"");
        }
        sb.append(elem.getLocalName());
        sb.append("\" element");
        if (id != null) {
            sb.append(" with xml:id=\"").append(id).append("\"");
        }
        if ((loc = (ValidatingDOMBuilderWithLocations.Location)elem.getUserData("docgen_location")) != null) {
            sb.append(" (location: ");
            boolean empty = true;
            String sysId = loc.getSystemId();
            if (sysId != null) {
                int slashIdx = sysId.lastIndexOf("/");
                if (slashIdx != -1 && (slashIdx = sysId.lastIndexOf("/", slashIdx - 1)) > 0) {
                    sysId = "[...]" + sysId.substring(slashIdx);
                }
                sb.append(sysId);
                empty = false;
            }
            if (loc.getLine() > 0) {
                if (!empty) {
                    sb.append(':');
                }
                sb.append(loc.getLine());
                empty = false;
            }
            if (loc.getColumn() > 0) {
                if (!empty) {
                    sb.append(':');
                }
                sb.append(loc.getColumn());
            }
            sb.append(")");
        }
        if (capFirst) {
            sb.setCharAt(0, Character.toUpperCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    private static final class DraconianErrorHandler
    implements ErrorHandler {
        private final DocgenLogger logger;

        private DraconianErrorHandler(DocgenLogger logger) {
            this.logger = logger;
        }

        @Override
        public void warning(SAXParseException spe) {
            this.logger.info("- Warning: " + spe);
        }

        @Override
        public void error(SAXParseException spe) throws SAXParseException {
            throw spe;
        }

        @Override
        public void fatalError(SAXParseException spe) throws SAXParseException {
            throw spe;
        }
    }
}

