/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.StopException;
import freemarker.ext.dom.NodeModel;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.TemplateScalarModel;
import freemarker.template.utility.ClassUtil;
import freemarker.template.utility.DateUtil;
import freemarker.template.utility.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.freemarker.docgen.BugException;
import org.freemarker.docgen.CJSONInterpreter;
import org.freemarker.docgen.DocBook5Constants;
import org.freemarker.docgen.DocgenException;
import org.freemarker.docgen.DocgenLogger;
import org.freemarker.docgen.DocgenValidationOptions;
import org.freemarker.docgen.FileUtil;
import org.freemarker.docgen.Logo;
import org.freemarker.docgen.TableSimplifier;
import org.freemarker.docgen.TextUtil;
import org.freemarker.docgen.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Transform {
    static final String FILE_BOOK = "book.xml";
    static final String FILE_ARTICLE = "article.xml";
    static final String FILE_SETTINGS = "docgen.cjson";
    static final String FILE_TOC_HTML = "toc.html";
    static final String FILE_DETAILED_TOC_HTML = "detailed-toc.html";
    static final String FILE_INDEX_HTML = "index.html";
    static final String FILE_SEARCH_RESULTS_HTML = "search-results.html";
    static final String FILE_TOC_JSON_TEMPLATE = "toc-json.ftl";
    static final String FILE_TOC_JSON_OUTPUT = "toc.js";
    static final String FILE_ECLIPSE_TOC_TEMPLATE = "eclipse-toc.ftlx";
    static final String FILE_ECLIPSE_TOC_OUTPUT = "eclipse-toc.xml";
    static final String DIR_TEMPLATES = "docgen-templates";
    static final String FILE_SITEMAP_XML_TEMPLATE = "sitemap.ftlx";
    static final String FILE_SITEMAP_XML_OUTPUT = "sitemap.xml";
    static final String SETTING_IGNORED_FILES = "ignoredFiles";
    static final String SETTING_VALIDATION = "validation";
    static final String SETTING_OFFLINE = "offline";
    static final String SETTING_SIMPLE_NAVIGATION_MODE = "simpleNavigationMode";
    static final String SETTING_DEPLOY_URL = "deployUrl";
    static final String SETTING_ONLINE_TRACKER_HTML = "onlineTrackerHTML";
    static final String SETTING_COOKIE_CONSENT_SCRIPT_URL = "cookieConsentScriptURL";
    static final String SETTING_REMOVE_NODES_WHEN_ONLINE = "removeNodesWhenOnline";
    static final String SETTING_INTERNAL_BOOKMARKS = "internalBookmarks";
    static final String SETTING_EXTERNAL_BOOKMARKS = "externalBookmarks";
    static final String SETTING_COPYRIGHT_HOLDER = "copyrightHolder";
    static final String SETTING_COPYRIGHT_HOLDER_SITE = "copyrightHolderSite";
    static final String SETTING_COPYRIGHT_START_YEAR = "copyrightStartYear";
    static final String SETTING_COPYRIGHT_SUFFIX = "copyrightSuffix";
    static final String SETTING_COPYRIGHT_COMMENT_FILE = "copyrightCommentFile";
    static final String SETTING_SEO_META = "seoMeta";
    static final String SETTING_LOGO = "logo";
    static final String SETTING_LOGO_KEY_SRC = "src";
    static final String SETTING_LOGO_KEY_ALT = "alt";
    static final String SETTING_LOGO_KEY_HREF = "href";
    static final String SETTING_SIDE_TOC_LOGOS = "sideTOCLogos";
    static final String SETTING_TABS = "tabs";
    static final String SETTING_SECONDARY_TABS = "secondaryTabs";
    static final String SETTING_SOCIAL_LINKS = "socialLinks";
    static final String SETTING_FOOTER_SITEMAP = "footerSiteMap";
    static final String SETTING_OLINKS = "olinks";
    static final String SETTING_ECLIPSE = "eclipse";
    static final String SETTING_SHOW_EDITORAL_NOTES = "showEditoralNotes";
    static final String SETTING_GENERATE_ECLIPSE_TOC = "generateEclipseTOC";
    static final String SETTING_SHOW_XXE_LOGO = "showXXELogo";
    static final String SETTING_SEARCH_KEY = "searchKey";
    static final String SETTING_DISABLE_JAVASCRIPT = "disableJavaScript";
    static final String SETTING_TIME_ZONE = "timeZone";
    static final String SETTING_LOCALE = "locale";
    static final String SETTING_CONTENT_DIRECTORY = "contentDirectory";
    static final String SETTING_LOWEST_PAGE_TOC_ELEMENT_RANK = "lowestPageTOCElementRank";
    static final String SETTING_LOWEST_FILE_ELEMENT_RANK = "lowestFileElementRank";
    static final String SETTING_MAX_TOF_DISPLAY_DEPTH = "maxTOFDisplayDepth";
    static final String SETTING_MAX_MAIN_TOF_DISPLAY_DEPTH = "maxMainTOFDisplayDepth";
    static final String SETTING_NUMBERED_SECTIONS = "numberedSections";
    static final String SETTING_VALIDATION_PROGRAMLISTINGS_REQ_ROLE = "programlistingsRequireRole";
    static final String SETTING_VALIDATION_PROGRAMLISTINGS_REQ_LANG = "programlistingsRequireLanguage";
    static final String SETTING_VALIDATION_OUTPUT_FILES_CAN_USE_AUTOID = "outputFilesCanUseAutoID";
    static final String SETTING_VALIDATION_MAXIMUM_PROGRAMLISTING_WIDTH = "maximumProgramlistingWidth";
    static final String SETTING_ECLIPSE_LINK_TO = "link_to";
    static final String SETTING_SEO_META_KEY_TITLE = "title";
    static final String SETTING_SEO_META_KEY_FULL_TITLE = "fullTitle";
    static final String SETTING_SEO_META_KEY_DESCRIPTION = "description";
    static final Set<String> SETTING_SEO_META_KEYS = new LinkedHashSet<String>();
    static final String COMMON_LINK_KEY_CLASS = "class";
    static final String COMMON_LINK_KEY_HREF = "href";
    static final Set<String> COMMON_LINK_KEYS;
    private static final String VAR_OFFLINE = "offline";
    private static final String VAR_SIMPLE_NAVIGATION_MODE = "simpleNavigationMode";
    private static final String VAR_DEPLOY_URL = "deployUrl";
    private static final String VAR_ONLINE_TRACKER_HTML = "onlineTrackerHTML";
    private static final String VAR_COOKIE_CONSENT_SCRIPT_URL = "cookieConsentScriptURL";
    private static final String VAR_COPYRIGHT_COMMENT = "copyrightComment";
    private static final String VAR_COPYRIGHT_JAVA_COMMENT = "copyrightJavaComment";
    private static final String VAR_SHOW_EDITORAL_NOTES = "showEditoralNotes";
    private static final String VAR_TRANSFORM_START_TIME = "transformStartTime";
    private static final String VAR_SHOW_XXE_LOGO = "showXXELogo";
    private static final String VAR_SEARCH_KEY = "searchKey";
    private static final String VAR_DISABLE_JAVASCRIPT = "disableJavaScript";
    private static final String VAR_ECLIPSE_LINK_TO = "link_to";
    private static final String VAR_INTERNAL_BOOKMARDS = "internalBookmarks";
    private static final String VAR_EXTERNAL_BOOKMARDS = "externalBookmarks";
    private static final String VAR_LOGO = "logo";
    private static final String VAR_SIDE_TOC_LOGOS = "sideTOCLogos";
    private static final String VAR_COPYRIGHT_HOLDER = "copyrightHolder";
    private static final String VAR_COPYRIGHT_HOLDER_SITE = "copyrightHolderSite";
    private static final String VAR_COPYRIGHT_START_YEAR = "copyrightStartYear";
    private static final String VAR_COPYRIGHT_SUFFIX = "copyrightSuffix";
    private static final String VAR_SEO_META_TITLE_OVERRIDE = "seoMetaTitleOverride";
    private static final String VAR_SEO_META_FULL_TITLE_OVERRIDE = "seoMetaFullTitleOverride";
    private static final String VAR_SEO_META_DESCRIPTION = "seoMetaDescription";
    private static final String VAR_TABS = "tabs";
    private static final String VAR_SECONDARY_TABS = "secondaryTabs";
    private static final String VAR_SOCIAL_LINKS = "socialLinks";
    private static final String VAR_FOOTER_SITEMAP = "footerSiteMap";
    private static final String VAR_OLINKS = "olinks";
    private static final String VAR_TOC_DISPLAY_DEPTH = "maxTOFDisplayDepth";
    private static final String VAR_NUMBERED_SECTIONS = "numberedSections";
    private static final String VAR_INDEX_ENTRIES = "indexEntries";
    private static final String VAR_PAGE_TYPE = "pageType";
    private static final String VAR_ALTERNATIVE_TOC_LINK = "alternativeTOCLink";
    private static final String VAR_ALTERNATIVE_TOC_LABEL = "alternativeTOCLabel";
    private static final String VAR_PARENT_FILE_ELEMENT = "parentFileElement";
    private static final String VAR_NEXT_FILE_ELEMENT = "nextFileElement";
    private static final String VAR_PREVIOUS_FILE_ELEMENT = "previousFileElement";
    private static final String VAR_ROOT_ELEMENT = "rootElement";
    private static final String VAR_SHOW_NAVIGATION_BAR = "showNavigationBar";
    private static final String VAR_SHOW_BREADCRUMB = "showBreadCrumb";
    private static final String VAR_JSON_TOC_ROOT = "tocRoot";
    private static final String PAGE_TYPE_DETAILED_TOC = "docgen:detailed_toc";
    private static final String PAGE_TYPE_SEARCH_RESULTS = "docgen:search_results";
    private static final String OLINK_SCHEMA_START = "olink:";
    private static final String ID_SCHEMA_START = "id:";
    private static final Charset UTF_8;
    static final String SYSPROP_GENERATION_TIME = "docgen.generationTime";
    private static final String A_DOCGEN_FILE_ELEMENT = "docgen_file_element";
    private static final String A_DOCGEN_PAGE_TOC_ELEMENT = "docgen_page_toc_element";
    private static final String A_DOCGEN_DETAILED_TOC_ELEMENT = "docgen_detailed_toc_element";
    private static final String A_DOCGEN_ROOT_ELEMENT = "docgen_root_element";
    private static final String A_DOCGEN_TITLE_PREFIX = "docgen_title_prefix";
    private static final String A_DOCGEN_UNITED_NUMBERING = "docgen_united_numbering";
    private static final String A_DOCGEN_RANK = "docgen_rank";
    private static final String A_DOCGEN_NOT_ADDRESSABLE = "docgen_not_addressable";
    private static final String AV_INDEX_ROLE = "index.html";
    static final String AUTO_ID_PREFIX = "autoid_";
    static final String DOCGEN_ID_PREFIX = "docgen_";
    private static final Set<String> GUARANTEED_ID_ELEMENTS;
    private static final Set<String> PREFACE_LIKE_ELEMENTS;
    private static final String XMLNS_DOCGEN = "http://freemarker.org/docgen";
    private static final String E_SEARCHRESULTS = "searchresults";
    private static final String SEARCH_RESULTS_PAGE_TITLE = "Search results";
    private static final String SEARCH_RESULTS_ELEMENT_ID = "searchresults";
    private File destDir;
    private File srcDir;
    private File contentDir;
    private List<Pattern> ignoredFilePathPatterns = new ArrayList<Pattern>();
    private Boolean offline;
    private String deployUrl;
    private String onlineTrackerHTML;
    private String cookieConstentScriptURL;
    private Set<String> removeNodesWhenOnline;
    private DocumentStructureRank lowestFileElemenRank = DocumentStructureRank.SECTION1;
    private DocumentStructureRank lowestPageTOCElemenRank = DocumentStructureRank.SECTION3;
    private int maxTOFDisplayDepth = Integer.MAX_VALUE;
    private int maxMainTOFDisplayDepth;
    private boolean numberedSections;
    private boolean generateEclipseTOC;
    private boolean simpleNavigationMode;
    private boolean showEditoralNotes;
    private boolean showXXELogo;
    private String searchKey;
    private boolean disableJavaScript;
    private boolean validate = true;
    private Locale locale = Locale.US;
    private TimeZone timeZone = TimeZone.getTimeZone("GMT");
    private boolean printProgress;
    private LinkedHashMap<String, String> internalBookmarks = new LinkedHashMap();
    private LinkedHashMap<String, String> externalBookmarks = new LinkedHashMap();
    private Map<String, Map<String, String>> footerSiteMap;
    private LinkedHashMap<String, String> tabs = new LinkedHashMap();
    private Map<String, Map<String, String>> secondaryTabs;
    private Map<String, Map<String, String>> socialLinks;
    private Logo logo;
    private List<Logo> sideTOCLogos;
    private String copyrightHolder;
    private String copyrightHolderSite;
    private String copyrightSuffix;
    private Integer copyrightStartYear;
    private String copyrightComment;
    private String copyrightJavaComment;
    private Map<String, Map<String, String>> seoMeta;
    private DocgenValidationOptions validationOps = new DocgenValidationOptions();
    private boolean executed;
    private Map<String, String> olinks = new HashMap<String, String>();
    private Map<String, List<NodeModel>> primaryIndexTermLookup;
    private Map<String, SortedMap<String, List<NodeModel>>> secondaryIndexTermLookup;
    private Map<String, Element> elementsById;
    private List<TOCNode> tocNodes;
    private List<String> indexEntries;
    private Configuration fmConfig;
    private TOCNode currentFileTOCNode;
    private DocgenLogger logger = new DocgenLogger(){

        @Override
        public void info(String message) {
            if (Transform.this.printProgress) {
                System.out.println(message);
            }
        }

        @Override
        public void warning(String message) {
            if (Transform.this.printProgress) {
                System.out.println("Warning:" + message);
            }
        }
    };
    private static final String COMMON_TOC_TOPOLOGY_ERROR_HINT = " (Hint: Review the \"lowestPageTOCElementRank\" setting. Maybe it's incompatible with the structure of this document.)";
    private static final String COMMON_FILE_TOPOLOGY_ERROR_HINT = " (Hint: Review the \"lowestFileElementRank\" setting. Maybe it's incompatible with the structure of this document.)";
    private TemplateMethodModelEx createLinkFromID = new TemplateMethodModelEx(){

        public Object exec(List args) throws TemplateModelException {
            if (args.size() != 1) {
                throw new TemplateModelException("Method CreateLinkFromID should have exactly one parameter.");
            }
            String id = Transform.this.getArgString(args, 0);
            try {
                return Transform.this.createLinkFromId(id);
            }
            catch (DocgenException e) {
                throw new TemplateModelException("Can't resolve id " + StringUtil.jQuote((String)id) + " to URL", (Exception)e);
            }
        }
    };
    private TemplateMethodModelEx createLinkFromNode = new TemplateMethodModelEx(){

        public Object exec(List args) throws TemplateModelException {
            if (args.size() != 1) {
                throw new TemplateModelException("Method CreateLinkFromNode should have exactly one parameter.");
            }
            Object arg1 = args.get(0);
            if (!(arg1 instanceof NodeModel)) {
                throw new TemplateModelException("The first parameter to CreateLinkFromNode must be a node, but it wasn't. (Class: " + arg1.getClass().getName() + ")");
            }
            Node node = ((NodeModel)arg1).getNode();
            if (!(node instanceof Element)) {
                throw new TemplateModelException("The first parameter to CreateLinkFromNode must be an element node, but it wasn't. (Class: " + arg1.getClass().getName() + ")");
            }
            try {
                String url = Transform.this.createElementLinkURL((Element)node);
                return url != null ? new SimpleScalar(url) : null;
            }
            catch (DocgenException e) {
                throw new TemplateModelException("CreateLinkFromNode falied to create link.", (Exception)e);
            }
        }
    };
    private TemplateMethodModelEx nodeFromID = new TemplateMethodModelEx(){

        public Object exec(List args) throws TemplateModelException {
            Node node = (Node)Transform.this.elementsById.get(Transform.this.getArgString(args, 0));
            return NodeModel.wrap((Node)node);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws DocgenException, IOException, SAXException {
        File docFile;
        if (this.executed) {
            throw new DocgenException("This transformation was alrady executed; use a new " + Transform.class.getName() + ".");
        }
        this.executed = true;
        if (this.srcDir == null) {
            throw new DocgenException("The source directory (the DocBook XML) wasn't specified.");
        }
        if (!this.srcDir.isDirectory()) {
            throw new IOException("Source directory doesn't exist: " + this.srcDir.getAbsolutePath());
        }
        if (this.destDir == null) {
            throw new DocgenException("The destination directory wasn't specified.");
        }
        File templatesDir = null;
        String eclipseLinkTo = null;
        File cfgFile = new File(this.srcDir, FILE_SETTINGS);
        if (cfgFile.exists()) {
            Map<String, Object> cfg;
            try {
                cfg = CJSONInterpreter.evalAsMap(cfgFile);
            }
            catch (CJSONInterpreter.EvaluationException e) {
                throw new DocgenException(e.getMessage(), e.getCause());
            }
            for (Map.Entry<String, Object> cfgEnt : cfg.entrySet()) {
                String s2;
                Map<String, String> v;
                String k;
                String eol;
                String target;
                String name;
                Map<String, Object> m;
                String settingName = cfgEnt.getKey();
                Object object = cfgEnt.getValue();
                if (settingName.equals(SETTING_IGNORED_FILES)) {
                    List<String> patterns = this.castSettingToStringList(cfgFile, settingName, object);
                    for (String pattern : patterns) {
                        this.ignoredFilePathPatterns.add(FileUtil.globToRegexp(pattern));
                    }
                    continue;
                }
                if (settingName.equals("olinks")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        target = this.castSettingValueMapValueToString(cfgFile, settingName, ent.getValue());
                        this.olinks.put(name, target);
                    }
                    continue;
                }
                if (settingName.equals("internalBookmarks")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        target = this.castSettingValueMapValueToString(cfgFile, settingName, ent.getValue());
                        this.internalBookmarks.put(name, target);
                    }
                    continue;
                }
                if (settingName.equals("externalBookmarks")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        target = this.castSettingValueMapValueToString(cfgFile, settingName, ent.getValue());
                        this.externalBookmarks.put(name, target);
                    }
                    continue;
                }
                if (settingName.equals("logo")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    this.logo = this.castMapToLogo(cfgFile, settingName, m);
                    continue;
                }
                if (settingName.equals("sideTOCLogos")) {
                    void var10_48;
                    List<Map<String, Object>> listOfMaps = this.castSettingToListOfMapsWithStringKeys(cfgFile, settingName, object);
                    this.sideTOCLogos = new ArrayList<Logo>();
                    boolean bl = false;
                    while (var10_48 < listOfMaps.size()) {
                        Map<String, Object> map = listOfMaps.get((int)var10_48);
                        this.sideTOCLogos.add(this.castMapToLogo(cfgFile, settingName + "[" + (int)var10_48 + "]", map));
                        ++var10_48;
                    }
                    continue;
                }
                if (settingName.equals("copyrightHolder")) {
                    this.copyrightHolder = this.castSettingToString(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("copyrightHolderSite")) {
                    this.copyrightHolderSite = this.castSettingToString(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("copyrightStartYear")) {
                    this.copyrightStartYear = this.castSettingToInt(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("copyrightSuffix")) {
                    this.copyrightSuffix = this.castSettingToString(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals(SETTING_COPYRIGHT_COMMENT_FILE)) {
                    this.copyrightComment = StringUtil.chomp((String)this.getFileContentForSetting(cfgFile, settingName, object));
                    eol = TextUtil.detectEOL(this.copyrightComment, "\n");
                    StringBuilder stringBuilder = new StringBuilder("/*").append(eol);
                    new BufferedReader(new StringReader(this.copyrightComment)).lines().forEach(s -> sb.append(" * ").append((String)s).append(eol));
                    stringBuilder.append(" */");
                    this.copyrightJavaComment = stringBuilder.toString();
                    continue;
                }
                if (settingName.equals(SETTING_SEO_META)) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    this.seoMeta = new LinkedHashMap<String, Map<String, String>>();
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        k = ent.getKey();
                        v = this.castSettingValueMapValueToMapOfStringString(cfgFile, settingName, ent.getValue(), null, SETTING_SEO_META_KEYS);
                        this.seoMeta.put(k, v);
                    }
                    continue;
                }
                if (settingName.equals("tabs")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        k = ent.getKey();
                        v = this.castSettingValueMapValueToString(cfgFile, settingName, ent.getValue());
                        this.tabs.put(k, (String)((Object)v));
                    }
                    continue;
                }
                if (settingName.equals("secondaryTabs")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    this.secondaryTabs = new LinkedHashMap<String, Map<String, String>>();
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        k = ent.getKey();
                        v = this.castSettingValueMapValueToMapOfStringString(cfgFile, settingName, ent.getValue(), COMMON_LINK_KEYS, null);
                        this.secondaryTabs.put(k, v);
                    }
                    continue;
                }
                if (settingName.equals("socialLinks")) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    this.socialLinks = new LinkedHashMap<String, Map<String, String>>();
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        String entName = ent.getKey();
                        Map<String, String> entValue = this.castSettingValueMapValueToMapOfStringString(cfgFile, settingName, ent.getValue(), COMMON_LINK_KEYS, null);
                        this.socialLinks.put(entName, entValue);
                    }
                    continue;
                }
                if (settingName.equals("footerSiteMap")) {
                    this.footerSiteMap = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals(SETTING_VALIDATION)) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, SETTING_VALIDATION, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        if (name.equals(SETTING_VALIDATION_PROGRAMLISTINGS_REQ_ROLE)) {
                            this.validationOps.setProgramlistingRequiresRole(this.caseSettingToBoolean(cfgFile, settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        if (name.equals(SETTING_VALIDATION_PROGRAMLISTINGS_REQ_LANG)) {
                            this.validationOps.setProgramlistingRequiresLanguage(this.caseSettingToBoolean(cfgFile, settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        if (name.equals(SETTING_VALIDATION_OUTPUT_FILES_CAN_USE_AUTOID)) {
                            this.validationOps.setOutputFilesCanUseAutoID(this.caseSettingToBoolean(cfgFile, settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        if (name.equals(SETTING_VALIDATION_MAXIMUM_PROGRAMLISTING_WIDTH)) {
                            this.validationOps.setMaximumProgramlistingWidth(this.castSettingToInt(cfgFile, settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        throw this.newCfgFileException(cfgFile, SETTING_VALIDATION, "Unknown validation option: " + name);
                    }
                    continue;
                }
                if (settingName.equals("offline")) {
                    if (this.offline != null) continue;
                    this.offline = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("simpleNavigationMode")) {
                    this.simpleNavigationMode = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("deployUrl")) {
                    this.deployUrl = this.castSettingToString(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("onlineTrackerHTML")) {
                    String string;
                    int commentEnd;
                    this.onlineTrackerHTML = this.getFileContentForSetting(cfgFile, settingName, object);
                    if (this.onlineTrackerHTML.startsWith("<!--") && (commentEnd = this.onlineTrackerHTML.indexOf("-->")) != -1 && ((string = this.onlineTrackerHTML.substring(0, commentEnd += 3)).contains("copyright") || string.contains("Copyright"))) {
                        this.onlineTrackerHTML = this.onlineTrackerHTML.substring(commentEnd);
                    }
                    eol = TextUtil.detectEOL(this.onlineTrackerHTML, "\n");
                    this.onlineTrackerHTML = this.onlineTrackerHTML.trim();
                    this.onlineTrackerHTML = this.onlineTrackerHTML + eol;
                    continue;
                }
                if (settingName.equals("cookieConsentScriptURL")) {
                    this.cookieConstentScriptURL = this.castSettingToString(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals(SETTING_REMOVE_NODES_WHEN_ONLINE)) {
                    this.removeNodesWhenOnline = Collections.unmodifiableSet(new HashSet<String>(this.castSettingToStringList(cfgFile, settingName, object)));
                    continue;
                }
                if (settingName.equals(SETTING_ECLIPSE)) {
                    m = this.castSettingToMapWithStringKeys(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        if (name.equals("link_to")) {
                            String value;
                            eclipseLinkTo = value = this.castSettingToString(cfgFile, settingName + "." + name, ent.getValue());
                            continue;
                        }
                        throw this.newCfgFileException(cfgFile, settingName, "Unknown Eclipse option: " + name);
                    }
                    continue;
                }
                if (settingName.equals(SETTING_LOCALE)) {
                    String s22 = this.castSettingToString(cfgFile, settingName, object);
                    this.locale = StringUtil.deduceLocale((String)s22);
                    continue;
                }
                if (settingName.equals(SETTING_TIME_ZONE)) {
                    s2 = this.castSettingToString(cfgFile, settingName, object);
                    this.timeZone = TimeZone.getTimeZone(s2);
                    continue;
                }
                if (settingName.equals(SETTING_GENERATE_ECLIPSE_TOC)) {
                    this.generateEclipseTOC = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("showEditoralNotes")) {
                    this.showEditoralNotes = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("showXXELogo")) {
                    this.showXXELogo = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("searchKey")) {
                    this.searchKey = this.castSettingToString(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("disableJavaScript")) {
                    this.disableJavaScript = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals(SETTING_CONTENT_DIRECTORY)) {
                    s2 = this.castSettingToString(cfgFile, settingName, object);
                    this.contentDir = new File(this.srcDir, s2);
                    if (this.contentDir.isDirectory()) continue;
                    throw this.newCfgFileException(cfgFile, settingName, "It's not an existing directory: " + this.contentDir.getAbsolutePath());
                }
                if (settingName.equals(SETTING_LOWEST_FILE_ELEMENT_RANK) || settingName.equals(SETTING_LOWEST_PAGE_TOC_ELEMENT_RANK)) {
                    DocumentStructureRank rank;
                    String string = this.castSettingToString(cfgFile, settingName, object);
                    try {
                        rank = DocumentStructureRank.valueOf(string.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        String msg = string.equalsIgnoreCase("article") ? "\"article\" is not a rank, since articles can have various ranks depending on their context. (Hint: if the article is the top-level element then it has \"chapter\" rank.)" : "Unknown rank: " + string;
                        throw this.newCfgFileException(cfgFile, settingName, msg);
                    }
                    if (settingName.equals(SETTING_LOWEST_FILE_ELEMENT_RANK)) {
                        this.lowestFileElemenRank = rank;
                        continue;
                    }
                    if (settingName.equals(SETTING_LOWEST_PAGE_TOC_ELEMENT_RANK)) {
                        this.lowestPageTOCElemenRank = rank;
                        continue;
                    }
                    throw new BugException("Unexpected setting name.");
                }
                if (settingName.equals("maxTOFDisplayDepth")) {
                    this.maxTOFDisplayDepth = this.castSettingToInt(cfgFile, settingName, object);
                    if (this.maxTOFDisplayDepth >= 1) continue;
                    throw this.newCfgFileException(cfgFile, settingName, "Value must be at least 1.");
                }
                if (settingName.equals(SETTING_MAX_MAIN_TOF_DISPLAY_DEPTH)) {
                    this.maxMainTOFDisplayDepth = this.castSettingToInt(cfgFile, settingName, object);
                    if (this.maxTOFDisplayDepth >= 1) continue;
                    throw this.newCfgFileException(cfgFile, settingName, "Value must be at least 1.");
                }
                if (settingName.equals("numberedSections")) {
                    this.numberedSections = this.caseSettingToBoolean(cfgFile, settingName, object);
                    continue;
                }
                throw this.newCfgFileException(cfgFile, "Unknown setting: \"" + settingName + "\". (Hint: See the list of available settings in the Java API documentation of " + Transform.class.getName() + ". Also, note that setting names are case-sensitive.)");
            }
            if (this.deployUrl == null) {
                throw new DocgenException("The \"deployUrl\" setting wasn't specified");
            }
            if (this.offline == null) {
                throw new DocgenException("The \"offline\" setting wasn't specified; it must be set to true or false");
            }
            if (this.logo == null) {
                throw new DocgenException("The \"logo\" setting wasn't specified; it must be set currently, as the layout reserves space for it.");
            }
            if (this.copyrightHolder == null) {
                throw new DocgenException("The \"copyrightHolder\" setting wasn't specified.");
            }
            if (this.copyrightHolderSite == null) {
                throw new DocgenException("The \"copyrightHolderSite\" setting wasn't specified.");
            }
            if (this.copyrightStartYear == null) {
                throw new DocgenException("The \"copyrightStartYear\" setting wasn't specified.");
            }
        }
        if (this.lowestPageTOCElemenRank.compareTo(this.lowestFileElemenRank) > 0) {
            this.lowestPageTOCElemenRank = this.lowestFileElemenRank;
        }
        if (this.maxMainTOFDisplayDepth == 0) {
            this.maxMainTOFDisplayDepth = this.maxTOFDisplayDepth;
        }
        if (!(templatesDir = new File(this.srcDir, DIR_TEMPLATES)).exists()) {
            templatesDir = null;
        }
        if (this.contentDir == null) {
            this.contentDir = this.srcDir;
        }
        this.primaryIndexTermLookup = new HashMap<String, List<NodeModel>>();
        this.secondaryIndexTermLookup = new HashMap<String, SortedMap<String, List<NodeModel>>>();
        this.elementsById = new HashMap<String, Element>();
        this.tocNodes = new ArrayList<TOCNode>();
        this.indexEntries = new ArrayList<String>();
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            throw new BugException(e);
        }
        this.logger.info("Using FreeMarker " + Configuration.getVersion());
        this.fmConfig = new Configuration(Configuration.VERSION_2_3_25);
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(Transform.class, "templates");
        if (templatesDir != null) {
            templateLoader = new MultiTemplateLoader(new TemplateLoader[]{new FileTemplateLoader(templatesDir), templateLoader});
        }
        this.fmConfig.setTemplateLoader((TemplateLoader)templateLoader);
        this.fmConfig.setLocale(this.locale);
        this.fmConfig.setTimeZone(this.timeZone);
        this.fmConfig.setDefaultEncoding(UTF_8.name());
        this.fmConfig.setOutputEncoding(UTF_8.name());
        File docFile1 = new File(this.contentDir, FILE_BOOK);
        if (docFile1.isFile()) {
            docFile = docFile1;
        } else {
            File docFile2 = new File(this.contentDir, FILE_ARTICLE);
            if (docFile2.isFile()) {
                docFile = docFile2;
            } else {
                throw new DocgenException("The book file is missing: " + docFile1.getAbsolutePath() + " or " + docFile2.getAbsolutePath());
            }
        }
        Document doc = XMLUtil.loadDocBook5XML(docFile, this.validate, this.validationOps, this.logger);
        this.ignoredFilePathPatterns.add(FileUtil.globToRegexp(docFile.getName()));
        this.preprocessDOM(doc);
        if (this.olinks != null) {
            for (Map.Entry<String, String> entry : this.olinks.entrySet()) {
                entry.setValue(this.resolveDocgenURL("olinks", entry.getValue()));
            }
        }
        if (this.tabs != null) {
            for (Map.Entry entry : this.tabs.entrySet()) {
                entry.setValue(this.resolveDocgenURL("tabs", (String)entry.getValue()));
            }
        }
        if (this.secondaryTabs != null) {
            for (Map map : this.secondaryTabs.values()) {
                map.put("href", this.resolveDocgenURL("secondaryTabs", (String)map.get("href")));
            }
        }
        if (this.externalBookmarks != null) {
            for (Map.Entry entry : this.externalBookmarks.entrySet()) {
                entry.setValue(this.resolveDocgenURL("externalBookmarks", (String)entry.getValue()));
            }
        }
        if (this.socialLinks != null) {
            for (Map map : this.socialLinks.values()) {
                map.put("href", this.resolveDocgenURL("socialLinks", (String)map.get("href")));
            }
        }
        if (this.footerSiteMap != null) {
            for (Map map : this.footerSiteMap.values()) {
                for (Map.Entry entry : map.entrySet()) {
                    entry.setValue(this.resolveDocgenURL("footerSiteMap", (String)entry.getValue()));
                }
            }
        }
        if (this.logo != null) {
            this.resolveLogoHref(this.logo);
        }
        if (this.sideTOCLogos != null) {
            for (Logo logo : this.sideTOCLogos) {
                this.resolveLogoHref(logo);
            }
        }
        if (!this.destDir.isDirectory() && !this.destDir.mkdirs()) {
            throw new IOException("Failed to create destination directory: " + this.destDir.getAbsolutePath());
        }
        for (Map.Entry entry : this.internalBookmarks.entrySet()) {
            String id = (String)entry.getValue();
            if (this.elementsById.containsKey(id)) continue;
            throw this.newCfgFileException(cfgFile, "internalBookmarks", "No element with id \"" + id + "\" exists in the book.");
        }
        try {
            Date generationTime;
            this.fmConfig.setSharedVariable("offline", (Object)this.offline);
            this.fmConfig.setSharedVariable("simpleNavigationMode", (Object)this.simpleNavigationMode);
            this.fmConfig.setSharedVariable("deployUrl", (Object)this.deployUrl);
            this.fmConfig.setSharedVariable("onlineTrackerHTML", (Object)this.onlineTrackerHTML);
            this.fmConfig.setSharedVariable("cookieConsentScriptURL", (Object)this.cookieConstentScriptURL);
            this.fmConfig.setSharedVariable("showEditoralNotes", (Object)this.showEditoralNotes);
            this.fmConfig.setSharedVariable("showXXELogo", (Object)this.showXXELogo);
            this.fmConfig.setSharedVariable("searchKey", (Object)this.searchKey);
            this.fmConfig.setSharedVariable("disableJavaScript", (Object)this.disableJavaScript);
            this.fmConfig.setSharedVariable("olinks", this.olinks);
            this.fmConfig.setSharedVariable("numberedSections", (Object)this.numberedSections);
            this.fmConfig.setSharedVariable("logo", (Object)this.logo);
            this.fmConfig.setSharedVariable("sideTOCLogos", this.sideTOCLogos);
            this.fmConfig.setSharedVariable("copyrightHolder", (Object)this.copyrightHolder);
            this.fmConfig.setSharedVariable("copyrightHolderSite", (Object)this.copyrightHolderSite);
            this.fmConfig.setSharedVariable("copyrightSuffix", (Object)this.copyrightSuffix);
            this.fmConfig.setSharedVariable("copyrightStartYear", (Object)this.copyrightStartYear);
            this.fmConfig.setSharedVariable(VAR_COPYRIGHT_COMMENT, (Object)this.copyrightComment);
            this.fmConfig.setSharedVariable(VAR_COPYRIGHT_JAVA_COMMENT, (Object)this.copyrightJavaComment);
            this.fmConfig.setSharedVariable("tabs", this.tabs);
            this.fmConfig.setSharedVariable("secondaryTabs", this.secondaryTabs);
            this.fmConfig.setSharedVariable("socialLinks", this.socialLinks);
            this.fmConfig.setSharedVariable("footerSiteMap", this.footerSiteMap);
            this.fmConfig.setSharedVariable("externalBookmarks", this.externalBookmarks);
            this.fmConfig.setSharedVariable("internalBookmarks", this.internalBookmarks);
            this.fmConfig.setSharedVariable(VAR_ROOT_ELEMENT, (Object)doc.getDocumentElement());
            String string = System.getProperty(SYSPROP_GENERATION_TIME);
            if (string == null) {
                generationTime = new Date();
            } else {
                try {
                    generationTime = DateUtil.parseISO8601DateTime((String)string, (TimeZone)DateUtil.UTC, (DateUtil.CalendarFieldsToDateConverter)new DateUtil.TrivialCalendarFieldsToDateConverter());
                }
                catch (DateUtil.DateParseException e) {
                    throw new DocgenException("Malformed \"docgen.generationTime\" system property value: " + string, e);
                }
            }
            this.fmConfig.setSharedVariable(VAR_TRANSFORM_START_TIME, (Object)generationTime);
            this.fmConfig.setSharedVariable(VAR_INDEX_ENTRIES, this.indexEntries);
            int tofCntLv1 = this.countTOFEntries(this.tocNodes.get(0), 1);
            int n = this.countTOFEntries(this.tocNodes.get(0), 2);
            this.fmConfig.setSharedVariable(VAR_SHOW_NAVIGATION_BAR, (Object)(tofCntLv1 != 0 || this.internalBookmarks.size() != 0 || this.externalBookmarks.size() != 0 ? 1 : 0));
            this.fmConfig.setSharedVariable(VAR_SHOW_BREADCRUMB, (Object)(tofCntLv1 != n ? 1 : 0));
            this.fmConfig.setSharedVariable("NodeFromID", (TemplateModel)this.nodeFromID);
            this.fmConfig.setSharedVariable("CreateLinkFromID", (TemplateModel)this.createLinkFromID);
            this.fmConfig.setSharedVariable("primaryIndexTermLookup", this.primaryIndexTermLookup);
            this.fmConfig.setSharedVariable("secondaryIndexTermLookup", this.secondaryIndexTermLookup);
            this.fmConfig.setSharedVariable("CreateLinkFromNode", (TemplateModel)this.createLinkFromNode);
        }
        catch (TemplateModelException e) {
            throw new BugException(e);
        }
        this.logger.info("Generating ToC JSON...");
        Template template = this.fmConfig.getTemplate(FILE_TOC_JSON_TEMPLATE);
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.destDir, FILE_TOC_JSON_OUTPUT)), UTF_8));){
            try {
                SimpleHash simpleHash = new SimpleHash(this.fmConfig.getObjectWrapper());
                simpleHash.put(VAR_JSON_TOC_ROOT, (Object)this.tocNodes.get(0));
                template.process((Object)simpleHash, (Writer)bufferedWriter, null, (TemplateNodeModel)NodeModel.wrap((Node)doc));
            }
            catch (TemplateException templateException) {
                throw new BugException("Failed to generate ToC JSON (see cause exception).", templateException);
            }
        }
        this.logger.info("Generating Sitemap XML...");
        template = this.fmConfig.getTemplate(FILE_SITEMAP_XML_TEMPLATE);
        e = null;
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.destDir, FILE_SITEMAP_XML_OUTPUT)), UTF_8));){
            try {
                SimpleHash simpleHash = new SimpleHash(this.fmConfig.getObjectWrapper());
                simpleHash.put(VAR_JSON_TOC_ROOT, (Object)this.tocNodes.get(0));
                template.process((Object)simpleHash, (Writer)bufferedWriter, null, (TemplateNodeModel)NodeModel.wrap((Node)doc));
            }
            catch (TemplateException templateException) {
                throw new BugException("Failed to generate Sitemap XML(see cause exception).", templateException);
            }
        }
        catch (Throwable throwable) {
            e = throwable;
            throw throwable;
        }
        this.logger.info("Generating HTML files...");
        int htmlFileCounter = 0;
        for (TOCNode tocNode : this.tocNodes) {
            if (tocNode.getOutputFileName() == null) continue;
            try {
                this.currentFileTOCNode = tocNode;
                try {
                    htmlFileCounter += this.generateHTMLFile();
                }
                finally {
                    this.currentFileTOCNode = null;
                }
            }
            catch (StopException stopException) {
                throw new DocgenException(stopException.getMessage());
            }
            catch (TemplateException templateException) {
                throw new BugException(templateException);
            }
        }
        if (!this.offline.booleanValue() && this.searchKey != null) {
            try {
                this.generateSearchResultsHTMLFile(doc);
                ++htmlFileCounter;
            }
            catch (StopException stopException) {
                throw new DocgenException(stopException.getMessage());
            }
            catch (TemplateException templateException) {
                throw new BugException(templateException);
            }
        }
        this.logger.info("Copying common static files...");
        this.copyCommonStatic("docgen.min.css");
        this.copyCommonStatic("img/patterned-bg.png");
        this.copyCommonStatic("fonts/icomoon.eot");
        this.copyCommonStatic("fonts/icomoon.svg");
        this.copyCommonStatic("fonts/icomoon.ttf");
        this.copyCommonStatic("fonts/icomoon.woff");
        this.copyCommonStatic("fonts/NOTICE");
        if (this.showXXELogo) {
            this.copyCommonStatic("img/xxe.png");
        }
        if (!this.disableJavaScript) {
            this.copyCommonStatic("main.min.js");
        }
        this.logger.info("Copying custom static files...");
        int n = FileUtil.copyDir(this.contentDir, this.destDir, this.ignoredFilePathPatterns);
        if (this.generateEclipseTOC) {
            if (this.simpleNavigationMode) {
                throw new DocgenException("Eclipse ToC generation is untested/unsupported with simpleNavigationMode=true.");
            }
            this.logger.info("Generating Eclipse ToC...");
            Template template2 = this.fmConfig.getTemplate(FILE_ECLIPSE_TOC_TEMPLATE);
            try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.destDir, FILE_ECLIPSE_TOC_OUTPUT)), UTF_8));){
                try {
                    SimpleHash dataModel2 = new SimpleHash(this.fmConfig.getObjectWrapper());
                    if (eclipseLinkTo != null) {
                        dataModel2.put("link_to", (Object)eclipseLinkTo);
                    }
                    template2.process((Object)dataModel2, (Writer)bufferedWriter, null, (TemplateNodeModel)NodeModel.wrap((Node)doc));
                }
                catch (TemplateException e) {
                    throw new BugException("Failed to generate Eclipse ToC (see cause exception).", e);
                }
            }
        }
        this.logger.info("Done: " + htmlFileCounter + " HTML-s + " + n + " custom statics + commons" + (this.generateEclipseTOC ? " + Eclipse ToC" : ""));
    }

    private void resolveLogoHref(Logo logo) throws DocgenException {
        String logoHref = logo.getHref();
        if (logoHref != null) {
            logo.setHref(this.resolveDocgenURL("logo", logoHref));
        }
    }

    private String resolveDocgenURL(String settingName, String url) throws DocgenException {
        if (url.startsWith(OLINK_SCHEMA_START)) {
            String oLinkName = url.substring(OLINK_SCHEMA_START.length());
            String resolvedOLink = this.olinks.get(oLinkName);
            if (resolvedOLink == null) {
                throw new DocgenException("Undefined olink used inside configuration setting " + StringUtil.jQuote((String)settingName) + ": " + StringUtil.jQuote((String)oLinkName));
            }
            return this.resolveDocgenURL(settingName, resolvedOLink);
        }
        if (url.startsWith(ID_SCHEMA_START)) {
            String id = url.substring(ID_SCHEMA_START.length());
            try {
                return this.createLinkFromId(id);
            }
            catch (DocgenException e) {
                throw new DocgenException("Can't resolve id inside configuration setting " + StringUtil.jQuote((String)settingName) + ": " + StringUtil.jQuote((String)id), e);
            }
        }
        return url;
    }

    private DocgenException newCfgFileException(File cfgFile, String settingName, String desc) {
        settingName = settingName.replace(".", "\" per \"");
        return this.newCfgFileException(cfgFile, "Wrong value for setting \"" + settingName + "\": " + desc);
    }

    private DocgenException newCfgFileException(File cfgFile, String desc) {
        return this.newCfgFileException(cfgFile, desc, (Throwable)null);
    }

    private DocgenException newCfgFileException(File cfgFile, String desc, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append("Wrong configuration");
        if (cfgFile != null) {
            sb.append(" file \"");
            sb.append(cfgFile.getAbsolutePath());
            sb.append("\"");
        }
        sb.append(": ");
        sb.append(desc);
        return new DocgenException(sb.toString(), cause);
    }

    private Map<String, Object> castSettingToMapWithStringKeys(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof Map)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a map (like { key1: value1, key2: value2 }), but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        for (Object key : ((Map)settingValue).keySet()) {
            if (key instanceof String) continue;
            throw this.newCfgFileException(cfgFile, settingName, "All keys should be String-s, but one of them is a(n) " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (Map)settingValue;
    }

    private List<String> castSettingToStringList(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        List<?> settingValueAsList = this.castSettingToList(cfgFile, settingName, settingValue);
        for (int i = 0; i < settingValueAsList.size(); ++i) {
            Object listItem = settingValueAsList.get(i);
            if (listItem instanceof String) continue;
            throw this.newCfgFileException(cfgFile, settingName, "Should be a list of String-s (like [\"value1\", \"value2\", ... \"valueN\"]), but at index " + i + " (0-based) there's a " + CJSONInterpreter.cjsonTypeOf(listItem) + ".");
        }
        return (List)settingValue;
    }

    private List<Map<String, Object>> castSettingToListOfMapsWithStringKeys(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        List<?> settingValueAsList = this.castSettingToList(cfgFile, settingName, settingValue);
        for (int i = 0; i < settingValueAsList.size(); ++i) {
            this.castSettingToMapWithStringKeys(cfgFile, settingName + "[" + i + "]", settingValueAsList.get(i));
        }
        return (List)settingValue;
    }

    private List<?> castSettingToList(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof List)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a list (like [value1, value2, ... valueN]), but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (List)settingValue;
    }

    private String castSettingToString(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof String)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a string, but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (String)settingValue;
    }

    private boolean caseSettingToBoolean(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof Boolean)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a boolean (i.e., true or false), but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (Boolean)settingValue;
    }

    private int castSettingToInt(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof Number)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be an number, but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        if (!(settingValue instanceof Integer)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be an integer number (32 bits max), but it's: " + settingValue);
        }
        return (Integer)settingValue;
    }

    private String castSettingValueMapValueToString(File cfgFile, String settingName, Object mapEntryValue) throws DocgenException {
        if (!(mapEntryValue instanceof String)) {
            throw this.newCfgFileException(cfgFile, settingName, "The values in the key-value pairs of this map must be strings, but some of them is a " + CJSONInterpreter.cjsonTypeOf(mapEntryValue) + ".");
        }
        return (String)mapEntryValue;
    }

    private Map<String, String> castSettingValueMapValueToMapOfStringString(File cfgFile, String settingName, Object mapEntryValue, Set<String> requiredKeys, Set<String> optionalKeys) throws DocgenException {
        if (!(mapEntryValue instanceof Map)) {
            throw this.newCfgFileException(cfgFile, settingName, "The values in the key-value pairs of this map must be Map-s, but some of them is a " + CJSONInterpreter.cjsonTypeOf(mapEntryValue) + ".");
        }
        if (requiredKeys == null) {
            requiredKeys = Collections.emptySet();
        }
        if (optionalKeys == null) {
            optionalKeys = Collections.emptySet();
        }
        Map mapEntryValueAsMap = (Map)mapEntryValue;
        for (Map.Entry valueEnt : mapEntryValueAsMap.entrySet()) {
            Object key = valueEnt.getKey();
            if (!(key instanceof String)) {
                throw this.newCfgFileException(cfgFile, settingName, "The values in the key-value pairs of this map must be Map<String, String>-s, but some of the keys is a " + CJSONInterpreter.cjsonTypeOf(mapEntryValue) + ".");
            }
            if (!(valueEnt.getValue() instanceof String)) {
                throw this.newCfgFileException(cfgFile, settingName, "The values in the key-value pairs of this map must be Map<String, String>-s, but some of the values is a " + CJSONInterpreter.cjsonTypeOf(valueEnt.getValue()) + ".");
            }
            if (requiredKeys.contains(key) || optionalKeys.contains(key)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Unsupported key: ");
            sb.append(StringUtil.jQuote(key));
            sb.append(". Supported keys are: ");
            boolean isFirst = true;
            for (String supportedKey : requiredKeys) {
                if (!isFirst) {
                    sb.append(", ");
                } else {
                    isFirst = false;
                }
                sb.append(StringUtil.jQuote((String)supportedKey));
            }
            for (String supportedKey : optionalKeys) {
                if (!isFirst) {
                    sb.append(", ");
                } else {
                    isFirst = false;
                }
                sb.append(StringUtil.jQuote((String)supportedKey));
            }
            throw this.newCfgFileException(cfgFile, settingName, sb.toString());
        }
        for (String requiredKey : requiredKeys) {
            if (mapEntryValueAsMap.containsKey(requiredKey)) continue;
            throw this.newCfgFileException(cfgFile, settingName, "Missing map key from nested Map: " + requiredKey);
        }
        return (Map)mapEntryValue;
    }

    private Logo castMapToLogo(File cfgFile, String settingName, Map<String, Object> map) throws DocgenException {
        Logo logo = new Logo();
        block10: for (Map.Entry<String, Object> ent : map.entrySet()) {
            String key = ent.getKey();
            String value = this.castSettingValueMapValueToString(cfgFile, settingName, ent.getValue());
            switch (key) {
                case "src": {
                    logo.setSrc(value);
                    continue block10;
                }
                case "alt": {
                    logo.setAlt(value);
                    continue block10;
                }
                case "href": {
                    logo.setHref(value);
                    continue block10;
                }
            }
            throw this.newCfgFileException(cfgFile, "logo", "Unknown logo option: " + StringUtil.jQuote((String)key));
        }
        if (logo.getSrc() == null) {
            throw this.newCfgFileException(cfgFile, "logo", "Missing logo option: src");
        }
        if (logo.getAlt() == null) {
            throw this.newCfgFileException(cfgFile, "logo", "Missing logo option: alt");
        }
        if (logo.getHref() == null) {
            throw this.newCfgFileException(cfgFile, "logo", "Missing logo option: href");
        }
        return logo;
    }

    private String getFileContentForSetting(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        String settingValueStr = this.castSettingToString(cfgFile, settingName, settingValue);
        File f = new File(this.getSourceDirectory(), settingValueStr);
        if (!f.exists()) {
            throw this.newCfgFileException(cfgFile, settingName, "File not found: " + f.toPath());
        }
        try {
            return FileUtil.loadString(f, UTF_8);
        }
        catch (IOException e) {
            throw this.newCfgFileException(cfgFile, "Error while reading file for setting \"" + settingName + "\": " + f.toPath(), e);
        }
    }

    private void copyCommonStatic(String staticFileName) throws IOException, DocgenException {
        String resourcePath = "statics/" + staticFileName;
        try (InputStream in = Transform.class.getResourceAsStream(resourcePath);){
            if (in == null) {
                throw new IOException("Failed to open class-loader resource: " + resourcePath + " relatively to " + Transform.class.getPackage().getName());
            }
            if (staticFileName.endsWith(".css") || staticFileName.endsWith(".js")) {
                Charset fileCharset = StandardCharsets.ISO_8859_1;
                String content = FileUtil.loadString(in, fileCharset);
                String eol = TextUtil.detectEOL(content, "\n");
                if (content.startsWith("/*")) {
                    int commentEnd = content.indexOf("*/");
                    if (commentEnd == -1) {
                        throw new BugException("Unclosed initial \"/*\" in resource " + resourcePath);
                    }
                    String comment = content.substring(0, commentEnd += 2);
                    if (!(comment.contains("Copyright") || comment.contains("copyright") || comment.contains("License") || comment.contains("license"))) {
                        throw new BugException("The initial /*...*/ comments doesn't look like a copyright header in resource " + resourcePath);
                    }
                    for (int i = 0; i < 2; ++i) {
                        if (commentEnd >= content.length()) continue;
                        char c = content.charAt(commentEnd);
                        if (c == '\n') {
                            ++commentEnd;
                            continue;
                        }
                        if (c != '\r' || ++commentEnd >= content.length() || content.charAt(commentEnd) != '\n') continue;
                        ++commentEnd;
                    }
                    content = content.substring(commentEnd);
                }
                if (this.offline.booleanValue() && this.copyrightComment != null) {
                    StringBuilder sb = new StringBuilder(TextUtil.normalizeEOL(this.copyrightJavaComment, eol));
                    sb.append(eol);
                    if (content.length() > 0 && content.charAt(0) != '\n' && content.charAt(0) != '\r') {
                        sb.append(eol);
                    }
                    sb.append(content);
                    content = sb.toString();
                }
                Path destSubdir = this.destDir.toPath().resolve("docgen-resources");
                Files.createDirectories(destSubdir, new FileAttribute[0]);
                Files.write(destSubdir.resolve(staticFileName), content.getBytes(fileCharset), new OpenOption[0]);
            } else {
                FileUtil.copyResourceIntoFile(Transform.class, "statics", staticFileName, new File(this.destDir, "docgen-resources"));
            }
        }
    }

    private void preprocessDOM(Document doc) throws SAXException, DocgenException {
        NodeModel.simplify((Node)doc);
        this.preprocessDOM_applyRemoveNodesWhenOnlineSetting(doc);
        this.preprocessDOM_addRanks(doc);
        this.preprocessDOM_misc(doc);
        this.preprocessDOM_buildTOC(doc);
    }

    private void preprocessDOM_misc(Document doc) throws SAXException, DocgenException {
        this.preprocessDOM_misc_inner(doc, new PreprocessDOMMisc_GlobalState(), new PreprocessDOMMisc_ParentSectState());
        this.indexEntries = new ArrayList<String>(this.primaryIndexTermLookup.keySet());
        Collections.sort(this.indexEntries, Collator.getInstance(this.locale));
    }

    private void preprocessDOM_misc_inner(Node node, PreprocessDOMMisc_GlobalState globalState, PreprocessDOMMisc_ParentSectState parentSectState) throws SAXException, DocgenException {
        if (node instanceof Element) {
            Element elem = (Element)node;
            String id = XMLUtil.getAttribute(elem, "xml:id");
            if (id != null) {
                if (id.startsWith(AUTO_ID_PREFIX)) {
                    throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " uses a reserved xml:id, " + TextUtil.jQuote(id) + ". All ID-s starting with \"" + AUTO_ID_PREFIX + "\" are reserved for Docgen.");
                }
                if (id.startsWith(DOCGEN_ID_PREFIX)) {
                    throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " uses a reserved xml:id, " + TextUtil.jQuote(id) + ". All ID-s starting with \"" + DOCGEN_ID_PREFIX + "\" are reserved for Docgen.");
                }
                elem.setAttribute("id", id);
            }
            String elemName = node.getNodeName();
            if (id == null && GUARANTEED_ID_ELEMENTS.contains(elemName)) {
                globalState.lastId++;
                id = AUTO_ID_PREFIX + globalState.lastId;
                elem.setAttribute("id", id);
            }
            if (id != null) {
                this.elementsById.put(id, elem);
            }
            if (elemName.equals("preface") || elemName.equals("glossary") || elemName.equals("index")) {
                this.ensureTitleExists(elem, Character.toUpperCase(elemName.charAt(0)) + elemName.substring(1));
            } else if ((elemName.equals("informaltable") || elemName.equals("table")) && elem.getNamespaceURI().equals("http://docbook.org/ns/docbook")) {
                TableSimplifier.simplify(elem);
            } else if (elemName.equals("indexterm")) {
                this.addIndexTerm(node);
            } else if (elemName.equals("imagedata")) {
                String pngRef;
                String ref = XMLUtil.getAttribute(elem, "fileref");
                String loRef = ref.toLowerCase();
                if (!(loRef.startsWith("http://") || loRef.startsWith("https://") || ref.startsWith("/") || new File(this.contentDir, ref.replace('/', File.separatorChar)).isFile())) {
                    throw new DocgenException(XMLUtil.theSomethingElement(elem) + " refers to a missing file: \"" + ref.replace("\"", "&quot;") + "\"");
                }
                if (loRef.endsWith(".svg") && !new File(this.contentDir, (pngRef = ref.substring(0, ref.length() - 4) + ".png").replace('/', File.separatorChar)).isFile()) {
                    throw new DocgenException(XMLUtil.theSomethingElement(elem) + " refers to an SVG file for which the fallback PNG file is missing: \"" + pngRef.replace("\"", "&quot;") + "\"");
                }
            }
            if (DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(elemName)) {
                String prefix = elem.getParentNode() instanceof Document ? null : (this.hasPrefaceLikeParent(elem) ? null : (this.numberedSections && elemName.equals("section") ? String.valueOf(parentSectState.arabicNumber++) : (elemName.equals("chapter") ? String.valueOf(parentSectState.arabicNumber++) : (elemName.equals("part") ? TextUtil.toUpperRomanNumber(parentSectState.upperRomanNumber++) : (elemName.equals("appendix") ? TextUtil.toUpperLatinNumber(parentSectState.upperLatinNumber++) : (elemName.equals("article") ? TextUtil.toLowerRomanNumber(parentSectState.lowerRomanNumber++) : null))))));
                if (prefix != null) {
                    String inhPrefix;
                    Node parent = elem.getParentNode();
                    String fullPrefix = parent instanceof Element && !parent.getLocalName().equals("part") && !parent.getLocalName().equals("article") ? ((inhPrefix = XMLUtil.getAttribute((Element)parent, A_DOCGEN_TITLE_PREFIX)) != null ? (inhPrefix.endsWith(".") ? inhPrefix + prefix : inhPrefix + "." + prefix) : prefix) : prefix;
                    elem.setAttribute(A_DOCGEN_TITLE_PREFIX, fullPrefix);
                }
                elem.setAttribute(A_DOCGEN_UNITED_NUMBERING, String.valueOf(parentSectState.unitedNumber++));
                parentSectState = new PreprocessDOMMisc_ParentSectState();
            }
        }
        NodeList children = node.getChildNodes();
        int ln = children.getLength();
        for (int i = 0; i < ln; ++i) {
            this.preprocessDOM_misc_inner(children.item(i), globalState, parentSectState);
        }
    }

    private void preprocessDOM_applyRemoveNodesWhenOnlineSetting(Document doc) throws DocgenException {
        if (this.offline.booleanValue() || this.removeNodesWhenOnline == null || this.removeNodesWhenOnline.isEmpty()) {
            return;
        }
        HashSet<String> idsToRemoveLeft = new HashSet<String>(this.removeNodesWhenOnline);
        this.preprocessDOM_applyRemoveNodesWhenOnlineSetting_inner(doc.getDocumentElement(), idsToRemoveLeft);
        if (!idsToRemoveLeft.isEmpty()) {
            throw new DocgenException("These xml:id-s, specified in the \"removeNodesWhenOnline\" configuration setting, wasn't found in the document: " + idsToRemoveLeft);
        }
    }

    private void preprocessDOM_applyRemoveNodesWhenOnlineSetting_inner(Element elem, Set<String> idsToRemoveLeft) {
        for (Node child = elem.getFirstChild(); child != null && !idsToRemoveLeft.isEmpty(); child = child.getNextSibling()) {
            Element childElemToBeRemoved = null;
            if (!(child instanceof Element)) continue;
            Element childElem = (Element)child;
            String id = XMLUtil.getAttribute(childElem, "xml:id");
            if (id != null && idsToRemoveLeft.remove(id)) {
                childElemToBeRemoved = childElem;
            }
            if (idsToRemoveLeft.isEmpty()) continue;
            this.preprocessDOM_applyRemoveNodesWhenOnlineSetting_inner(childElem, idsToRemoveLeft);
            if (childElemToBeRemoved == null) continue;
            elem.removeChild(childElemToBeRemoved);
        }
    }

    private void preprocessDOM_addRanks(Document doc) throws DocgenException {
        Element root = doc.getDocumentElement();
        String rootName = root.getLocalName();
        if (rootName.equals("book")) {
            root.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.BOOK.toString());
            this.preprocessDOM_addRanks_underBookRank(root);
        } else if (rootName.equals("article")) {
            root.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.CHAPTER.toString());
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(root, 0);
        } else {
            throw new DocgenException("The \"" + rootName + "\" element is unsupported as root element.");
        }
    }

    private void preprocessDOM_addRanks_underBookRank(Element root) throws DocgenException {
        DocumentStructureRank commonRank = null;
        for (Element child : XMLUtil.childrenElementsOf(root)) {
            String name = child.getLocalName();
            if (name.equals("part")) {
                if (commonRank != null && !commonRank.equals((Object)DocumentStructureRank.PART)) {
                    throw new DocgenException("Bad document structure: " + XMLUtil.theSomethingElement(child) + " is on the same ToC level with a \"" + "chapter" + "\" element.");
                }
                commonRank = DocumentStructureRank.PART;
                continue;
            }
            if (!name.equals("chapter")) continue;
            if (commonRank != null && !commonRank.equals((Object)DocumentStructureRank.CHAPTER)) {
                throw new DocgenException("Bad document structure: " + XMLUtil.theSomethingElement(child) + " is on the same ToC level with a \"" + "part" + "\" element.");
            }
            commonRank = DocumentStructureRank.CHAPTER;
        }
        if (commonRank == null) {
            commonRank = DocumentStructureRank.CHAPTER;
        }
        for (Element child : XMLUtil.childrenElementsOf(root)) {
            if (!DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(child.getLocalName())) continue;
            child.setAttribute(A_DOCGEN_RANK, commonRank.toString());
            if (child.getLocalName().equals("part")) {
                this.preprocessDOM_addRanks_underTruePart(child);
                continue;
            }
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(child, 0);
        }
    }

    private void preprocessDOM_addRanks_underTruePart(Node parent) throws DocgenException {
        for (Element child : XMLUtil.childrenElementsOf(parent)) {
            if (!DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(child.getLocalName())) continue;
            child.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.CHAPTER.toString());
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(child, 0);
        }
    }

    private void preprocessDOM_addRanks_underChapterRankOrDeeper(Element parent, int underSectionRank) throws DocgenException {
        for (Element child : XMLUtil.childrenElementsOf(parent)) {
            if (!DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(child.getLocalName())) continue;
            if (child.getLocalName().equals("simplesect")) {
                child.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.SIMPLESECT.toString());
                continue;
            }
            if (underSectionRank + 1 > 3) {
                throw new DocgenException("Too deep ToC nesting for " + XMLUtil.theSomethingElement(child) + ": rank bellow " + DocumentStructureRank.sectionToString(3));
            }
            child.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.sectionToString(underSectionRank + 1));
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(child, underSectionRank + 1);
        }
    }

    private void preprocessDOM_buildTOC(Document doc) throws DocgenException {
        this.preprocessDOM_buildTOC_inner(doc, 0, null);
        if (this.tocNodes.size() > 0) {
            this.preprocessDOM_buildTOC_checkEnsureHasIndexHhml(this.tocNodes);
            this.preprocessDOM_buildTOC_checkTOCTopology(this.tocNodes.get(0));
            if (!this.tocNodes.get(0).isFileElement()) {
                throw new BugException("The root ToC node must be a file-element.");
            }
            this.preprocessDOM_buildTOC_checkFileTopology(this.tocNodes.get(0));
            if (this.simpleNavigationMode) {
                for (TOCNode tocNode : this.tocNodes) {
                    if (!tocNode.isFileElement() || tocNode.getParent() != null && this.hasContentInTheSameFile(tocNode)) continue;
                    tocNode.setOutputFileName(null);
                    tocNode.getElement().setAttribute(A_DOCGEN_NOT_ADDRESSABLE, "true");
                }
            }
            if (!this.validationOps.getOutputFilesCanUseAutoID()) {
                for (TOCNode tocNode : this.tocNodes) {
                    String outputFileName = tocNode.getOutputFileName();
                    if (outputFileName == null || !outputFileName.startsWith(AUTO_ID_PREFIX)) continue;
                    throw new DocgenException(XMLUtil.theSomethingElement(tocNode.getElement(), true) + " has automatically generated ID that is not allowed as the ID is used for generating a file name. (Related setting: \"" + SETTING_VALIDATION + "\" per \"" + SETTING_VALIDATION_OUTPUT_FILES_CAN_USE_AUTOID + "\")");
                }
            }
        }
    }

    private void preprocessDOM_buildTOC_checkTOCTopology(TOCNode tocNode) throws DocgenException {
        TOCNode parent = tocNode.getParent();
        if (parent != null && !parent.getElement().isSameNode(tocNode.getElement().getParentNode())) {
            throw new DocgenException("Bad ToC-element topology: In the ToC " + parent.theSomethingElement() + " is the parent of " + tocNode.theSomethingElement() + ", yet they are not in parent-child relation in the XML document (but maybe in grandparent-nephew relation or like)." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
        }
        TOCNode next = tocNode.getNext();
        Element relevantSibling = this.preprocessDOM_buildTOC_getSectionLikeSibling(tocNode.getElement(), true);
        if (next != null) {
            if (relevantSibling == null) {
                throw new DocgenException("Bad ToC-element topology: In the ToC " + next.theSomethingElement() + " is the following sibling of " + tocNode.theSomethingElement() + ", yet they are not siblings in the XML document." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
            }
            if (!relevantSibling.isSameNode(next.getElement())) {
                throw new DocgenException("Bad ToC-element topology: In the ToC " + next.theSomethingElement() + " is the immediate following sibling of " + tocNode.theSomethingElement() + ", but in the XML document there is a \"" + relevantSibling.getLocalName() + "\" element between them, or they aren't siblings at all." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
            }
        } else if (relevantSibling != null) {
            throw new DocgenException("Bad ToC-element topology: In the ToC hierarchy " + tocNode.theSomethingElement() + "\" is a last-child, but in the XML document it has a \"" + relevantSibling.getLocalName() + "\" element as its following sibling." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
        }
        TOCNode prev = tocNode.getPrevious();
        relevantSibling = this.preprocessDOM_buildTOC_getSectionLikeSibling(tocNode.getElement(), false);
        if (prev == null && relevantSibling != null) {
            throw new DocgenException("Bad ToC-element topology: In the ToC hierarchy " + tocNode.theSomethingElement() + " is a first-child, but in the XML document it has a \"" + relevantSibling.getLocalName() + "\" element as its preceding sibling." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
        }
        for (TOCNode child = tocNode.getFirstChild(); child != null; child = child.getNext()) {
            this.preprocessDOM_buildTOC_checkTOCTopology(child);
        }
    }

    private Element preprocessDOM_buildTOC_getSectionLikeSibling(Element elem, boolean next) {
        Node relevantSibling = elem;
        while (!((relevantSibling = next ? relevantSibling.getNextSibling() : relevantSibling.getPreviousSibling()) == null || relevantSibling instanceof Element && DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(relevantSibling.getLocalName()))) {
        }
        return relevantSibling;
    }

    private void preprocessDOM_buildTOC_checkFileTopology(TOCNode tocNode) throws DocgenException {
        TOCNode firstChild = tocNode.getFirstChild();
        if (firstChild != null) {
            boolean firstIsFileElement = firstChild.isFileElement();
            TOCNode child = firstChild;
            do {
                if (child.isFileElement() != firstIsFileElement) {
                    throw new DocgenException("Bad file-element topology: The first child element of " + tocNode.theSomethingElement() + ", " + firstChild.theSomethingElement() + ", is " + (firstIsFileElement ? "a" : "not a") + " file-element, while another child, " + child.theSomethingElement() + (firstIsFileElement ? " isn't" : " is") + ". Either all relevant children elements must be file-elements or neither can be." + COMMON_FILE_TOPOLOGY_ERROR_HINT);
                }
                this.preprocessDOM_buildTOC_checkFileTopology(child);
            } while ((child = child.getNext()) != null);
            if (firstIsFileElement && !tocNode.isFileElement()) {
                throw new DocgenException("Bad file-element topology: " + tocNode.theSomethingElement() + " is not a file-element, yet it has file-element children, " + firstChild.theSomethingElement() + ". Only file-elements can have children that are file-elements.");
            }
        }
    }

    private TOCNode preprocessDOM_buildTOC_inner(Node node, int sectionLevel, TOCNode parentTOCNode) throws DocgenException {
        TOCNode curTOCNode = null;
        int newSectionLevel = sectionLevel;
        if (node instanceof Element) {
            Element elem = (Element)node;
            String nodeName = node.getNodeName();
            if (DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(nodeName)) {
                DocumentStructureRank rank = DocumentStructureRank.valueOf(XMLUtil.getAttribute(elem, A_DOCGEN_RANK).toUpperCase());
                boolean isTheDocumentElement = elem.getParentNode() instanceof Document;
                if (isTheDocumentElement || rank.compareTo(this.lowestPageTOCElemenRank) >= 0) {
                    curTOCNode = new TOCNode(elem, this.tocNodes.size());
                    this.tocNodes.add(curTOCNode);
                    if ((isTheDocumentElement || rank.compareTo(this.lowestFileElemenRank) >= 0) && !this.hasPrefaceLikeParent(elem)) {
                        elem.setAttribute(A_DOCGEN_FILE_ELEMENT, "true");
                        curTOCNode.setFileElement(true);
                        if (isTheDocumentElement) {
                            curTOCNode.setOutputFileName(FILE_TOC_HTML);
                            elem.setAttribute(A_DOCGEN_ROOT_ELEMENT, "true");
                        } else if (this.getExternalLinkTOCNodeURLOrNull(elem) != null) {
                            curTOCNode.setOutputFileName(null);
                        } else if ("index.html".equals(elem.getAttribute("role"))) {
                            curTOCNode.setOutputFileName("index.html");
                        } else {
                            String id = XMLUtil.getAttribute(elem, "id");
                            if (id == null) {
                                throw new BugException("Missing id attribute");
                            }
                            String fileName = id + ".html";
                            if (fileName.equals(FILE_TOC_HTML) || fileName.equals(FILE_DETAILED_TOC_HTML) || fileName.equals("index.html") || fileName.equals(FILE_SEARCH_RESULTS_HTML)) {
                                throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " has an xml:id that is deduced to a reserved output file name, \"" + fileName + "\". (Hint: Change the xml:id.)");
                            }
                            curTOCNode.setOutputFileName(fileName);
                        }
                    } else {
                        elem.setAttribute(A_DOCGEN_PAGE_TOC_ELEMENT, "true");
                    }
                    elem.setAttribute(A_DOCGEN_DETAILED_TOC_ELEMENT, "true");
                }
            }
        }
        if (curTOCNode != null) {
            parentTOCNode = curTOCNode;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            TOCNode child = this.preprocessDOM_buildTOC_inner(children.item(i), newSectionLevel, parentTOCNode);
            if (child == null || parentTOCNode == null) continue;
            child.setParent(parentTOCNode);
            TOCNode lastChild = parentTOCNode.getLastChild();
            if (lastChild != null) {
                child.setPrevious(lastChild);
                lastChild.setNext(child);
            }
            if (parentTOCNode.getFirstChild() == null) {
                parentTOCNode.setFirstChild(child);
            }
            parentTOCNode.setLastChild(child);
        }
        return curTOCNode;
    }

    private String getExternalLinkTOCNodeURLOrNull(Element elem) throws DocgenException {
        if (elem.getParentNode() instanceof Document) {
            return null;
        }
        Element title = this.getTitle(elem);
        if (title == null) {
            return null;
        }
        Iterator<Element> it = XMLUtil.childrenElementsOf(title).iterator();
        if (it.hasNext()) {
            Element firstChild = it.next();
            if (!it.hasNext()) {
                String firstChildName = firstChild.getLocalName();
                if (firstChildName.equals("link")) {
                    String href = XMLUtil.getAttributeNS(firstChild, "http://www.w3.org/1999/xlink", "href");
                    if (href == null) {
                        throw new DocgenException(XMLUtil.theSomethingElement(firstChild, true) + " inside a title has no xlink:" + "href" + " attribute, thus it can't be used as ToC link.");
                    }
                    return href;
                }
                if (firstChildName.equals("olink")) {
                    String targetdoc = XMLUtil.getAttributeNS(firstChild, null, "targetdoc");
                    if (targetdoc == null) {
                        throw new DocgenException(XMLUtil.theSomethingElement(firstChild, true) + " has no xlink:" + "targetdoc" + " attribute");
                    }
                    String url = this.olinks.get(targetdoc);
                    if (url == null) {
                        throw new DocgenException(XMLUtil.theSomethingElement(firstChild, true) + " refers to undefined olink name " + StringUtil.jQuote((String)targetdoc) + "; check configuration.");
                    }
                    return url;
                }
            }
        }
        return null;
    }

    private void preprocessDOM_buildTOC_checkEnsureHasIndexHhml(List<TOCNode> tocNodes) throws DocgenException {
        for (TOCNode tocNode : tocNodes) {
            if (tocNode.getOutputFileName() == null || !tocNode.getOutputFileName().equals("index.html")) continue;
            return;
        }
        for (TOCNode tocNode : tocNodes) {
            if (tocNode.getOutputFileName() == null || !tocNode.getOutputFileName().equals(FILE_TOC_HTML)) continue;
            tocNode.setOutputFileName("index.html");
            return;
        }
        throw new DocgenException("No index.html output file would be generated. Add role=\"index.html\" to one of the elements for which a separate file is generated.");
    }

    private boolean hasPrefaceLikeParent(Element elem) {
        Node parent;
        while ((parent = elem.getParentNode()) != null && parent instanceof Element) {
            elem = (Element)parent;
            if (!elem.getNamespaceURI().equals("http://docbook.org/ns/docbook") || !PREFACE_LIKE_ELEMENTS.contains(elem.getLocalName())) continue;
            return true;
        }
        return false;
    }

    private Element getTitle(Element elem) {
        NodeList children = elem.getChildNodes();
        int ln = children.getLength();
        for (int i = 0; i < ln; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !child.getLocalName().equals(SETTING_SEO_META_KEY_TITLE)) continue;
            return (Element)child;
        }
        return null;
    }

    private void ensureTitleExists(Element elem, String defaultTitle) {
        if (this.getTitle(elem) != null) {
            return;
        }
        Node node = elem;
        do {
            if ((node = node.getParentNode()) != null) continue;
            throw new BugException("Can't find Document node.");
        } while (node.getNodeType() != 9);
        Document doc = (Document)node;
        Element title = doc.createElementNS("http://docbook.org/ns/docbook", SETTING_SEO_META_KEY_TITLE);
        title.appendChild(doc.createTextNode(defaultTitle));
        elem.insertBefore(title, elem.getFirstChild());
    }

    private TOCNode getFileTOCNodeFor(Element elem) {
        for (TOCNode tocNode : this.tocNodes) {
            if (!tocNode.isFileElement() || !tocNode.getElement().isSameNode(elem)) continue;
            return tocNode;
        }
        return null;
    }

    private void addIndexTerm(Node node) {
        Node primary = null;
        Node secondary = null;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("primary")) {
                primary = child;
                continue;
            }
            if (!child.getNodeName().equals("secondary")) continue;
            secondary = child;
        }
        String primaryText = primary.getFirstChild().getNodeValue().trim();
        if (!this.primaryIndexTermLookup.containsKey(primaryText)) {
            this.primaryIndexTermLookup.put(primaryText, new ArrayList());
        }
        if (secondary != null) {
            String secondaryText;
            Map m;
            ArrayList<NodeModel> nodes;
            if (!this.secondaryIndexTermLookup.containsKey(primaryText)) {
                this.secondaryIndexTermLookup.put(primaryText, new TreeMap());
            }
            if ((nodes = (ArrayList<NodeModel>)(m = (Map)this.secondaryIndexTermLookup.get(primaryText)).get(secondaryText = secondary.getFirstChild().getNodeValue().trim())) == null) {
                nodes = new ArrayList<NodeModel>();
                m.put(secondaryText, nodes);
            }
            nodes.add(NodeModel.wrap((Node)node));
        } else {
            this.primaryIndexTermLookup.get(primaryText).add(NodeModel.wrap((Node)node));
        }
    }

    private int generateHTMLFile() throws IOException, TemplateException {
        int mainTOFEntryCount;
        SimpleHash dataModel = new SimpleHash(this.fmConfig.getObjectWrapper());
        TOCNode otherTOCNode = this.currentFileTOCNode;
        while ((otherTOCNode = otherTOCNode.getPreviousInTraversarOrder()) != null && !otherTOCNode.isFileElement()) {
        }
        dataModel.put(VAR_PREVIOUS_FILE_ELEMENT, (Object)(otherTOCNode != null ? otherTOCNode.getElement() : null));
        otherTOCNode = this.currentFileTOCNode;
        while ((otherTOCNode = otherTOCNode.getNextInTraversarOrder()) != null && !otherTOCNode.isFileElement()) {
        }
        dataModel.put(VAR_NEXT_FILE_ELEMENT, (Object)(otherTOCNode != null ? otherTOCNode.getElement() : null));
        otherTOCNode = this.currentFileTOCNode.getParent();
        dataModel.put(VAR_PARENT_FILE_ELEMENT, (Object)(otherTOCNode != null ? otherTOCNode.getElement() : null));
        Element curElem = this.currentFileTOCNode.getElement();
        boolean isTheDocumentElement = curElem.getParentNode() instanceof Document;
        dataModel.put("maxTOFDisplayDepth", (Object)(isTheDocumentElement ? this.maxTOFDisplayDepth : this.maxMainTOFDisplayDepth));
        if (this.seoMeta != null) {
            String id;
            Map<String, String> seoMetaMap = this.seoMeta.get("file:" + this.currentFileTOCNode.getOutputFileName());
            if (seoMetaMap == null && (id = XMLUtil.getAttribute(this.currentFileTOCNode.getElement(), "id")) != null) {
                seoMetaMap = this.seoMeta.get(id);
            }
            if (seoMetaMap != null) {
                dataModel.put(VAR_SEO_META_TITLE_OVERRIDE, (Object)seoMetaMap.get(SETTING_SEO_META_KEY_TITLE));
                dataModel.put(VAR_SEO_META_FULL_TITLE_OVERRIDE, (Object)seoMetaMap.get(SETTING_SEO_META_KEY_FULL_TITLE));
                dataModel.put(VAR_SEO_META_DESCRIPTION, (Object)seoMetaMap.get(SETTING_SEO_META_KEY_DESCRIPTION));
            }
        }
        boolean generateDetailedTOC = false;
        if (isTheDocumentElement && (mainTOFEntryCount = this.countTOFEntries(this.currentFileTOCNode, this.maxMainTOFDisplayDepth)) != 0 && (double)mainTOFEntryCount < (double)this.tocNodes.size() * 0.75) {
            generateDetailedTOC = true;
            dataModel.put(VAR_ALTERNATIVE_TOC_LINK, (Object)FILE_DETAILED_TOC_HTML);
            dataModel.put(VAR_ALTERNATIVE_TOC_LABEL, (Object)"show detailed");
        }
        this.generateHTMLFile_inner(dataModel, this.currentFileTOCNode.getOutputFileName());
        if (generateDetailedTOC) {
            dataModel.put(VAR_PAGE_TYPE, (Object)PAGE_TYPE_DETAILED_TOC);
            dataModel.put(VAR_ALTERNATIVE_TOC_LINK, (Object)this.currentFileTOCNode.getOutputFileName());
            dataModel.put(VAR_ALTERNATIVE_TOC_LABEL, (Object)"show simplified");
            this.generateHTMLFile_inner(dataModel, FILE_DETAILED_TOC_HTML);
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateSearchResultsHTMLFile(Document doc) throws TemplateException, IOException, DocgenException {
        SimpleHash dataModel = new SimpleHash(this.fmConfig.getObjectWrapper());
        dataModel.put(VAR_PAGE_TYPE, (Object)PAGE_TYPE_SEARCH_RESULTS);
        dataModel.put("maxTOFDisplayDepth", (Object)this.maxMainTOFDisplayDepth);
        Element searchresultsElem = doc.createElementNS(XMLNS_DOCGEN, "searchresults");
        if (this.elementsById.containsKey("searchresults")) {
            throw new DocgenException("Reserved element id \"searchresults\" was already taken");
        }
        searchresultsElem.setAttribute("id", "searchresults");
        searchresultsElem.setAttribute(A_DOCGEN_RANK, "section");
        Element titleElem = doc.createElementNS("http://docbook.org/ns/docbook", SETTING_SEO_META_KEY_TITLE);
        titleElem.setTextContent(SEARCH_RESULTS_PAGE_TITLE);
        searchresultsElem.appendChild(titleElem);
        doc.getDocumentElement().appendChild(searchresultsElem);
        try {
            TOCNode searchresultsTOCNode = new TOCNode(searchresultsElem, 0);
            searchresultsTOCNode.setFileElement(true);
            searchresultsTOCNode.setOutputFileName(FILE_SEARCH_RESULTS_HTML);
            this.currentFileTOCNode = searchresultsTOCNode;
            this.generateHTMLFile_inner(dataModel, this.currentFileTOCNode.getOutputFileName());
        }
        finally {
            doc.getDocumentElement().removeChild(searchresultsElem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHTMLFile_inner(SimpleHash dataModel, String fileName) throws TemplateException, IOException {
        Template template = this.fmConfig.getTemplate("page.ftlh");
        File outputFile = new File(this.destDir, fileName);
        FileOutputStream fos = new FileOutputStream(outputFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, UTF_8);
        try (BufferedWriter writer = new BufferedWriter(osw, 2048);){
            template.process((Object)dataModel, (Writer)writer, null, (TemplateNodeModel)NodeModel.wrap((Node)this.currentFileTOCNode.getElement()));
        }
    }

    private int countTOFEntries(TOCNode parent, int displayDepth) {
        int sum = 0;
        for (TOCNode child = parent.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isFileElement()) continue;
            ++sum;
            if (displayDepth <= 1) continue;
            sum += this.countTOFEntries(child, displayDepth - 1);
        }
        return sum;
    }

    private boolean hasContentInTheSameFile(TOCNode tocNode) {
        for (Element elem : XMLUtil.childrenElementsOf(tocNode.getElement())) {
            if (!elem.getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            String name = elem.getLocalName();
            if (elem.hasAttribute(A_DOCGEN_FILE_ELEMENT) || !DocBook5Constants.VISIBLE_TOP_LEVEL_ELEMENTS.contains(name) || name.equals(SETTING_SEO_META_KEY_TITLE) || name.equals("subtitle") || name.equals("info") || name.equals("footnote")) continue;
            return true;
        }
        return false;
    }

    private String createElementLinkURL(Element elem) throws DocgenException {
        Node node;
        if (elem.hasAttribute(A_DOCGEN_NOT_ADDRESSABLE)) {
            return null;
        }
        String extLink = this.getExternalLinkTOCNodeURLOrNull(elem);
        if (extLink != null) {
            return extLink;
        }
        String id = null;
        for (node = elem; !(node == null || node instanceof Element && (id = XMLUtil.getAttribute(node, "id")) != null); node = node.getParentNode()) {
        }
        if (id == null) {
            throw new DocgenException("Can't create link for the \"" + elem.getLocalName() + "\" element: Nor this element nor its ascendants have an id.");
        }
        Element idElem = node;
        String fileName = null;
        Element curElem = idElem;
        do {
            TOCNode fileTOCNode;
            if ((fileTOCNode = this.getFileTOCNodeFor(curElem)) == null) {
                curElem = (Element)curElem.getParentNode();
                continue;
            }
            fileName = fileTOCNode.getOutputFileName();
            if (fileName != null) continue;
            throw new IllegalStateException("fileTOCNode with null outputFileName");
        } while (fileName == null);
        String link = this.currentFileTOCNode != null && fileName.equals(this.currentFileTOCNode.getOutputFileName()) ? "" : fileName;
        if (this.getFileTOCNodeFor(idElem) == null) {
            link = link + "#" + id;
        }
        if (link.length() == 0) {
            link = fileName;
        }
        return link;
    }

    private String getArgString(List<?> args, int argIdx) throws TemplateModelException {
        Object value = args.get(argIdx);
        if (value instanceof TemplateScalarModel) {
            return ((TemplateScalarModel)value).getAsString();
        }
        if (value instanceof TemplateModel) {
            throw new TemplateModelException("Argument #" + (argIdx + 1) + " should be a string, but it was: " + ClassUtil.getFTLTypeDescription((TemplateModel)((TemplateModel)value)));
        }
        throw new IllegalArgumentException("\"value\" must be " + TemplateModel.class.getName());
    }

    private String createLinkFromId(String id) throws DocgenException {
        if (this.elementsById == null) {
            throw new IllegalStateException("Can't resolve ID as elementsById is still null: " + id);
        }
        Element elem = this.elementsById.get(id);
        if (elem == null) {
            throw new DocgenException("No element exists with this id: \"" + id + "\"");
        }
        return this.createElementLinkURL(elem);
    }

    public File getDestinationDirectory() {
        return this.destDir;
    }

    public void setDestinationDirectory(File destDir) {
        this.destDir = destDir;
    }

    public File getSourceDirectory() {
        return this.srcDir;
    }

    public void setSourceDirectory(File srcDir) {
        this.srcDir = srcDir;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public boolean getSimpleNavigationMode() {
        return this.simpleNavigationMode;
    }

    public void setSimpleNavigationMode(boolean simpleNavigationMode) {
        this.simpleNavigationMode = simpleNavigationMode;
    }

    public boolean getShowEditoralNotes() {
        return this.showEditoralNotes;
    }

    public void setShowEditoralNotes(boolean showEditoralNotes) {
        this.showEditoralNotes = showEditoralNotes;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean getPrintProgress() {
        return this.printProgress;
    }

    public void setPrintProgress(boolean printProgress) {
        this.printProgress = printProgress;
    }

    public boolean getGenerateEclipseToC() {
        return this.generateEclipseTOC;
    }

    public void setGenerateEclipseToC(boolean eclipseToC) {
        this.generateEclipseTOC = eclipseToC;
    }

    static {
        SETTING_SEO_META_KEYS.add(SETTING_SEO_META_KEY_TITLE);
        SETTING_SEO_META_KEYS.add(SETTING_SEO_META_KEY_FULL_TITLE);
        SETTING_SEO_META_KEYS.add(SETTING_SEO_META_KEY_DESCRIPTION);
        COMMON_LINK_KEYS = new LinkedHashSet<String>();
        COMMON_LINK_KEYS.add(COMMON_LINK_KEY_CLASS);
        COMMON_LINK_KEYS.add("href");
        UTF_8 = Charset.forName("UTF-8");
        HashSet<String> idAttElems = new HashSet<String>();
        for (String elemName : DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS) {
            idAttElems.add(elemName);
        }
        idAttElems.add("glossary");
        idAttElems.add("glossentry");
        GUARANTEED_ID_ELEMENTS = Collections.unmodifiableSet(idAttElems);
        HashSet<String> sinlgeFileElems = new HashSet<String>();
        sinlgeFileElems.add("preface");
        PREFACE_LIKE_ELEMENTS = Collections.unmodifiableSet(sinlgeFileElems);
    }

    static enum DocumentStructureRank {
        SIMPLESECT,
        SECTION3,
        SECTION2,
        SECTION1,
        CHAPTER,
        PART,
        BOOK;


        public String toString() {
            return this.name().toLowerCase();
        }

        static String sectionToString(int level) {
            return SECTION1.toString().substring(0, SECTION1.toString().length() - 1) + level;
        }
    }

    public class TOCNode {
        private final Element element;
        private final int traversalIndex;
        private TOCNode parent;
        private TOCNode next;
        private TOCNode previous;
        private TOCNode firstChild;
        private TOCNode lastChild;
        private boolean fileElement;
        private String outputFileName;

        public TOCNode(Element element, int traversalIndex) {
            this.element = element;
            this.traversalIndex = traversalIndex;
        }

        public TOCNode getFirstChild() {
            return this.firstChild;
        }

        public void setFirstChild(TOCNode firstChild) {
            this.firstChild = firstChild;
        }

        public TOCNode getLastChild() {
            return this.lastChild;
        }

        public void setLastChild(TOCNode lastChild) {
            this.lastChild = lastChild;
        }

        public void setParent(TOCNode parent) {
            this.parent = parent;
        }

        public TOCNode getNext() {
            return this.next;
        }

        public void setNext(TOCNode next) {
            this.next = next;
        }

        public TOCNode getPrevious() {
            return this.previous;
        }

        public void setPrevious(TOCNode previous) {
            this.previous = previous;
        }

        public TOCNode getParent() {
            return this.parent;
        }

        public void setOutputFileName(String outputFileName) {
            if (!this.fileElement) {
                throw new BugException("Can't set outputFileName before setting fileElement to true");
            }
            this.outputFileName = outputFileName;
        }

        public String getOutputFileName() {
            return this.outputFileName;
        }

        public Element getElement() {
            return this.element;
        }

        public void setFileElement(boolean fileElement) {
            this.fileElement = fileElement;
        }

        public boolean isFileElement() {
            return this.fileElement;
        }

        public String theSomethingElement() {
            return XMLUtil.theSomethingElement(this.element);
        }

        public TOCNode getNextInTraversarOrder() {
            return this.traversalIndex + 1 < Transform.this.tocNodes.size() ? (TOCNode)Transform.this.tocNodes.get(this.traversalIndex + 1) : null;
        }

        public TOCNode getPreviousInTraversarOrder() {
            return this.traversalIndex > 0 ? (TOCNode)Transform.this.tocNodes.get(this.traversalIndex - 1) : null;
        }
    }

    private static final class PreprocessDOMMisc_ParentSectState {
        private int upperRomanNumber = 1;
        private int lowerRomanNumber = 1;
        private int arabicNumber = 1;
        private int upperLatinNumber = 1;
        private int unitedNumber = 1;

        private PreprocessDOMMisc_ParentSectState() {
            this.notAUtiltiyClass();
        }

        void notAUtiltiyClass() {
        }
    }

    private static final class PreprocessDOMMisc_GlobalState {
        private int lastId;

        private PreprocessDOMMisc_GlobalState() {
            this.notAUtiltiyClass();
        }

        void notAUtiltiyClass() {
        }
    }
}

