/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import freemarker.template.utility.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Pattern;
import org.freemarker.docgen.Transform;

final class FileUtil {
    private static final int READ_BUFFER_SIZE = 4096;
    private static final int COPY_BUFFER_SIZE = 65536;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyResourceIntoFile(Class<?> srcBaseClass, String srcBaseDir, String srcRelativePath, File destDir) throws IOException {
        File dstFile = new File(destDir, srcRelativePath.replace('/', File.separatorChar));
        File curDestDir = dstFile.getParentFile();
        if (!curDestDir.isDirectory() && !curDestDir.mkdirs()) {
            throw new IOException("Failed to create destination directory: " + curDestDir.getAbsolutePath());
        }
        byte[] buffer = new byte[65536];
        String finalResourcePath = srcBaseDir == null || srcBaseDir.length() == 0 ? srcRelativePath : srcBaseDir + "/" + srcRelativePath;
        InputStream in = srcBaseClass.getResourceAsStream(finalResourcePath);
        if (in == null) {
            throw new IOException("Failed to open class-loader resource: " + finalResourcePath + " relatively to " + Transform.class.getPackage().getName());
        }
        try (FileOutputStream out = new FileOutputStream(dstFile);){
            int ln;
            while ((ln = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, ln);
            }
        }
        finally {
            in.close();
        }
    }

    static int copyDir(File srcDir, File destDir) throws IOException {
        return FileUtil.copyDir(srcDir, destDir, srcDir, Collections.emptySet());
    }

    static int copyDir(File srcDir, File destDir, Collection<Pattern> ignoredFilePathPatterns) throws IOException {
        return FileUtil.copyDir(srcDir, destDir, srcDir, ignoredFilePathPatterns);
    }

    private static int copyDir(File srcDir, File destDir, File srcBaseDir, Collection<Pattern> ignoredFilePathPatterns) throws IOException {
        File[] ls;
        int fileCounter = 0;
        destDir = destDir.getAbsoluteFile();
        srcDir = srcDir.getAbsoluteFile();
        String srcBaseDirPath = FileUtil.ensureEndsWithFileSeparator(srcBaseDir.getAbsolutePath());
        if (!destDir.isDirectory()) {
            if (destDir.exists()) {
                throw new IOException("Can't create directory, because a file with the same name already exists: " + destDir.getAbsolutePath());
            }
            if (!destDir.mkdir()) {
                throw new IOException("Failed to create directory: " + destDir.getAbsolutePath());
            }
        }
        if ((ls = srcDir.listFiles()) == null) {
            throw new IOException("Failed to list directory: " + srcDir.getAbsolutePath());
        }
        for (File f : srcDir.listFiles()) {
            String fName = f.getName();
            if (FileUtil.isUsualIgnorableFileOrDirectory(fName) || FileUtil.isDocgenFile(fName)) continue;
            File dest = new File(destDir, fName);
            if (f.isFile()) {
                if (FileUtil.isIgnoredFile(f, srcBaseDirPath, ignoredFilePathPatterns)) continue;
                FileUtil.copyFile(f, dest);
                ++fileCounter;
                continue;
            }
            if (f.isDirectory()) {
                fileCounter += FileUtil.copyDir(f, dest, srcBaseDir, ignoredFilePathPatterns);
                continue;
            }
            throw new IOException("Failed decide if it's a file or a directory: " + f.getAbsolutePath());
        }
        return fileCounter;
    }

    private static boolean isIgnoredFile(File f, String srcBaseDirPath, Collection<Pattern> ignoredFilePathPatterns) throws IOException {
        if (ignoredFilePathPatterns.isEmpty()) {
            return false;
        }
        srcBaseDirPath = FileUtil.ensureEndsWithFileSeparator(srcBaseDirPath);
        String filePath = f.getAbsolutePath();
        if (!filePath.startsWith(srcBaseDirPath)) {
            throw new IOException("Unexpected: " + StringUtil.jQuote((String)filePath) + " doesn't start with " + StringUtil.jQuote((String)srcBaseDirPath));
        }
        String slashRelFilePath = FileUtil.pathToUnixStyle(filePath.substring(srcBaseDirPath.length() - 1));
        for (Pattern pattern : ignoredFilePathPatterns) {
            if (!pattern.matcher(slashRelFilePath).matches()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dst) throws IOException {
        byte[] buffer = new byte[65536];
        try (FileInputStream in = new FileInputStream(src);){
            long srcLMD = 0L;
            srcLMD = src.lastModified();
            if (srcLMD == 0L) {
                throw new IOException("Failed to get the last modification time of " + src.getAbsolutePath());
            }
            try (FileOutputStream out = new FileOutputStream(dst);){
                int ln;
                while ((ln = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, ln);
                }
            }
            if (srcLMD != 0L && !dst.setLastModified(srcLMD)) {
                throw new IOException("Failed to set last-modification-date for: " + dst.getAbsolutePath());
            }
        }
    }

    static boolean isDocgenFile(String fName) {
        return (fName = fName.toLowerCase()).startsWith("docgen-") || fName.startsWith("docgen.") || fName.equals("docgen");
    }

    static boolean isUsualIgnorableFileOrDirectory(String fName) {
        int i = (fName = fName.toLowerCase()).lastIndexOf(".");
        String fExt = i == -1 ? "" : fName.substring(i + 1);
        if (fName.equals(".cvsignore") || fName.equals("cvs") || fName.length() > 2 && fName.startsWith(".#")) {
            return true;
        }
        if (fName.equals(".svn")) {
            return true;
        }
        return fExt.equals("bak") || fExt.equals("lock") || fExt.startsWith("~") || fName.length() > 2 && (fName.startsWith("#") && fName.endsWith("#") || fName.startsWith("%") && fName.endsWith("%") || fName.startsWith("._")) || fName.length() > 1 && (fName.endsWith("~") || fName.startsWith("~"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File f, Charset charset) throws IOException {
        try (FileInputStream in = new FileInputStream(f);){
            String string = FileUtil.loadString(in, charset);
            return string;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(InputStream in, Charset charset) throws IOException {
        StringBuilder sb = new StringBuilder(256);
        try (InputStreamReader r = new InputStreamReader(in, charset);){
            int ln;
            char[] buf = new char[4096];
            while ((ln = r.read(buf)) != -1) {
                sb.append(buf, 0, ln);
            }
        }
        return sb.toString();
    }

    public static Pattern globToRegexp(String text) {
        StringBuilder sb = new StringBuilder();
        if (!text.startsWith("/")) {
            text = "/" + text;
        }
        if (text.endsWith("/")) {
            text = text + "**";
        }
        char[] chars = text.toCharArray();
        int ln = chars.length;
        for (int i = 0; i < ln; ++i) {
            char c = chars[i];
            if (c == '\\' || c == '^' || c == '.' || c == '$' || c == '|' || c == '(' || c == ')' || c == '[' || c == ']' || c == '+' || c == '{' || c == '}' || c == '@') {
                sb.append('\\');
                sb.append(c);
                continue;
            }
            if (i == 0 && ln > 2 && chars[0] == '*' && chars[1] == '*' && chars[2] == '/') {
                sb.append(".*/");
                i += 2;
                continue;
            }
            if (c == '/' && i + 2 < ln && chars[i + 1] == '*' && chars[i + 2] == '*') {
                if (i + 3 == ln) {
                    sb.append("/.*");
                } else {
                    sb.append("(/.*)?");
                }
                i += 2;
                continue;
            }
            if (c == '*') {
                sb.append("[^/]*");
                continue;
            }
            if (c == '?') {
                sb.append("[^/]");
                continue;
            }
            sb.append(c);
        }
        return Pattern.compile(sb.toString());
    }

    public static String pathToUnixStyle(String path) {
        return path.replace(File.separatorChar, '/');
    }

    public static String ensureEndsWithFileSeparator(String path) {
        return path.length() > 0 && path.charAt(path.length() - 1) == File.separatorChar ? path : path + File.separatorChar;
    }
}

