/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeSet;
import org.freemarker.docgen.DocgenValidationOptions;
import org.freemarker.docgen.MessageStreamActivityMonitor;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class DocgenRestrictionsValidator
implements ContentHandler {
    public static final int MAX_SECTION_NESTING_LEVEL = 3;
    private static final Set<String> SUPPORTED_ELEMENTS;
    private static final Set<String> ELEMENTS_ALLOW_ID;
    private final ContentHandler docbook5Validator;
    private final ErrorHandler errorHandler;
    private final MessageStreamActivityMonitor errorMessageMonitor;
    private final DocgenValidationOptions options;
    private Locator locator;
    private String documentElementName;
    private int sectionNestingLevel;
    private int paraNestingLevel;
    private LinkedList<Integer> paraNestingLevelsHiddenByFootnote = new LinkedList();
    private LinkedList<Integer> programlistingNestingLevelsHiddenByFootnote = new LinkedList();
    private LinkedList<Integer> programlistingLineLengthHiddenByFootnote = new LinkedList();
    private ArrayList<Boolean> hadClosedPara = new ArrayList();
    private ArrayList<String> elemPath = new ArrayList();
    private int programlistingNestingLevel;
    private int invisibleElementNestingLevel;
    private int programlistingLineLength;

    DocgenRestrictionsValidator(ContentHandler docbook5Validator, ErrorHandler errorHandler, MessageStreamActivityMonitor errorMessageMonitor, DocgenValidationOptions options) {
        if (docbook5Validator == null) {
            throw new IllegalArgumentException("\"docbook5Validator\" can't be null");
        }
        this.docbook5Validator = docbook5Validator;
        if (errorHandler == null) {
            throw new IllegalArgumentException("\"errorHandler\" can't be null");
        }
        this.errorHandler = errorHandler;
        if (errorMessageMonitor == null) {
            throw new IllegalArgumentException("\"messageMonitor\" can't be null");
        }
        this.errorMessageMonitor = errorMessageMonitor;
        if (options == null) {
            throw new IllegalArgumentException("\"options\" can't be null");
        }
        this.options = options;
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        boolean xmlnsOK = uri.equals("http://docbook.org/ns/docbook");
        if (xmlnsOK) {
            this.hadClosedPara.add(false);
            this.elemPath.add(localName);
        }
        this.errorMessageMonitor.reset();
        this.docbook5Validator.startElement(uri, localName, name, atts);
        if (!this.errorMessageMonitor.hadNewErrorMessage()) {
            if (!xmlnsOK) {
                this.errorHandler.error(this.newSAXException("Unsupported element namespace: " + uri));
            } else if (!SUPPORTED_ELEMENTS.contains(localName)) {
                if (localName.equals("sect1") || localName.equals("sect2") || localName.equals("sect3") || localName.equals("sect4") || localName.equals("sect5")) {
                    this.errorHandler.error(this.newSAXException("The \"" + localName + "\" element and other such numbered \"sect\"-s are not allowed; use \"" + "section" + "\"-s instead."));
                } else {
                    this.errorHandler.error(this.newSAXException("Unsupported element: " + localName));
                }
            } else {
                this.startSupportedDocbook5Element(localName, atts);
            }
        }
    }

    private void startSupportedDocbook5Element(String localName, Attributes atts) throws SAXException {
        boolean isDocumentElem;
        if (this.documentElementName == null) {
            this.documentElementName = localName;
            isDocumentElem = true;
        } else {
            isDocumentElem = false;
        }
        if (localName.equals("section")) {
            ++this.sectionNestingLevel;
            if (this.sectionNestingLevel > 3) {
                this.errorHandler.error(this.newSAXException("\"" + localName + "\" element nesting too deep. The maximum supported is " + 3 + " levels. Hint: Use \"" + "simplesect" + "\" instead."));
            }
        } else if (localName.equals("para")) {
            ++this.paraNestingLevel;
        } else if (localName.equals("itemizedlist") || localName.equals("orderedlist") || localName.equals("programlisting") || localName.equals("mediaobject")) {
            this.checkNotInAPara(localName);
            if (localName.equals("programlisting")) {
                if (this.options.getProgramlistingRequiresLanguage() && atts.getValue("", "language") == null) {
                    this.errorHandler.error(this.newSAXException("In this book, \"" + localName + "\" elements must have a \"" + "language" + "\" attribute. Hint: If the language is so marginal that will not ever have syntax highlighter anyway, use \"unknown\" as the attribute value."));
                }
                if (this.options.getProgramlistingRequiresRole() && atts.getValue("", "role") == null) {
                    this.errorHandler.error(this.newSAXException("In this book, \"" + localName + "\" elements must have a \"" + "role" + "\" attribute. Hint: If none of the avialble roles fit, use \"unspecified\" as the attribute value."));
                }
                this.checkHasPrecedingParaInListitem(localName);
                this.programlistingLineLength = 0;
                ++this.programlistingNestingLevel;
            }
        } else if (localName.equals("informaltable") || localName.equals("table")) {
            this.checkNotInAPara(localName);
            this.checkHasPrecedingParaInListitem(localName);
        } else if (localName.equals("footnote")) {
            if (!this.paraNestingLevelsHiddenByFootnote.isEmpty()) {
                this.errorHandler.error(this.newSAXException("\"" + localName + "\" inside another \"" + localName + "\" is not allowed."));
            }
            if (this.programlistingNestingLevel != 0) {
                this.errorHandler.error(this.newSAXException("\"" + localName + "\" inside a \"" + "programlisting" + "\" is not allowed."));
            }
            this.paraNestingLevelsHiddenByFootnote.add(this.paraNestingLevel);
            this.paraNestingLevel = 0;
            this.programlistingNestingLevelsHiddenByFootnote.add(this.programlistingNestingLevel);
            this.programlistingNestingLevel = 0;
            this.programlistingLineLengthHiddenByFootnote.add(this.programlistingLineLength);
            this.programlistingLineLength = 0;
        } else if (localName.equals("anchor") || localName.equals("indexterm")) {
            ++this.invisibleElementNestingLevel;
        } else if (isDocumentElem) {
            String conformance = atts.getValue("", "conformance");
            if (conformance == null) {
                this.errorHandler.error(this.newSAXException("The \"" + localName + "\" element must have a \"" + "conformance" + "\" attribute. Hint: Add the attribute with value \"" + "docgen" + "\"."));
            } else if (!conformance.equals("docgen")) {
                this.errorHandler.error(this.newSAXException("The value of the \"conformance\" attribute must be \"docgen\"."));
            }
        }
        if (atts.getIndex("xml:id") != -1 && !ELEMENTS_ALLOW_ID.contains(localName)) {
            this.errorHandler.error(this.newSAXException("The \"" + localName + "\" element can't have an \"" + "xml:id" + "\" attribute (" + "xml:id" + "=\"" + atts.getValue("xml:id") + "\"). (Hint: " + (localName.equals("title") ? "Move the xml:id over into the element whose \"title\" the element is." : "Try moving the xml:id higher in the element hierarchy.") + ")"));
        }
        if (atts.getIndex("xreflabel") != -1 && !ELEMENTS_ALLOW_ID.contains(localName)) {
            this.errorHandler.error(this.newSAXException("The \"" + localName + "\" element can't have an \"" + "xreflabel" + "\" attribute, because it couldn't have a \"" + "xml:id" + "\" attribute either, and hence it couldn't be the target of a link. (Hint: " + (localName.equals("title") ? "Move the \"xreflabel\" attribute over into the element whose \"title\" the element is." : "Try moving the xreflabel higher in the element hierarchy.") + ")"));
        }
    }

    private void checkNotInAPara(String localName) throws SAXException {
        if (this.paraNestingLevel > 0) {
            this.errorHandler.error(this.newSAXException("It's not allowed to put a(n) \"" + localName + "\" inside a \"" + "para" + "\". Hint: Simply split the containing \"" + "para" + "\" into two parts, or move the element after the \"" + "para" + "\"."));
        }
    }

    private void checkHasPrecedingParaInListitem(String elemName) throws SAXException {
        if (this.elemPath.get(this.elemPath.size() - 2).equals("listitem") && !this.hadClosedPara.get(this.hadClosedPara.size() - 2).booleanValue()) {
            this.errorHandler.error(this.newSAXException("A(n) \"" + elemName + "\" in a \"" + "listitem" + "\" must be preceded by a \"" + "para" + "\"."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        boolean xmlnsOK = uri.equals("http://docbook.org/ns/docbook");
        try {
            this.docbook5Validator.endElement(uri, localName, name);
            if (xmlnsOK) {
                if (localName.equals("section")) {
                    --this.sectionNestingLevel;
                } else if (localName.equals("para")) {
                    --this.paraNestingLevel;
                    this.hadClosedPara.set(this.hadClosedPara.size() - 2, true);
                } else if (localName.equals("footnote")) {
                    this.paraNestingLevel = this.paraNestingLevelsHiddenByFootnote.remove();
                    this.programlistingNestingLevel = this.programlistingNestingLevelsHiddenByFootnote.remove();
                    this.programlistingLineLength = this.programlistingLineLengthHiddenByFootnote.remove();
                } else if (localName.equals("programlisting")) {
                    --this.programlistingNestingLevel;
                } else if (localName.equals("anchor") || localName.equals("indexterm")) {
                    --this.invisibleElementNestingLevel;
                }
            }
        }
        finally {
            if (xmlnsOK) {
                this.elemPath.remove(this.elemPath.size() - 1);
                this.hadClosedPara.remove(this.hadClosedPara.size() - 1);
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.invisibleElementNestingLevel == 0 && this.programlistingNestingLevel > 0) {
            int end = start + length;
            for (int i = start; i < end; ++i) {
                char c = ch[i];
                if (c == '\n' || c == '\r') {
                    this.programlistingLineLength = 0;
                } else if (c == '\t') {
                    this.programlistingLineLength = (this.programlistingLineLength / 8 + 1) * 8;
                    this.errorHandler.error(this.newSAXException("Tab character is not allowed in programlistings. (Hint: Use spaces instead.)"));
                } else {
                    ++this.programlistingLineLength;
                }
                if (this.programlistingLineLength != this.options.getMaximumProgramlistingWidth() + 1) continue;
                this.errorHandler.error(this.newSAXException("Line length in the programlisting exceeded " + this.options.getMaximumProgramlistingWidth() + ", which was set as the maximum in the (Related Docgen setting: \"" + "validation" + "\" per \"" + "maximumProgramlistingWidth" + "\")"));
            }
        }
        this.docbook5Validator.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.docbook5Validator.endDocument();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.docbook5Validator.endPrefixMapping(prefix);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.docbook5Validator.ignorableWhitespace(ch, start, length);
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.docbook5Validator.processingInstruction(target, data);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.docbook5Validator.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        this.docbook5Validator.skippedEntity(name);
    }

    @Override
    public void startDocument() throws SAXException {
        this.docbook5Validator.startDocument();
    }

    private SAXParseException newSAXException(String message) {
        return new SAXParseException("Docgen-specific DocBook restriction violated: " + message, this.locator);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.docbook5Validator.startPrefixMapping(prefix, uri);
    }

    static {
        TreeSet<String> supportedElements = new TreeSet<String>();
        supportedElements.add("anchor");
        supportedElements.add("answer");
        supportedElements.add("appendix");
        supportedElements.add("article");
        supportedElements.add("book");
        supportedElements.add("chapter");
        supportedElements.add("classname");
        supportedElements.add("col");
        supportedElements.add("colgroup");
        supportedElements.add("emphasis");
        supportedElements.add("entry");
        supportedElements.add("footnote");
        supportedElements.add("glossary");
        supportedElements.add("glossdef");
        supportedElements.add("glossentry");
        supportedElements.add("glosssee");
        supportedElements.add("glossseealso");
        supportedElements.add("glossterm");
        supportedElements.add("imagedata");
        supportedElements.add("imageobject");
        supportedElements.add("index");
        supportedElements.add("indexterm");
        supportedElements.add("info");
        supportedElements.add("informaltable");
        supportedElements.add("itemizedlist");
        supportedElements.add("link");
        supportedElements.add("listitem");
        supportedElements.add("literal");
        supportedElements.add("mediaobject");
        supportedElements.add("methodname");
        supportedElements.add("note");
        supportedElements.add("olink");
        supportedElements.add("orderedlist");
        supportedElements.add("package");
        supportedElements.add("para");
        supportedElements.add("part");
        supportedElements.add("phrase");
        supportedElements.add("preface");
        supportedElements.add("primary");
        supportedElements.add("productname");
        supportedElements.add("programlisting");
        supportedElements.add("qandaentry");
        supportedElements.add("qandaset");
        supportedElements.add("question");
        supportedElements.add("quote");
        supportedElements.add("remark");
        supportedElements.add("replaceable");
        supportedElements.add("secondary");
        supportedElements.add("section");
        supportedElements.add("simplesect");
        supportedElements.add("subtitle");
        supportedElements.add("tbody");
        supportedElements.add("td");
        supportedElements.add("tfoot");
        supportedElements.add("th");
        supportedElements.add("thead");
        supportedElements.add("tr");
        supportedElements.add("title");
        supportedElements.add("titleabbrev");
        supportedElements.add("warning");
        supportedElements.add("xref");
        SUPPORTED_ELEMENTS = Collections.unmodifiableSet(supportedElements);
        TreeSet<String> elementsAllowId = new TreeSet<String>();
        elementsAllowId.add("part");
        elementsAllowId.add("appendix");
        elementsAllowId.add("chapter");
        elementsAllowId.add("section");
        elementsAllowId.add("simplesect");
        elementsAllowId.add("preface");
        elementsAllowId.add("index");
        elementsAllowId.add("glossary");
        elementsAllowId.add("para");
        elementsAllowId.add("mediaobject");
        elementsAllowId.add("informaltable");
        elementsAllowId.add("programlisting");
        elementsAllowId.add("itemizedlist");
        elementsAllowId.add("orderedlist");
        elementsAllowId.add("listitem");
        elementsAllowId.add("glossentry");
        elementsAllowId.add("qandaentry");
        elementsAllowId.add("anchor");
        ELEMENTS_ALLOW_ID = Collections.unmodifiableSet(elementsAllowId);
    }
}

