/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import org.freemarker.docgen.ValidatingDOMBuilder;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ValidatingDOMBuilderWithLocations
extends ValidatingDOMBuilder {
    public static final String KEY_LOCATION = "docgen_location";
    private final Set<String> elements;
    private final String namespaceURI;
    private Locator locator;

    public ValidatingDOMBuilderWithLocations(ContentHandler validator, String namespaceURI, Set<String> elements) throws ParserConfigurationException {
        super(validator);
        this.namespaceURI = namespaceURI != null ? namespaceURI : "";
        this.elements = elements;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        super.setDocumentLocator(locator);
    }

    @Override
    public void processElement(Element elem) {
        String nsURI = elem.getNamespaceURI();
        if (this.elements.contains(elem.getLocalName()) && (nsURI != null ? nsURI : "").equals(this.namespaceURI)) {
            Location loc = new Location(this.locator.getSystemId(), this.locator.getLineNumber(), this.locator.getColumnNumber());
            elem.setUserData(KEY_LOCATION, loc, null);
        }
    }

    public static class Location {
        private final String systemId;
        private final int line;
        private final int column;

        public Location(String file, int row, int column) {
            this.systemId = file;
            this.line = row;
            this.column = column;
        }

        public String getSystemId() {
            return this.systemId;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

