/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

abstract class ValidatingDOMBuilder
implements ContentHandler {
    private final ContentHandler validator;
    private final Document doc;
    private Node parent;

    public ValidatingDOMBuilder(ContentHandler validator) throws ParserConfigurationException {
        if (validator == null) {
            throw new IllegalArgumentException("The \"validator\" parameter can't be null.");
        }
        this.validator = validator;
        this.doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        this.parent = this.doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public void startElement(String ns, String lname, String qname, Attributes atts) throws SAXException {
        this.validator.startElement(ns, lname, qname, atts);
        Element e = this.doc.createElementNS(ns, qname);
        this.parent.appendChild(e);
        this.parent = e;
        this.processElement(e);
        for (int i = 0; i < atts.getLength(); ++i) {
            e.setAttributeNS(atts.getURI(i), atts.getQName(i), atts.getValue(i));
        }
    }

    public abstract void processElement(Element var1);

    public void endElement(String ns, String lname, String qname) throws SAXException {
        this.validator.endElement(ns, lname, qname);
        this.parent = this.parent.getParentNode();
    }

    public void characters(char[] buf, int start, int length) throws SAXException {
        this.validator.characters(buf, start, length);
        this.parent.appendChild(this.doc.createTextNode(new String(buf, start, length)));
    }

    public void ignorableWhitespace(char[] buf, int start, int len) {
        this.parent.appendChild(this.doc.createTextNode(new String(buf, start, len)));
    }

    public void endDocument() throws SAXException {
        this.validator.endDocument();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.validator.endPrefixMapping(prefix);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        this.validator.processingInstruction(target, data);
    }

    public void setDocumentLocator(Locator locator) {
        this.validator.setDocumentLocator(locator);
    }

    public void skippedEntity(String name) throws SAXException {
        this.validator.skippedEntity(name);
        throw new SAXException("Unknown entity: " + name);
    }

    public void startDocument() throws SAXException {
        this.validator.startDocument();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.validator.startPrefixMapping(prefix, uri);
    }
}

