/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.MultiTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.core.StopException;
import freemarker.ext.dom.NodeModel;
import freemarker.log.Logger;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.SimpleScalar;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNodeModel;
import freemarker.template.utility.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import org.freemarker.docgen.BugException;
import org.freemarker.docgen.CJSONInterpreter;
import org.freemarker.docgen.DocBook5Constants;
import org.freemarker.docgen.DocgenException;
import org.freemarker.docgen.DocgenLogger;
import org.freemarker.docgen.DocgenValidationOptions;
import org.freemarker.docgen.FileUtil;
import org.freemarker.docgen.TableSimplifier;
import org.freemarker.docgen.TextUtil;
import org.freemarker.docgen.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Transform {
    static final String FILE_BOOK = "book.xml";
    static final String FILE_ARTICLE = "article.xml";
    static final String FILE_SETTINGS = "docgen.cjson";
    static final String FILE_DETAILED_TOC_HTML = "detailed-toc.html";
    static final String FILE_INDEX_HTML = "index.html";
    static final String DIR_TEMPLATES = "docgen-templates";
    static final String SETTING_VALIDATION = "validation";
    static final String SETTING_OFFLINE = "offline";
    static final String SETTING_ONLINE_TRACKER_HTML = "onlineTrackerHTML";
    static final String SETTING_INTERNAL_BOOKMARKS = "internalBookmarks";
    static final String SETTING_EXTERNAL_BOOKMARKS = "externalBookmarks";
    static final String SETTING_OLINKS = "olinks";
    static final String SETTING_ECLIPSE = "eclipse";
    static final String SETTING_SHOW_EDITORAL_NOTES = "showEditoralNotes";
    static final String SETTING_GENERATE_ECLIPSE_TOC = "generateEclipseTOC";
    static final String SETTING_SHOW_XXE_LOGO = "showXXELogo";
    static final String SETTING_DISABLE_JAVASCRIPT = "disableJavaScript";
    static final String SETTING_TIME_ZONE = "timeZone";
    static final String SETTING_LOCALE = "locale";
    static final String SETTING_CONTENT_DIRECTORY = "contentDirectory";
    static final String SETTING_LOWEST_PAGE_TOC_ELEMENT_RANK = "lowestPageTOCElementRank";
    static final String SETTING_LOWEST_FILE_ELEMENT_RANK = "lowestFileElementRank";
    static final String SETTING_MAX_TOF_DISPLAY_DEPTH = "maxTOFDisplayDepth";
    static final String SETTING_MAX_MAIN_TOF_DISPLAY_DEPTH = "maxMainTOFDisplayDepth";
    static final String SETTING_NUMBERED_SECTIONS = "numberedSections";
    static final String SETTING_VALIDATION_PROGRAMLISTINGS_REQ_ROLE = "programlistingsRequireRole";
    static final String SETTING_VALIDATION_PROGRAMLISTINGS_REQ_LANG = "programlistingsRequireLanguage";
    static final String SETTING_VALIDATION_OUTPUT_FILES_CAN_USE_AUTOID = "outputFilesCanUseAutoID";
    static final String SETTING_VALIDATION_MAXIMUM_PROGRAMLISTING_WIDTH = "maximumProgramlistingWidth";
    static final String SETTING_ECLIPSE_LINK_TO = "link_to";
    private static final String VAR_OFFLINE = "offline";
    private static final String VAR_ONLINE_TRACKER_HTML = "onlineTrackerHTML";
    private static final String VAR_SHOW_EDITORAL_NOTES = "showEditoralNotes";
    private static final String VAR_TRANSFORM_START_TIME = "transformStartTime";
    private static final String VAR_SHOW_XXE_LOGO = "showXXELogo";
    private static final String VAR_DISABLE_JAVASCRIPT = "disableJavaScript";
    private static final String VAR_ECLIPSE_LINK_TO = "link_to";
    private static final String VAR_INTERNAL_BOOKMARDS = "internalBookmarks";
    private static final String VAR_EXTERNAL_BOOKMARDS = "externalBookmarks";
    private static final String VAR_OLINKS = "olinks";
    private static final String VAR_TOC_DISPLAY_DEPTH = "maxTOFDisplayDepth";
    private static final String VAR_NUMBERED_SECTIONS = "numberedSections";
    private static final String VAR_INDEX_ENTRIES = "indexEntries";
    private static final String VAR_STARTS_WITH_TOP_LEVEL_CONTENT = "startsWithTopLevelContent";
    private static final String VAR_PAGE_TYPE = "pageType";
    private static final String VAR_ALTERNATIVE_TOC_LINK = "alternativeTOCLink";
    private static final String VAR_ALTERNATIVE_TOC_LABEL = "alternativeTOCLabel";
    private static final String VAR_PARENT_FILE_ELEMENT = "parentFileElement";
    private static final String VAR_NEXT_FILE_ELEMENT = "nextFileElement";
    private static final String VAR_PREVIOUS_FILE_ELEMENT = "previousFileElement";
    private static final String VAR_ROOT_ELEMENT = "rootElement";
    private static final String VAR_SHOW_NAVIGATION_BAR = "showNavigationBar";
    private static final String VAR_SHOW_BREADCRUMB = "showBreadCrumb";
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private static final String PAGE_TYPE_DETAILED_TOC = "docgen:detailed_toc";
    private static final String A_DOCGEN_FILE_ELEMENT = "docgen_file_element";
    private static final String A_DOCGEN_PAGE_TOC_ELEMENT = "docgen_page_toc_element";
    private static final String A_DOCGEN_DETAILED_TOC_ELEMENT = "docgen_detailed_toc_element";
    private static final String A_DOCGEN_ROOT_ELEMENT = "docgen_root_element";
    private static final String A_DOCGEN_TITLE_PREFIX = "docgen_title_prefix";
    private static final String A_DOCGEN_UNITED_NUMBERING = "docgen_united_numbering";
    private static final String A_DOCGEN_RANK = "docgen_rank";
    static final String AUTO_ID_PREFIX = "autoid_";
    static final String DOCGEN_ID_PREFIX = "docgen_";
    private static final Set<String> GUARANTEED_ID_ELEMENTS;
    private static final Set<String> PREFACE_LIKE_ELEMENTS;
    private File destDir;
    private File srcDir;
    private File contentDir;
    private Boolean offline;
    private String onlineTrackerHTML;
    private DocumentStructureRank lowestFileElemenRank = DocumentStructureRank.SECTION1;
    private DocumentStructureRank lowestPageTOCElemenRank = DocumentStructureRank.SECTION3;
    private int maxTOFDisplayDepth = Integer.MAX_VALUE;
    private int maxMainTOFDisplayDepth;
    private boolean numberedSectons;
    private boolean generateEclipseTOC;
    private boolean showEditoralNotes;
    private boolean showXXELogo;
    private boolean disableJavaScript;
    private boolean validate = true;
    private Locale locale = Locale.US;
    private TimeZone timeZone = TimeZone.getTimeZone("GMT");
    private boolean printProgress;
    private LinkedHashMap<String, String> internalBookmarks = new LinkedHashMap();
    private LinkedHashMap<String, String> externalBookmarks = new LinkedHashMap();
    private DocgenValidationOptions validationOps = new DocgenValidationOptions();
    private boolean executed;
    private Map<String, String> olinks = new HashMap<String, String>();
    private Map<String, List<NodeModel>> primaryIndexTermLookup;
    private Map<String, SortedMap<String, List<NodeModel>>> secondaryIndexTermLookup;
    private Map<String, Element> elementsById;
    private List<TOCNode> tocNodes;
    private List<String> indexEntries;
    private Configuration fmConfig;
    private TOCNode currentFileTOCNode;
    private DocgenLogger logger = new DocgenLogger(){

        public void info(String message) {
            if (Transform.this.printProgress) {
                System.out.println(message);
            }
        }

        public void warning(String message) {
            if (Transform.this.printProgress) {
                System.out.println("Warning:" + message);
            }
        }
    };
    private static final String COMMON_TOC_TOPOLOGY_ERROR_HINT = " (Hint: Review the \"lowestPageTOCElementRank\" setting. Maybe it's incompatible with the structure of this document.)";
    private static final String COMMON_FILE_TOPOLOGY_ERROR_HINT = " (Hint: Review the \"lowestFileElementRank\" setting. Maybe it's incompatible with the structure of this document.)";
    private TemplateMethodModel createLinkFromID = new TemplateMethodModel(){

        public Object exec(List args) throws TemplateModelException {
            if (args.size() != 1) {
                throw new TemplateModelException("Method CreateLinkFromID should have exactly one parameter.");
            }
            String id = (String)args.get(0);
            Element elem = (Element)Transform.this.elementsById.get(id);
            if (elem == null) {
                throw new TemplateModelException("No element exists with this id: \"" + id + "\"");
            }
            try {
                return new SimpleScalar(Transform.this.createElementLinkURL(elem));
            }
            catch (DocgenException e) {
                throw new TemplateModelException("CreateLinkFromID failed to create link.", (Exception)e);
            }
        }
    };
    private TemplateMethodModel createLinkFromNode = new TemplateMethodModelEx(){

        public Object exec(List args) throws TemplateModelException {
            if (args.size() != 1) {
                throw new TemplateModelException("Method CreateLinkFromNode should have exactly one parameter.");
            }
            Object arg1 = args.get(0);
            if (!(arg1 instanceof NodeModel)) {
                throw new TemplateModelException("The first parameter to CreateLinkFromNode must be a node, but it wasn't. (Class: " + arg1.getClass().getName() + ")");
            }
            Node node = ((NodeModel)arg1).getNode();
            if (!(node instanceof Element)) {
                throw new TemplateModelException("The first parameter to CreateLinkFromNode must be an element node, but it wasn't. (Class: " + arg1.getClass().getName() + ")");
            }
            try {
                return new SimpleScalar(Transform.this.createElementLinkURL((Element)node));
            }
            catch (DocgenException e) {
                throw new TemplateModelException("CreateLinkFromNode falied to create link.", (Exception)e);
            }
        }
    };
    private TemplateMethodModel nodeFromID = new TemplateMethodModel(){

        public Object exec(List args) throws TemplateModelException {
            Node node = (Node)Transform.this.elementsById.get(args.get(0));
            return NodeModel.wrap((Node)node);
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void execute() throws DocgenException, IOException, SAXException {
        void var8_18;
        if (this.executed) {
            throw new DocgenException("This transformation was alrady executed; use a new " + Transform.class.getName() + ".");
        }
        this.executed = true;
        if (this.srcDir == null) {
            throw new DocgenException("The source directory (the DocBook XML) wasn't specified.");
        }
        if (!this.srcDir.isDirectory()) {
            throw new IOException("Source directory doesn't exist: " + this.srcDir.getAbsolutePath());
        }
        if (this.destDir == null) {
            throw new DocgenException("The destination directory wasn't specified.");
        }
        File templatesDir = null;
        String eclipseLinkTo = null;
        File cfgFile = new File(this.srcDir, FILE_SETTINGS);
        if (cfgFile.exists()) {
            Map<String, Object> cfg;
            try {
                cfg = CJSONInterpreter.evalAsMap(cfgFile);
            }
            catch (CJSONInterpreter.EvaluationException e) {
                throw new DocgenException(e.getMessage(), e.getCause());
            }
            for (Map.Entry<String, Object> cfgEnt : cfg.entrySet()) {
                String s;
                String target;
                String name;
                Map<String, Object> m;
                String settingName = cfgEnt.getKey();
                Object object = cfgEnt.getValue();
                if (settingName.equals("olinks")) {
                    m = this.itIsAMapSetting(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        target = this.itIsAStringValueInAMapSetting(cfgFile, settingName, ent.getValue());
                        this.olinks.put(name, target);
                    }
                    continue;
                }
                if (settingName.equals("internalBookmarks")) {
                    m = this.itIsAMapSetting(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        target = this.itIsAStringValueInAMapSetting(cfgFile, settingName, ent.getValue());
                        this.internalBookmarks.put(name, target);
                    }
                    continue;
                }
                if (settingName.equals("externalBookmarks")) {
                    m = this.itIsAMapSetting(cfgFile, settingName, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        target = this.itIsAStringValueInAMapSetting(cfgFile, settingName, ent.getValue());
                        this.externalBookmarks.put(name, target);
                    }
                    continue;
                }
                if (settingName.equals(SETTING_VALIDATION)) {
                    m = this.itIsAMapSetting(cfgFile, SETTING_VALIDATION, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = ent.getKey();
                        if (name.equals(SETTING_VALIDATION_PROGRAMLISTINGS_REQ_ROLE)) {
                            this.validationOps.setProgramlistingRequiresRole(this.itIsABooleanSetting(cfgFile, (String)settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        if (name.equals(SETTING_VALIDATION_PROGRAMLISTINGS_REQ_LANG)) {
                            this.validationOps.setProgramlistingRequiresLanguage(this.itIsABooleanSetting(cfgFile, (String)settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        if (name.equals(SETTING_VALIDATION_OUTPUT_FILES_CAN_USE_AUTOID)) {
                            this.validationOps.setOutputFilesCanUseAutoID(this.itIsABooleanSetting(cfgFile, (String)settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        if (name.equals(SETTING_VALIDATION_MAXIMUM_PROGRAMLISTING_WIDTH)) {
                            this.validationOps.setMaximumProgramlistingWidth(this.itIsAnIntSetting(cfgFile, (String)settingName + "." + name, ent.getValue()));
                            continue;
                        }
                        throw this.newCfgFileException(cfgFile, SETTING_VALIDATION, "Unknown validation option: " + name);
                    }
                    continue;
                }
                if (settingName.equals("offline")) {
                    if (this.offline != null) continue;
                    this.offline = this.itIsABooleanSetting(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("onlineTrackerHTML")) {
                    String onlineTrackerHtmlPath = this.itIsAStringSetting(cfgFile, settingName, object);
                    File f = new File(this.getSourceDirectory(), onlineTrackerHtmlPath);
                    if (!f.exists()) {
                        throw this.newCfgFileException(cfgFile, "onlineTrackerHTML", "File not found: " + f.toPath());
                    }
                    this.onlineTrackerHTML = FileUtil.loadString(f, UTF_8);
                    continue;
                }
                if (settingName.equals(SETTING_ECLIPSE)) {
                    m = this.itIsAMapSetting(cfgFile, SETTING_ECLIPSE, object);
                    for (Map.Entry<String, Object> ent : m.entrySet()) {
                        name = (String)ent.getKey();
                        if (name.equals("link_to")) {
                            String value;
                            eclipseLinkTo = value = this.itIsAStringSetting(cfgFile, (String)settingName + "." + name, ent.getValue());
                            continue;
                        }
                        throw this.newCfgFileException(cfgFile, settingName, "Unknown Eclipse option: " + name);
                    }
                    continue;
                }
                if (settingName.equals(SETTING_LOCALE)) {
                    s = this.itIsAStringSetting(cfgFile, settingName, object);
                    this.locale = StringUtil.deduceLocale((String)s);
                    continue;
                }
                if (settingName.equals(SETTING_TIME_ZONE)) {
                    s = this.itIsAStringSetting(cfgFile, settingName, object);
                    this.timeZone = TimeZone.getTimeZone(s);
                    continue;
                }
                if (settingName.equals(SETTING_GENERATE_ECLIPSE_TOC)) {
                    this.generateEclipseTOC = this.itIsABooleanSetting(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("showEditoralNotes")) {
                    this.showEditoralNotes = this.itIsABooleanSetting(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("showXXELogo")) {
                    this.showXXELogo = this.itIsABooleanSetting(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals("disableJavaScript")) {
                    this.disableJavaScript = this.itIsABooleanSetting(cfgFile, settingName, object);
                    continue;
                }
                if (settingName.equals(SETTING_CONTENT_DIRECTORY)) {
                    s = this.itIsAStringSetting(cfgFile, settingName, object);
                    this.contentDir = new File(this.srcDir, s);
                    if (this.contentDir.isDirectory()) continue;
                    throw this.newCfgFileException(cfgFile, settingName, "It's not an existing directory: " + this.contentDir.getAbsolutePath());
                }
                if (settingName.equals(SETTING_LOWEST_FILE_ELEMENT_RANK) || settingName.equals(SETTING_LOWEST_PAGE_TOC_ELEMENT_RANK)) {
                    DocumentStructureRank rank;
                    String strRank = this.itIsAStringSetting(cfgFile, settingName, object);
                    try {
                        rank = DocumentStructureRank.valueOf(strRank.toUpperCase());
                    }
                    catch (IllegalArgumentException e) {
                        String msg = strRank.equalsIgnoreCase("article") ? "\"article\" is not a rank, since articles can have various ranks depending on their context. (Hint: if the article is the top-level element then it has \"chapter\" rank.)" : "Unknown rank: " + strRank;
                        throw this.newCfgFileException(cfgFile, settingName, msg);
                    }
                    if (settingName.equals(SETTING_LOWEST_FILE_ELEMENT_RANK)) {
                        this.lowestFileElemenRank = rank;
                        continue;
                    }
                    if (settingName.equals(SETTING_LOWEST_PAGE_TOC_ELEMENT_RANK)) {
                        this.lowestPageTOCElemenRank = rank;
                        continue;
                    }
                    throw new BugException("Unexpected setting name.");
                }
                if (settingName.equals("maxTOFDisplayDepth")) {
                    this.maxTOFDisplayDepth = this.itIsAnIntSetting(cfgFile, settingName, object);
                    if (this.maxTOFDisplayDepth >= 1) continue;
                    throw this.newCfgFileException(cfgFile, settingName, "Value must be at least 1.");
                }
                if (settingName.equals(SETTING_MAX_MAIN_TOF_DISPLAY_DEPTH)) {
                    this.maxMainTOFDisplayDepth = this.itIsAnIntSetting(cfgFile, settingName, object);
                    if (this.maxTOFDisplayDepth >= 1) continue;
                    throw this.newCfgFileException(cfgFile, settingName, "Value must be at least 1.");
                }
                if (settingName.equals("numberedSections")) {
                    this.numberedSectons = this.itIsABooleanSetting(cfgFile, settingName, object);
                    continue;
                }
                throw this.newCfgFileException(cfgFile, "Unknown setting: \"" + (String)settingName + "\". (Hint: See the list of available " + "settings in the Java API documentation of " + Transform.class.getName() + ". Also, note that " + "setting names are case-sensitive.)");
            }
            if (this.offline == null) {
                throw new DocgenException("The \"offline\" setting wasn't specified; it must be set to true or false");
            }
        }
        if (this.lowestPageTOCElemenRank.compareTo(this.lowestFileElemenRank) > 0) {
            this.lowestPageTOCElemenRank = this.lowestFileElemenRank;
        }
        if (this.maxMainTOFDisplayDepth == 0) {
            this.maxMainTOFDisplayDepth = this.maxTOFDisplayDepth;
        }
        if (!(templatesDir = new File(this.srcDir, DIR_TEMPLATES)).exists()) {
            templatesDir = null;
        }
        if (this.contentDir == null) {
            this.contentDir = this.srcDir;
        }
        this.primaryIndexTermLookup = new HashMap<String, List<NodeModel>>();
        this.secondaryIndexTermLookup = new HashMap<String, SortedMap<String, List<NodeModel>>>();
        this.elementsById = new HashMap<String, Element>();
        this.tocNodes = new ArrayList<TOCNode>();
        this.indexEntries = new ArrayList<String>();
        try {
            Logger.selectLoggerLibrary((int)0);
        }
        catch (ClassNotFoundException e) {
            throw new BugException(e);
        }
        this.fmConfig = new Configuration();
        ClassTemplateLoader templateLoader = new ClassTemplateLoader(Transform.class, "templates");
        if (templatesDir != null) {
            templateLoader = new MultiTemplateLoader(new TemplateLoader[]{new FileTemplateLoader(templatesDir), templateLoader});
        }
        this.fmConfig.setTemplateLoader((TemplateLoader)templateLoader);
        this.fmConfig.setLocale(this.locale);
        this.fmConfig.setTimeZone(this.timeZone);
        File docFile = new File(this.contentDir, FILE_BOOK);
        if (!docFile.isFile()) {
            docFile = new File(this.contentDir, FILE_ARTICLE);
        }
        if (!docFile.isFile()) {
            throw new DocgenException("The book file is missing: " + docFile.getAbsolutePath());
        }
        Document doc = XMLUtil.loadDocBook5XML(docFile, this.validate, this.validationOps, this.logger);
        this.preprocessDOM(doc);
        if (!this.destDir.isDirectory() && !this.destDir.mkdirs()) {
            throw new IOException("Failed to create destination directory: " + this.destDir.getAbsolutePath());
        }
        for (Map.Entry entry : this.internalBookmarks.entrySet()) {
            String id = (String)entry.getValue();
            if (this.elementsById.containsKey(id)) continue;
            throw this.newCfgFileException(cfgFile, "internalBookmarks", "No element with id \"" + id + "\" exists in the book.");
        }
        try {
            this.fmConfig.setSharedVariable("offline", (Object)this.offline);
            this.fmConfig.setSharedVariable("onlineTrackerHTML", (Object)this.onlineTrackerHTML);
            this.fmConfig.setSharedVariable("showEditoralNotes", (Object)this.showEditoralNotes);
            this.fmConfig.setSharedVariable("showXXELogo", (Object)this.showXXELogo);
            this.fmConfig.setSharedVariable("disableJavaScript", (Object)this.disableJavaScript);
            this.fmConfig.setSharedVariable("olinks", this.olinks);
            this.fmConfig.setSharedVariable("numberedSections", (Object)this.numberedSectons);
            this.fmConfig.setSharedVariable("externalBookmarks", this.externalBookmarks);
            this.fmConfig.setSharedVariable("internalBookmarks", this.internalBookmarks);
            this.fmConfig.setSharedVariable(VAR_ROOT_ELEMENT, (Object)doc.getDocumentElement());
            this.fmConfig.setSharedVariable(VAR_TRANSFORM_START_TIME, (Object)new Date());
            this.fmConfig.setSharedVariable(VAR_INDEX_ENTRIES, this.indexEntries);
            int tofCntLv1 = this.countTOFEntries(this.tocNodes.get(0), 1);
            int n = this.countTOFEntries(this.tocNodes.get(0), 2);
            this.fmConfig.setSharedVariable(VAR_SHOW_NAVIGATION_BAR, (Object)(tofCntLv1 != 0 || this.internalBookmarks.size() != 0 || this.externalBookmarks.size() != 0 ? 1 : 0));
            this.fmConfig.setSharedVariable(VAR_SHOW_BREADCRUMB, (Object)(tofCntLv1 != n ? 1 : 0));
            this.fmConfig.setSharedVariable("NodeFromID", (TemplateModel)this.nodeFromID);
            this.fmConfig.setSharedVariable("CreateLinkFromID", (TemplateModel)this.createLinkFromID);
            this.fmConfig.setSharedVariable("primaryIndexTermLookup", this.primaryIndexTermLookup);
            this.fmConfig.setSharedVariable("secondaryIndexTermLookup", this.secondaryIndexTermLookup);
            this.fmConfig.setSharedVariable("CreateLinkFromNode", (TemplateModel)this.createLinkFromNode);
        }
        catch (TemplateModelException e) {
            throw new BugException(e);
        }
        this.logger.info("Generating HTML files...");
        int htmlFileCounter = 0;
        for (TOCNode tocNode : this.tocNodes) {
            if (!tocNode.isFileElement()) continue;
            try {
                this.currentFileTOCNode = tocNode;
                try {
                    htmlFileCounter += this.generateHTMLFile();
                }
                finally {
                    this.currentFileTOCNode = null;
                }
            }
            catch (StopException e) {
                throw new DocgenException(e.getMessage());
            }
            catch (TemplateException e) {
                this.logger.info(e.getFTLInstructionStack());
                throw new BugException(e);
            }
        }
        this.logger.info("Copying common static files...");
        this.copyCommonStatic("docgen.css");
        this.copyCommonStatic("img/none.gif");
        boolean bl = true;
        while (var8_18 < 15) {
            this.copyCommonStatic("img/callouts/" + (int)var8_18 + ".gif");
            ++var8_18;
        }
        this.copyCommonStatic("img/navigation-gradient.gif");
        if (this.showXXELogo) {
            this.copyCommonStatic("img/xxe.gif");
        }
        if (!this.disableJavaScript) {
            this.copyCommonStatic("jquery.js");
            this.copyCommonStatic("linktargetmarker.js");
            this.copyCommonStatic("img/linktargetmarker.gif");
        }
        this.logger.info("Copying custom static files...");
        int n = FileUtil.copyDir(this.contentDir, this.destDir, true);
        if (this.generateEclipseTOC) {
            this.logger.info("Generating Eclipse ToC...");
            Template template = this.fmConfig.getTemplate("eclipse-toc.ftl");
            BufferedWriter wr = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(new File(this.destDir, "eclipse-toc.xml")), "UTF-8"));
            try {
                try {
                    SimpleHash dataModel = new SimpleHash();
                    if (eclipseLinkTo != null) {
                        dataModel.put("link_to", (Object)eclipseLinkTo);
                    }
                    template.process((Object)dataModel, (Writer)wr, null, (TemplateNodeModel)NodeModel.wrap((Node)doc));
                }
                catch (TemplateException e) {
                    throw new BugException("Failed to generate Eclipse ToC (see cause exception).", e);
                }
            }
            finally {
                ((Writer)wr).close();
            }
        }
        this.logger.info("Done: " + htmlFileCounter + " HTML-s + " + n + " custom statics + commons" + (this.generateEclipseTOC ? " + Eclipse ToC" : ""));
    }

    private DocgenException newCfgFileException(File cfgFile, String settingName, String desc) {
        settingName = settingName.replace(".", "\" per \"");
        return this.newCfgFileException(cfgFile, "Wrong value for setting \"" + settingName + "\": " + desc);
    }

    private DocgenException newCfgFileException(File cfgFile, String desc) {
        return this.newCfgFileException(cfgFile, desc, (Throwable)null);
    }

    private DocgenException newCfgFileException(File cfgFile, String desc, Throwable cause) {
        StringBuilder sb = new StringBuilder();
        sb.append("Wrong configuration");
        if (cfgFile != null) {
            sb.append(" file \"");
            sb.append(cfgFile.getAbsolutePath());
            sb.append("\"");
        }
        sb.append(": ");
        sb.append(desc);
        return new DocgenException(sb.toString(), cause);
    }

    private Map<String, Object> itIsAMapSetting(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof Map)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a map (like {key1: value1, key2: value2}), but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (Map)settingValue;
    }

    private String itIsAStringSetting(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof String)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a string, but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (String)settingValue;
    }

    private boolean itIsABooleanSetting(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof Boolean)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be a boolean (i.e., true or false), but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        return (Boolean)settingValue;
    }

    private int itIsAnIntSetting(File cfgFile, String settingName, Object settingValue) throws DocgenException {
        if (!(settingValue instanceof Number)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be an number, but it's a " + CJSONInterpreter.cjsonTypeOf(settingValue) + ".");
        }
        if (!(settingValue instanceof Integer)) {
            throw this.newCfgFileException(cfgFile, settingName, "Should be an integer number (32 bits max), but it's: " + settingValue);
        }
        return (Integer)settingValue;
    }

    private String itIsAStringValueInAMapSetting(File cfgFile, String settingName, Object mapEntryValue) throws DocgenException {
        if (!(mapEntryValue instanceof String)) {
            throw this.newCfgFileException(cfgFile, settingName, "The values in the key-value pairs of this map must be strings, but some of them is a " + CJSONInterpreter.cjsonTypeOf(mapEntryValue) + ".");
        }
        return (String)mapEntryValue;
    }

    private void copyCommonStatic(String path) throws IOException {
        FileUtil.copyResourceIntoFile(Transform.class, "statics", path, new File(this.destDir, "docgen-resources"));
    }

    private void preprocessDOM(Document doc) throws SAXException, DocgenException {
        NodeModel.simplify((Node)doc);
        this.preprocessDOM_addRanks(doc);
        this.preprocessDOM_misc(doc);
        this.preprocessDOM_buildTOC(doc);
    }

    private void preprocessDOM_misc(Document doc) throws SAXException, DocgenException {
        this.preprocessDOM_misc_inner(doc, new PreprocessDOMMisc_GlobalState(), new PreprocessDOMMisc_ParentSectState());
        this.indexEntries = new ArrayList<String>(this.primaryIndexTermLookup.keySet());
        Collections.sort(this.indexEntries, Collator.getInstance(this.locale));
    }

    private void preprocessDOM_misc_inner(Node node, PreprocessDOMMisc_GlobalState globalState, PreprocessDOMMisc_ParentSectState parentSectState) throws SAXException, DocgenException {
        if (node instanceof Element) {
            String ref;
            String loRef;
            Element elem = (Element)node;
            String id = XMLUtil.getAttribute(elem, "xml:id");
            if (id != null) {
                if (id.startsWith(AUTO_ID_PREFIX)) {
                    throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " uses a reserved xml:id, " + TextUtil.jQuote(id) + ". All ID-s starting with " + "\"" + AUTO_ID_PREFIX + "\" are reserved for " + "Docgen.");
                }
                if (id.startsWith(DOCGEN_ID_PREFIX)) {
                    throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " uses a reserved xml:id, " + TextUtil.jQuote(id) + ". All ID-s starting with " + "\"" + DOCGEN_ID_PREFIX + "\" are reserved for " + "Docgen.");
                }
                elem.setAttribute("id", id);
            }
            String elemName = node.getNodeName();
            if (id == null && GUARANTEED_ID_ELEMENTS.contains(elemName)) {
                globalState.lastId++;
                id = AUTO_ID_PREFIX + globalState.lastId;
                elem.setAttribute("id", id);
            }
            if (id != null) {
                this.elementsById.put(id, elem);
            }
            if (elemName.equals("preface") || elemName.equals("glossary") || elemName.equals("index")) {
                this.ensureTitleExists(elem, Character.toUpperCase(elemName.charAt(0)) + elemName.substring(1));
            } else if ((elemName.equals("informaltable") || elemName.equals("table")) && elem.getNamespaceURI().equals("http://docbook.org/ns/docbook")) {
                TableSimplifier.simplify(elem);
            } else if (elemName.equals("indexterm")) {
                this.addIndexTerm(node);
            } else if (!(!elemName.equals("imagedata") || (loRef = (ref = XMLUtil.getAttribute(elem, "fileref")).toLowerCase()).startsWith("http://") || loRef.startsWith("https://") || ref.startsWith("/") || new File(this.contentDir, ref.replace('/', File.separatorChar)).isFile())) {
                throw new DocgenException(XMLUtil.theSomethingElement(elem) + " contains " + "a broken file reference: \"" + ref.replace("\"", "&quot;") + "\"");
            }
            if (DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(elemName)) {
                String prefix = elem.getParentNode() instanceof Document ? null : (this.hasPrefaceLikeParent(elem) ? null : (this.numberedSectons && elemName.equals("section") ? String.valueOf(parentSectState.arabicNumber++) : (elemName.equals("chapter") ? String.valueOf(parentSectState.arabicNumber++) : (elemName.equals("part") ? TextUtil.toUpperRomanNumber(parentSectState.upperRomanNumber++) : (elemName.equals("appendix") ? TextUtil.toUpperLatinNumber(parentSectState.upperLatinNumber++) : (elemName.equals("article") ? TextUtil.toLowerRomanNumber(parentSectState.lowerRomanNumber++) : null))))));
                if (prefix != null) {
                    String inhPrefix;
                    Node parent = elem.getParentNode();
                    String fullPrefix = parent instanceof Element && !parent.getLocalName().equals("part") && !parent.getLocalName().equals("article") ? ((inhPrefix = XMLUtil.getAttribute((Element)parent, A_DOCGEN_TITLE_PREFIX)) != null ? (inhPrefix.endsWith(".") ? inhPrefix + prefix : inhPrefix + "." + prefix) : prefix) : prefix;
                    elem.setAttribute(A_DOCGEN_TITLE_PREFIX, fullPrefix);
                }
                elem.setAttribute(A_DOCGEN_UNITED_NUMBERING, String.valueOf(parentSectState.unitedNumber++));
                parentSectState = new PreprocessDOMMisc_ParentSectState();
            }
        }
        NodeList children = node.getChildNodes();
        int ln = children.getLength();
        for (int i = 0; i < ln; ++i) {
            this.preprocessDOM_misc_inner(children.item(i), globalState, parentSectState);
        }
    }

    private void preprocessDOM_addRanks(Document doc) throws DocgenException {
        Element root = doc.getDocumentElement();
        String rootName = root.getLocalName();
        if (rootName.equals("book")) {
            root.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.BOOK.toString());
            this.preprocessDOM_addRanks_underBookRank(root);
        } else if (rootName.equals("article")) {
            root.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.CHAPTER.toString());
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(root, 0);
        } else {
            throw new DocgenException("The \"" + rootName + "\" element is " + "unsupported as root element.");
        }
    }

    private void preprocessDOM_addRanks_underBookRank(Element root) throws DocgenException {
        DocumentStructureRank commonRank = null;
        for (Element child : XMLUtil.childrenElementsOf(root)) {
            String name = child.getLocalName();
            if (name.equals("part")) {
                if (commonRank != null && !commonRank.equals((Object)DocumentStructureRank.PART)) {
                    throw new DocgenException("Bad document structure: " + XMLUtil.theSomethingElement(child) + " is on the " + "same ToC level with a \"" + "chapter" + "\" element.");
                }
                commonRank = DocumentStructureRank.PART;
                continue;
            }
            if (!name.equals("chapter")) continue;
            if (commonRank != null && !commonRank.equals((Object)DocumentStructureRank.CHAPTER)) {
                throw new DocgenException("Bad document structure: " + XMLUtil.theSomethingElement(child) + " is on the " + "same ToC level with a \"" + "part" + "\" element.");
            }
            commonRank = DocumentStructureRank.CHAPTER;
        }
        if (commonRank == null) {
            commonRank = DocumentStructureRank.CHAPTER;
        }
        for (Element child : XMLUtil.childrenElementsOf(root)) {
            if (!DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(child.getLocalName())) continue;
            child.setAttribute(A_DOCGEN_RANK, commonRank.toString());
            if (child.getLocalName().equals("part")) {
                this.preprocessDOM_addRanks_underTruePart(child);
                continue;
            }
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(child, 0);
        }
    }

    private void preprocessDOM_addRanks_underTruePart(Node parent) throws DocgenException {
        for (Element child : XMLUtil.childrenElementsOf(parent)) {
            if (!DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(child.getLocalName())) continue;
            child.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.CHAPTER.toString());
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(child, 0);
        }
    }

    private void preprocessDOM_addRanks_underChapterRankOrDeeper(Element parent, int underSectionRank) throws DocgenException {
        for (Element child : XMLUtil.childrenElementsOf(parent)) {
            if (!DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(child.getLocalName())) continue;
            if (child.getLocalName().equals("simplesect")) {
                child.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.SIMPLESECT.toString());
                continue;
            }
            if (underSectionRank + 1 > 3) {
                throw new DocgenException("Too deep ToC nesting for " + XMLUtil.theSomethingElement(child) + ": rank bellow " + DocumentStructureRank.sectionToString(3));
            }
            child.setAttribute(A_DOCGEN_RANK, DocumentStructureRank.sectionToString(underSectionRank + 1));
            this.preprocessDOM_addRanks_underChapterRankOrDeeper(child, underSectionRank + 1);
        }
    }

    private void preprocessDOM_buildTOC(Document doc) throws DocgenException {
        this.preprocessDOM_buildTOC_inner(doc, 0, null);
        if (this.tocNodes.size() > 0) {
            this.preprocessDOM_buildTOC_checkTOCTopology(this.tocNodes.get(0));
            if (!this.tocNodes.get(0).isFileElement()) {
                throw new BugException("The root ToC node must be a file-element.");
            }
            this.preprocessDOM_buildTOC_checkFileTopology(this.tocNodes.get(0));
        }
    }

    private void preprocessDOM_buildTOC_checkTOCTopology(TOCNode tocNode) throws DocgenException {
        TOCNode parent = tocNode.getParent();
        if (parent != null && !parent.getElement().isSameNode(tocNode.getElement().getParentNode())) {
            throw new DocgenException("Bad ToC-element topology: In the ToC " + parent.theSomethingElement() + " is the parent of " + tocNode.theSomethingElement() + ", yet they are not in parent-child relation in the XML " + "document (but maybe in grandparent-nephew relation or " + "like)." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
        }
        TOCNode next = tocNode.getNext();
        Element relevantSibling = this.preprocessDOM_buildTOC_getSectionLikeSibling(tocNode.getElement(), true);
        if (next != null) {
            if (relevantSibling == null) {
                throw new DocgenException("Bad ToC-element topology: In the ToC " + next.theSomethingElement() + " is the following sibling of " + tocNode.theSomethingElement() + ", yet they are not siblings in the XML document." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
            }
            if (!relevantSibling.isSameNode(next.getElement())) {
                throw new DocgenException("Bad ToC-element topology: In the ToC " + next.theSomethingElement() + " is the immediate following sibling of " + tocNode.theSomethingElement() + ", but in the XML document there is a \"" + relevantSibling.getLocalName() + "\" element between them, or they aren't siblings " + "at all." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
            }
        } else if (relevantSibling != null) {
            throw new DocgenException("Bad ToC-element topology: In the ToC hierarchy " + tocNode.theSomethingElement() + "\" is a last-child, but in the XML document it has " + "a \"" + relevantSibling.getLocalName() + "\" " + "element as its following sibling." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
        }
        TOCNode prev = tocNode.getPrevious();
        relevantSibling = this.preprocessDOM_buildTOC_getSectionLikeSibling(tocNode.getElement(), false);
        if (prev == null && relevantSibling != null) {
            throw new DocgenException("Bad ToC-element topology: In the ToC hierarchy " + tocNode.theSomethingElement() + " is a first-child, " + "but in the XML document it has a " + "\"" + relevantSibling.getLocalName() + "\" " + "element as its preceding sibling." + COMMON_TOC_TOPOLOGY_ERROR_HINT);
        }
        for (TOCNode child = tocNode.getFirstChild(); child != null; child = child.getNext()) {
            this.preprocessDOM_buildTOC_checkTOCTopology(child);
        }
    }

    private Element preprocessDOM_buildTOC_getSectionLikeSibling(Element elem, boolean next) {
        Node relevantSibling = elem;
        while (!((relevantSibling = next ? relevantSibling.getNextSibling() : relevantSibling.getPreviousSibling()) == null || relevantSibling instanceof Element && DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(relevantSibling.getLocalName()))) {
        }
        return relevantSibling;
    }

    private void preprocessDOM_buildTOC_checkFileTopology(TOCNode tocNode) throws DocgenException {
        TOCNode firstChild = tocNode.getFirstChild();
        if (firstChild != null) {
            boolean firstIsFileElement = firstChild.isFileElement();
            TOCNode child = firstChild;
            do {
                if (child.isFileElement() != firstIsFileElement) {
                    throw new DocgenException("Bad file-element topology: The first child element of " + tocNode.theSomethingElement() + ", " + firstChild.theSomethingElement() + ", is " + (firstIsFileElement ? "a" : "not a") + " file-element, while another child, " + child.theSomethingElement() + (firstIsFileElement ? " isn't" : " is") + ". Either all relevant children elements must be " + "file-elements or neither can be." + COMMON_FILE_TOPOLOGY_ERROR_HINT);
                }
                this.preprocessDOM_buildTOC_checkFileTopology(child);
            } while ((child = child.getNext()) != null);
            if (firstIsFileElement && !tocNode.isFileElement()) {
                throw new DocgenException("Bad file-element topology: " + tocNode.theSomethingElement() + " is not a " + "file-element, yet it has file-element children, " + firstChild.theSomethingElement() + ". Only " + "file-elements can have children that are " + "file-elements.");
            }
        }
    }

    private TOCNode preprocessDOM_buildTOC_inner(Node node, int sectionLevel, TOCNode parentTOCNode) throws DocgenException {
        TOCNode curTOCNode = null;
        int newSectionLevel = sectionLevel;
        if (node instanceof Element) {
            Element elem = (Element)node;
            String nodeName = node.getNodeName();
            if (DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS.contains(nodeName)) {
                DocumentStructureRank rank = DocumentStructureRank.valueOf(XMLUtil.getAttribute(elem, A_DOCGEN_RANK).toUpperCase());
                boolean isTheDocumentElement = elem.getParentNode() instanceof Document;
                if (isTheDocumentElement || rank.compareTo(this.lowestPageTOCElemenRank) >= 0) {
                    curTOCNode = new TOCNode(elem, this.tocNodes.size());
                    this.tocNodes.add(curTOCNode);
                    if ((isTheDocumentElement || rank.compareTo(this.lowestFileElemenRank) >= 0) && !this.hasPrefaceLikeParent(elem)) {
                        elem.setAttribute(A_DOCGEN_FILE_ELEMENT, "true");
                        if (isTheDocumentElement) {
                            curTOCNode.setFileName(FILE_INDEX_HTML);
                            elem.setAttribute(A_DOCGEN_ROOT_ELEMENT, "true");
                        } else {
                            String id = XMLUtil.getAttribute(elem, "id");
                            if (id == null) {
                                throw new BugException("Missing id attribute");
                            }
                            if (!this.validationOps.getOutputFilesCanUseAutoID() && id.startsWith(AUTO_ID_PREFIX)) {
                                throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " has automatically generated ID " + "that is not allowed as the ID " + "is used for generating a file " + "name. (Related setting: \"" + SETTING_VALIDATION + "\" per \"" + SETTING_VALIDATION_OUTPUT_FILES_CAN_USE_AUTOID + "\")");
                            }
                            String fileName = id + ".html";
                            if (fileName.equals(FILE_DETAILED_TOC_HTML) || fileName.equals(FILE_INDEX_HTML)) {
                                throw new DocgenException(XMLUtil.theSomethingElement(elem, true) + " has an xml:id that is deduced to " + "a reserved output file name, \"" + fileName + "\". (Hint: Change the " + "xml:id.)");
                            }
                            curTOCNode.setFileName(fileName);
                        }
                    } else {
                        elem.setAttribute(A_DOCGEN_PAGE_TOC_ELEMENT, "true");
                    }
                    elem.setAttribute(A_DOCGEN_DETAILED_TOC_ELEMENT, "true");
                }
            }
        }
        if (curTOCNode != null) {
            parentTOCNode = curTOCNode;
        }
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            TOCNode child = this.preprocessDOM_buildTOC_inner(children.item(i), newSectionLevel, parentTOCNode);
            if (child == null || parentTOCNode == null) continue;
            child.setParent(parentTOCNode);
            TOCNode lastChild = parentTOCNode.getLastChild();
            if (lastChild != null) {
                child.setPrevious(lastChild);
                lastChild.setNext(child);
            }
            if (parentTOCNode.getFirstChild() == null) {
                parentTOCNode.setFirstChild(child);
            }
            parentTOCNode.setLastChild(child);
        }
        return curTOCNode;
    }

    private boolean hasPrefaceLikeParent(Element elem) {
        Node parent;
        while ((parent = elem.getParentNode()) != null && parent instanceof Element) {
            elem = (Element)parent;
            if (!elem.getNamespaceURI().equals("http://docbook.org/ns/docbook") || !PREFACE_LIKE_ELEMENTS.contains(elem.getLocalName())) continue;
            return true;
        }
        return false;
    }

    private Element getTitle(Element elem) {
        NodeList children = elem.getChildNodes();
        int ln = children.getLength();
        for (int i = 0; i < ln; ++i) {
            Node child = children.item(i);
            if (!(child instanceof Element) || !child.getLocalName().equals("title")) continue;
            return (Element)child;
        }
        return null;
    }

    private void ensureTitleExists(Element elem, String defaultTitle) {
        if (this.getTitle(elem) != null) {
            return;
        }
        Node node = elem;
        do {
            if ((node = node.getParentNode()) != null) continue;
            throw new BugException("Can't find Document node.");
        } while (node.getNodeType() != 9);
        Document doc = (Document)node;
        Element title = doc.createElementNS("http://docbook.org/ns/docbook", "title");
        title.appendChild(doc.createTextNode(defaultTitle));
        elem.insertBefore(title, elem.getFirstChild());
    }

    private TOCNode getFileTOCNodeFor(Element elem) {
        for (TOCNode tocNode : this.tocNodes) {
            if (!tocNode.isFileElement() || !tocNode.getElement().isSameNode(elem)) continue;
            return tocNode;
        }
        return null;
    }

    private void addIndexTerm(Node node) {
        Node primary = null;
        Node secondary = null;
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = node.getChildNodes().item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals("primary")) {
                primary = child;
                continue;
            }
            if (!child.getNodeName().equals("secondary")) continue;
            secondary = child;
        }
        String primaryText = primary.getFirstChild().getNodeValue().trim();
        if (!this.primaryIndexTermLookup.containsKey(primaryText)) {
            this.primaryIndexTermLookup.put(primaryText, new ArrayList());
        }
        if (secondary != null) {
            String secondaryText;
            Map m;
            ArrayList<NodeModel> nodes;
            if (!this.secondaryIndexTermLookup.containsKey(primaryText)) {
                this.secondaryIndexTermLookup.put(primaryText, new TreeMap());
            }
            if ((nodes = (ArrayList<NodeModel>)(m = (Map)this.secondaryIndexTermLookup.get(primaryText)).get(secondaryText = secondary.getFirstChild().getNodeValue().trim())) == null) {
                nodes = new ArrayList<NodeModel>();
                m.put(secondaryText, nodes);
            }
            nodes.add(NodeModel.wrap((Node)node));
        } else {
            this.primaryIndexTermLookup.get(primaryText).add(NodeModel.wrap((Node)node));
        }
    }

    private int generateHTMLFile() throws IOException, TemplateException {
        int mainTOFEntryCount;
        SimpleHash dataModel = new SimpleHash();
        TOCNode otherTOCNode = this.currentFileTOCNode;
        while ((otherTOCNode = otherTOCNode.getPreviousInTraversarOrder()) != null && !otherTOCNode.isFileElement()) {
        }
        dataModel.put(VAR_PREVIOUS_FILE_ELEMENT, (Object)(otherTOCNode != null ? otherTOCNode.getElement() : null));
        otherTOCNode = this.currentFileTOCNode;
        while ((otherTOCNode = otherTOCNode.getNextInTraversarOrder()) != null && !otherTOCNode.isFileElement()) {
        }
        dataModel.put(VAR_NEXT_FILE_ELEMENT, (Object)(otherTOCNode != null ? otherTOCNode.getElement() : null));
        otherTOCNode = this.currentFileTOCNode.getParent();
        dataModel.put(VAR_PARENT_FILE_ELEMENT, (Object)(otherTOCNode != null ? otherTOCNode.getElement() : null));
        Element curElem = this.currentFileTOCNode.getElement();
        boolean isTheDocumentElement = curElem.getParentNode() instanceof Document;
        dataModel.put("maxTOFDisplayDepth", (Object)(isTheDocumentElement ? this.maxTOFDisplayDepth : this.maxMainTOFDisplayDepth));
        dataModel.put(VAR_STARTS_WITH_TOP_LEVEL_CONTENT, this.startsWithTopLevelContent(this.currentFileTOCNode.getElement()));
        boolean generateDetailedTOC = false;
        if (isTheDocumentElement && (mainTOFEntryCount = this.countTOFEntries(this.currentFileTOCNode, this.maxMainTOFDisplayDepth)) != 0 && (double)mainTOFEntryCount < (double)this.tocNodes.size() * 0.75) {
            generateDetailedTOC = true;
            dataModel.put(VAR_ALTERNATIVE_TOC_LINK, (Object)FILE_DETAILED_TOC_HTML);
            dataModel.put(VAR_ALTERNATIVE_TOC_LABEL, (Object)"show detailed");
        }
        this.generateHTMLFile_inner(dataModel, this.currentFileTOCNode.getFileName());
        if (generateDetailedTOC) {
            dataModel.put(VAR_PAGE_TYPE, (Object)PAGE_TYPE_DETAILED_TOC);
            dataModel.put(VAR_ALTERNATIVE_TOC_LINK, (Object)this.currentFileTOCNode.getFileName());
            dataModel.put(VAR_ALTERNATIVE_TOC_LABEL, (Object)"show simplified");
            this.generateHTMLFile_inner(dataModel, FILE_DETAILED_TOC_HTML);
            return 2;
        }
        return 1;
    }

    private int countTOFEntries(TOCNode parent, int displayDepth) {
        int sum = 0;
        for (TOCNode child = parent.getFirstChild(); child != null; child = child.getNext()) {
            if (!child.isFileElement()) continue;
            ++sum;
            if (displayDepth <= 1) continue;
            sum += this.countTOFEntries(child, displayDepth - 1);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateHTMLFile_inner(SimpleHash dataModel, String fileName) throws TemplateException, IOException {
        Template template = this.fmConfig.getTemplate("page.ftl");
        File outputFile = new File(this.destDir, fileName);
        FileOutputStream fos = new FileOutputStream(outputFile);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        BufferedWriter writer = new BufferedWriter(osw, 2048);
        try {
            template.process((Object)dataModel, (Writer)writer, null, (TemplateNodeModel)NodeModel.wrap((Node)this.currentFileTOCNode.getElement()));
        }
        finally {
            ((Writer)writer).close();
        }
    }

    private boolean startsWithTopLevelContent(Element element) {
        for (Element elem : XMLUtil.childrenElementsOf(element)) {
            if (!elem.getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            if (elem.hasAttribute(A_DOCGEN_FILE_ELEMENT) || elem.hasAttribute(A_DOCGEN_PAGE_TOC_ELEMENT)) {
                return false;
            }
            String name = elem.getLocalName();
            if (name.equals("title") || name.equals("subtitle") || name.equals("info") || name.equals("footnote") || !DocBook5Constants.VISIBLE_TOPLEVEL_ELEMENTS.contains(name)) continue;
            return true;
        }
        return false;
    }

    private String createElementLinkURL(Element elem) throws DocgenException {
        Node node;
        String id = null;
        for (node = elem; !(node == null || node instanceof Element && (id = XMLUtil.getAttribute(node, "id")) != null); node = node.getParentNode()) {
        }
        if (id == null) {
            throw new DocgenException("Can't create link for the \"" + elem.getLocalName() + "\" element: Nor this element nor its ascendants have an " + "id.");
        }
        Element idElem = node;
        String fileName = null;
        Element curElem = idElem;
        do {
            TOCNode fileTOCNode;
            if ((fileTOCNode = this.getFileTOCNodeFor(curElem)) == null) {
                curElem = (Element)curElem.getParentNode();
                continue;
            }
            fileName = fileTOCNode.getFileName();
        } while (fileName == null);
        String link = this.currentFileTOCNode != null && fileName.equals(this.currentFileTOCNode.getFileName()) ? "" : fileName;
        if (this.getFileTOCNodeFor(idElem) == null) {
            link = link + "#" + id;
        }
        if (link.length() == 0) {
            link = fileName;
        }
        return link;
    }

    public File getDestinationDirectory() {
        return this.destDir;
    }

    public void setDestinationDirectory(File destDir) {
        this.destDir = destDir;
    }

    public File getSourceDirectory() {
        return this.srcDir;
    }

    public void setSourceDirectory(File srcDir) {
        this.srcDir = srcDir;
    }

    public Boolean getOffline() {
        return this.offline;
    }

    public void setOffline(Boolean offline) {
        this.offline = offline;
    }

    public boolean getShowEditoralNotes() {
        return this.showEditoralNotes;
    }

    public void setShowEditoralNotes(boolean showEditoralNotes) {
        this.showEditoralNotes = showEditoralNotes;
    }

    public boolean getValidate() {
        return this.validate;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    public boolean getPrintProgress() {
        return this.printProgress;
    }

    public void setPrintProgress(boolean printProgress) {
        this.printProgress = printProgress;
    }

    public boolean getGenerateEclipseToC() {
        return this.generateEclipseTOC;
    }

    public void setGenerateEclipseToC(boolean eclipseToC) {
        this.generateEclipseTOC = eclipseToC;
    }

    static {
        HashSet<String> idAttElems = new HashSet<String>();
        for (String elemName : DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS) {
            idAttElems.add(elemName);
        }
        idAttElems.add("glossary");
        idAttElems.add("glossentry");
        GUARANTEED_ID_ELEMENTS = Collections.unmodifiableSet(idAttElems);
        HashSet<String> sinlgeFileElems = new HashSet<String>();
        sinlgeFileElems.add("preface");
        PREFACE_LIKE_ELEMENTS = Collections.unmodifiableSet(sinlgeFileElems);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DocumentStructureRank {
        SIMPLESECT,
        SECTION3,
        SECTION2,
        SECTION1,
        CHAPTER,
        PART,
        BOOK;


        public String toString() {
            return this.name().toLowerCase();
        }

        static String sectionToString(int level) {
            return SECTION1.toString().substring(0, SECTION1.toString().length() - 1) + level;
        }
    }

    private class TOCNode {
        private final Element element;
        private final int traversalIndex;
        private TOCNode parent;
        private TOCNode next;
        private TOCNode previous;
        private TOCNode firstChild;
        private TOCNode lastChild;
        private String fileName;

        public TOCNode(Element element, int traversalIndex) {
            this.element = element;
            this.traversalIndex = traversalIndex;
        }

        public TOCNode getFirstChild() {
            return this.firstChild;
        }

        public void setFirstChild(TOCNode firstChild) {
            this.firstChild = firstChild;
        }

        public TOCNode getLastChild() {
            return this.lastChild;
        }

        public void setLastChild(TOCNode lastChild) {
            this.lastChild = lastChild;
        }

        public void setParent(TOCNode parent) {
            this.parent = parent;
        }

        public TOCNode getNext() {
            return this.next;
        }

        public void setNext(TOCNode next) {
            this.next = next;
        }

        public TOCNode getPrevious() {
            return this.previous;
        }

        public void setPrevious(TOCNode previous) {
            this.previous = previous;
        }

        public TOCNode getParent() {
            return this.parent;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public Element getElement() {
            return this.element;
        }

        public boolean isFileElement() {
            return this.fileName != null;
        }

        public String theSomethingElement() {
            return XMLUtil.theSomethingElement(this.element);
        }

        public TOCNode getNextInTraversarOrder() {
            return this.traversalIndex + 1 < Transform.this.tocNodes.size() ? (TOCNode)Transform.this.tocNodes.get(this.traversalIndex + 1) : null;
        }

        public TOCNode getPreviousInTraversarOrder() {
            return this.traversalIndex > 0 ? (TOCNode)Transform.this.tocNodes.get(this.traversalIndex - 1) : null;
        }
    }

    private static final class PreprocessDOMMisc_ParentSectState {
        private int upperRomanNumber = 1;
        private int lowerRomanNumber = 1;
        private int arabicNumber = 1;
        private int upperLatinNumber = 1;
        private int unitedNumber = 1;

        private PreprocessDOMMisc_ParentSectState() {
            this.notAUtiltiyClass();
        }

        void notAUtiltiyClass() {
        }
    }

    private static final class PreprocessDOMMisc_GlobalState {
        private int lastId;

        private PreprocessDOMMisc_GlobalState() {
            this.notAUtiltiyClass();
        }

        void notAUtiltiyClass() {
        }
    }
}

