/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import org.freemarker.docgen.BugException;

final class TextUtil {
    private static final char[] UPPER_ROMAN_DIGITS = new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M'};
    private static final char[] LOWER_ROMAN_DIGITS = new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm'};

    private TextUtil() {
    }

    public static String jQuote(String s) {
        if (s == null) {
            return "null";
        }
        int ln = s.length();
        int next = 0;
        StringBuilder b = new StringBuilder(ln + 3);
        b.append("\"");
        for (int i = 0; i < ln; ++i) {
            char c = s.charAt(i);
            if (c != '\\' && c != '\"' && c >= ' ') continue;
            b.append(s.substring(next, i));
            switch (c) {
                case '\\': {
                    b.append("\\\\");
                    break;
                }
                case '\"': {
                    b.append("\\\"");
                    break;
                }
                case '\n': {
                    b.append("\\n");
                    break;
                }
                case '\r': {
                    b.append("\\r");
                    break;
                }
                case '\t': {
                    b.append("\\t");
                    break;
                }
                case '\b': {
                    b.append("\\b");
                    break;
                }
                case '\f': {
                    b.append("\\f");
                    break;
                }
                default: {
                    b.append("\\u0000");
                    int x = b.length();
                    String s2 = Integer.toHexString(c);
                    b.replace(x - s2.length(), x, s2);
                }
            }
            next = i + 1;
        }
        if (next < ln) {
            b.append(s.substring(next));
        }
        b.append("\"");
        return b.toString();
    }

    public static String jQuoteOrName(char c) {
        if (c == '\\' || c == '\'' || c == '\"' || c < ' ') {
            switch (c) {
                case '\\': {
                    return "'\\\\'";
                }
                case '\'': {
                    return "\"apostrophe-quote\"";
                }
                case '\"': {
                    return "\"quotation mark\"";
                }
                case '\n': {
                    return "'\\n'";
                }
                case '\r': {
                    return "'\\r'";
                }
                case '\t': {
                    return "'\\t'";
                }
                case '\b': {
                    return "'\\b'";
                }
                case '\f': {
                    return "'\\f'";
                }
            }
            String s = Integer.toHexString(c);
            int ln = s.length();
            if (ln == 1) {
                return "'\\u000" + s + "'";
            }
            if (ln == 2) {
                return "'\\u00" + s + "'";
            }
            if (ln == 3) {
                return "'\\u0" + s + "'";
            }
            return "'\\u" + s + "'";
        }
        return "'" + c + "'";
    }

    public static String toUpperRomanNumber(int n) {
        return TextUtil.toRomanNumber(n, UPPER_ROMAN_DIGITS);
    }

    public static String toLowerRomanNumber(int n) {
        return TextUtil.toRomanNumber(n, LOWER_ROMAN_DIGITS);
    }

    private static String toRomanNumber(int n, char[] romanDigits) {
        if (n > 3999) {
            throw new IllegalArgumentException("toRomanNumber only supports numbers  in the [1..3999] range, but the number was " + n + ".");
        }
        StringBuilder res = new StringBuilder();
        int base = 0;
        while (n != 0) {
            int digit = n % 10;
            n /= 10;
            if (digit != 0) {
                switch (digit) {
                    case 3: {
                        res.append(romanDigits[base]);
                    }
                    case 2: {
                        res.append(romanDigits[base]);
                    }
                    case 1: {
                        res.append(romanDigits[base]);
                        break;
                    }
                    case 4: {
                        res.append(romanDigits[base + 1]).append(romanDigits[base]);
                        break;
                    }
                    case 8: {
                        res.append(romanDigits[base]);
                    }
                    case 7: {
                        res.append(romanDigits[base]);
                    }
                    case 6: {
                        res.append(romanDigits[base]);
                    }
                    case 5: {
                        res.append(romanDigits[base + 1]);
                        break;
                    }
                    case 9: {
                        res.append(romanDigits[base + 2]);
                        res.append(romanDigits[base]);
                        break;
                    }
                    default: {
                        throw new BugException("Unexpected branch");
                    }
                }
            }
            base += 2;
        }
        return res.reverse().toString();
    }

    public static String toUpperLatinNumber(int n) {
        return TextUtil.toLatinNumber(n, 'A');
    }

    public static String toLowerLatinNumber(int n) {
        return TextUtil.toLatinNumber(n, 'a');
    }

    private static String toLatinNumber(int n, char oneDigit) {
        int nextWeight;
        int nextReached;
        if (n < 1) {
            throw new IllegalArgumentException("Can't convert 0 or negative numbers to latin-number.");
        }
        int reached = 1;
        int weight = 1;
        while ((nextReached = reached + (nextWeight = weight * 26)) <= n) {
            weight = nextWeight;
            reached = nextReached;
        }
        StringBuilder sb = new StringBuilder();
        while (weight != 0) {
            int digitIncrease = (n - reached) / weight;
            sb.append((char)(oneDigit + digitIncrease));
            reached += digitIncrease * weight;
            weight /= 26;
        }
        return sb.toString();
    }
}

