/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.freemarker.docgen.DocgenException;
import org.freemarker.docgen.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

final class TableSimplifier {
    private final Element table;
    private final List<Alignment> colGroupAligns = new ArrayList<Alignment>();
    private final List<VAlignment> colGroupVAligns = new ArrayList<VAlignment>();
    private boolean[] cellMatrix;
    private int cellMatrixWidth;
    private int cellMatrixHeight;
    private int cellMatrixCurRow;
    private int cellMatrixCurCol;

    static void simplify(Element table) throws SAXException, DocgenException {
        new TableSimplifier(table).processTable();
    }

    private TableSimplifier(Element table) {
        this.table = table;
    }

    private void processTable() throws SAXException, DocgenException {
        this.processAndRemoveColGroupsAndCols();
        this.decorateCells();
    }

    private void processAndRemoveColGroupsAndCols() throws SAXException, DocgenException {
        LinkedList<Element> toRemove = new LinkedList<Element>();
        NodeList children = this.table.getChildNodes();
        int childCnt = children.getLength();
        for (int childIdx = 0; childIdx < childCnt; ++childIdx) {
            Element elem;
            Node node = children.item(childIdx);
            if (!(node instanceof Element) || !(elem = (Element)node).getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            String elemName = elem.getLocalName();
            if (elemName.equals("colgroup")) {
                this.processColGroup(elem);
                toRemove.add(elem);
                continue;
            }
            if (!elemName.equals("col")) continue;
            this.processCol(elem, null, null);
            toRemove.add(elem);
        }
        for (Element element : toRemove) {
            this.table.removeChild(element);
        }
    }

    private void processColGroup(Element colGroup) throws SAXException, DocgenException {
        boolean usesAtts = false;
        int span = 1;
        Alignment align = null;
        VAlignment valign = null;
        NamedNodeMap atts = colGroup.getAttributes();
        int attCnt = atts.getLength();
        for (int attIdx = 0; attIdx < attCnt; ++attIdx) {
            Attr att = (Attr)atts.item(attIdx);
            String attNS = att.getNamespaceURI();
            if (attNS != null && attNS.length() != 0) continue;
            String attName = att.getLocalName();
            String attValue = att.getValue().trim();
            if (attName.equals("span")) {
                usesAtts = true;
                span = this.parseSpanAttribute(attValue, "span", "colgroup");
                continue;
            }
            if (attName.equals("align")) {
                align = this.parseAlignAttribute(attValue, "colgroup");
                continue;
            }
            if (attName.equals("valign")) {
                valign = this.parseVAlignAttribute(attValue, "colgroup");
                continue;
            }
            throw new DocgenException("The \"" + attName + "\" attribute of the \"" + "colgroup" + "\" element is not supported by Docgen.");
        }
        if (usesAtts) {
            for (int i = 0; i < span; ++i) {
                this.colGroupAligns.add(align);
                this.colGroupVAligns.add(valign);
            }
        }
        NodeList children = colGroup.getChildNodes();
        int childCnt = children.getLength();
        for (int childIdx = 0; childIdx < childCnt; ++childIdx) {
            Element elem;
            Node child = children.item(childIdx);
            if (!(child instanceof Element) || !(elem = (Element)child).getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            String elemName = elem.getLocalName();
            if (elemName.equals("col")) {
                if (usesAtts) {
                    throw new SAXException("The \"colgroup\" already used attributes, so it can't have \"col\" elements in it.");
                }
                this.processCol(elem, align, valign);
                continue;
            }
            throw new SAXException("The \"" + elemName + "\" element " + "is unexpected inside \"" + "colgroup" + "\".");
        }
    }

    private void processCol(Element col, Alignment colGroupDefaultAlign, VAlignment colGroupDefaultVAlign) throws SAXException, DocgenException {
        int span = 1;
        Alignment align = colGroupDefaultAlign;
        VAlignment valign = colGroupDefaultVAlign;
        NamedNodeMap atts = col.getAttributes();
        int attCnt = atts.getLength();
        for (int attIdx = 0; attIdx < attCnt; ++attIdx) {
            Attr att = (Attr)atts.item(attIdx);
            String attNS = att.getNamespaceURI();
            if (attNS != null && attNS.length() != 0) continue;
            String attName = att.getLocalName();
            String attValue = att.getValue().trim();
            if (attName.equals("span")) {
                span = this.parseSpanAttribute(attValue, "span", "col");
                continue;
            }
            if (attName.equals("align")) {
                align = this.parseAlignAttribute(attValue, "col");
                continue;
            }
            if (attName.equals("valign")) {
                valign = this.parseVAlignAttribute(attValue, "col");
                continue;
            }
            throw new DocgenException("The \"" + attName + "\" attribute of the \"" + "col" + "\" element is not supported by Docgen.");
        }
        for (int i = 0; i < span; ++i) {
            this.colGroupAligns.add(align);
            this.colGroupVAligns.add(valign);
        }
    }

    private Alignment parseAlignAttribute(String attValue, String elemName) throws SAXException {
        String lAttValue = attValue.toLowerCase();
        if (lAttValue.equals("left")) {
            return Alignment.LEFT;
        }
        if (lAttValue.equals("center")) {
            return Alignment.CENTER;
        }
        if (lAttValue.equals("right")) {
            return Alignment.RIGHT;
        }
        throw new SAXException("Illegal \"align\" attribute value for a(n) \"" + elemName + "\" element: " + attValue);
    }

    private VAlignment parseVAlignAttribute(String attValue, String elemName) throws SAXException, DocgenException {
        String lAttValue = attValue.toLowerCase();
        if (lAttValue.equals("top")) {
            return VAlignment.TOP;
        }
        if (lAttValue.equals("bottom")) {
            return VAlignment.BOTTOM;
        }
        if (lAttValue.equals("middle")) {
            return VAlignment.MIDDLE;
        }
        if (lAttValue.equals("baseline")) {
            throw new DocgenException("The \"baseline\" value for \"valign\" attribute is not implemented by Docgen.");
        }
        throw new SAXException("Illegal \"valign\" attribute value for a(n) \"" + elemName + "\" element: " + attValue);
    }

    private int parseSpanAttribute(String attValue, String attName, String elemName) throws SAXException {
        int span;
        try {
            span = Integer.valueOf(attValue);
        }
        catch (NumberFormatException e) {
            throw new SAXException("Illegal \"" + attName + "\" attribute value for a(n) \"" + elemName + "\" element: " + attValue);
        }
        if (span < 1) {
            throw new SAXException("Illegal \"" + attName + "\" attribute value for a(n) \"" + elemName + "\" element: " + attValue);
        }
        return span;
    }

    private void decorateCells() throws SAXException, DocgenException {
        this.initCellMatrix();
        NodeList children = this.table.getChildNodes();
        int childCnt = children.getLength();
        for (int childIdx = 0; childIdx < childCnt; ++childIdx) {
            Element elem;
            Node child = children.item(childIdx);
            if (!(child instanceof Element) || !(elem = (Element)child).getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            String elemName = elem.getLocalName();
            if (elemName.equals("thead") || elemName.equals("tbody") || elemName.equals("tfoot")) {
                this.decorateTDiv(elem);
                continue;
            }
            if (!elemName.equals("tr")) continue;
            this.decorateRow(elem, null, null);
        }
        this.checkFinishedCellMatrix();
    }

    private void decorateTDiv(Element tDiv) throws SAXException, DocgenException {
        this.initCellMatrix();
        Alignment tDivAlign = null;
        VAlignment tDivVAlign = null;
        NamedNodeMap atts = tDiv.getAttributes();
        int attCnt = atts.getLength();
        for (int attIdx = 0; attIdx < attCnt; ++attIdx) {
            Attr att = (Attr)atts.item(attIdx);
            String attNS = att.getNamespaceURI();
            if (attNS != null && attNS.length() != 0) continue;
            String attName = att.getLocalName();
            String attValue = att.getValue().trim();
            if (attName.equals("align")) {
                tDivAlign = this.parseAlignAttribute(attValue, tDiv.getLocalName());
                continue;
            }
            if (attName.equals("valign")) {
                tDivVAlign = this.parseVAlignAttribute(attValue, tDiv.getLocalName());
                continue;
            }
            throw new DocgenException("The \"" + attName + "\" attribute of the \"" + tDiv.getLocalName() + "\" element is not supported by Docgen.");
        }
        NodeList children = tDiv.getChildNodes();
        int childCnt = children.getLength();
        for (int childIdx = 0; childIdx < childCnt; ++childIdx) {
            Element elem;
            Node child = children.item(childIdx);
            if (!(child instanceof Element) || !(elem = (Element)child).getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            String elemName = elem.getLocalName();
            if (elemName.equals("tr")) {
                this.decorateRow(elem, tDivAlign, tDivVAlign);
                continue;
            }
            throw new SAXException("The \"" + elemName + "\" should " + "not occur inside \"" + tDiv.getLocalName() + "\".");
        }
        this.checkFinishedCellMatrix();
    }

    private void decorateRow(Element tr, Alignment tDivAlign, VAlignment tDivVAlign) throws SAXException, DocgenException {
        this.addRowToCellMatrix();
        Alignment trAlign = null;
        VAlignment trVAlign = null;
        NamedNodeMap atts = tr.getAttributes();
        int attCnt = atts.getLength();
        for (int attIdx = 0; attIdx < attCnt; ++attIdx) {
            Attr att = (Attr)atts.item(attIdx);
            String attNS = att.getNamespaceURI();
            if (attNS != null && attNS.length() != 0) continue;
            String attName = att.getLocalName();
            String attValue = att.getValue().trim();
            if (attName.equals("align")) {
                trAlign = this.parseAlignAttribute(attValue, "tr");
                continue;
            }
            if (attName.equals("valign")) {
                trVAlign = this.parseVAlignAttribute(attValue, "tr");
                continue;
            }
            throw new DocgenException("The \"" + attName + "\" attribute of the \"" + "tr" + "\" element is not supported by Docgen.");
        }
        if (trAlign == null) {
            trAlign = tDivAlign;
        }
        if (trVAlign == null) {
            trVAlign = tDivVAlign;
        }
        NodeList children = tr.getChildNodes();
        int childCnt = children.getLength();
        for (int childIdx = 0; childIdx < childCnt; ++childIdx) {
            Element elem;
            Node child = children.item(childIdx);
            if (!(child instanceof Element) || !(elem = (Element)child).getNamespaceURI().equals("http://docbook.org/ns/docbook")) continue;
            String elemName = elem.getLocalName();
            if (elemName.equals("td") || elemName.equals("th")) {
                this.decorateCell(elem, trAlign, trVAlign);
                continue;
            }
            throw new SAXException("The \"" + elemName + "\" should " + "not occur inside \"" + "tr" + "\".");
        }
    }

    private void decorateCell(Element cell, Alignment trAlign, VAlignment trVAlign) throws SAXException, DocgenException {
        Alignment cellAlign = null;
        VAlignment cellVAlign = null;
        int rowSpan = 1;
        int colSpan = 1;
        String elemName = cell.getLocalName();
        NamedNodeMap atts = cell.getAttributes();
        int attCnt = atts.getLength();
        for (int attIdx = 0; attIdx < attCnt; ++attIdx) {
            Attr att = (Attr)atts.item(attIdx);
            String attNS = att.getNamespaceURI();
            if (attNS != null && attNS.length() != 0) continue;
            String attName = att.getLocalName();
            String attValue = att.getValue().trim();
            if (attName.equals("align")) {
                cellAlign = this.parseAlignAttribute(attValue, elemName);
                continue;
            }
            if (attName.equals("valign")) {
                cellVAlign = this.parseVAlignAttribute(attValue, elemName);
                continue;
            }
            if (attName.equals("rowspan")) {
                rowSpan = this.parseSpanAttribute(attValue, "rowspan", elemName);
                continue;
            }
            if (attName.equals("colspan")) {
                colSpan = this.parseSpanAttribute(attValue, "colspan", elemName);
                continue;
            }
            throw new DocgenException("The \"" + attName + "\" attribute of the \"" + elemName + "\" element is not supported by Docgen.");
        }
        int visualCol = this.addCellToCellMatrix(rowSpan, colSpan);
        if (cellAlign == null) {
            Alignment colGroupAlign;
            Alignment alignment = colGroupAlign = this.colGroupAligns.size() > visualCol ? this.colGroupAligns.get(visualCol) : null;
            if (colGroupAlign != null && trAlign != colGroupAlign) {
                cell.setAttribute("align", colGroupAlign.toString());
            }
        }
        if (cellVAlign == null && trVAlign == null) {
            VAlignment colGroupVAlign;
            VAlignment vAlignment = colGroupVAlign = this.colGroupVAligns.size() > visualCol ? this.colGroupVAligns.get(visualCol) : null;
            if (colGroupVAlign != null) {
                cell.setAttribute("valign", colGroupVAlign.toString());
            }
        }
    }

    private void addRowToCellMatrix() {
        ++this.cellMatrixCurRow;
        this.cellMatrixCurCol = 0;
    }

    private int addCellToCellMatrix(int rowSpan, int colSpan) throws DocgenException {
        int curIdx = this.cellMatrixCurRow * this.cellMatrixWidth + this.cellMatrixCurCol;
        if (this.cellMatrixCurRow < this.cellMatrixHeight) {
            int curIdxLim = (this.cellMatrixCurRow + 1) * this.cellMatrixWidth;
            while (curIdx < curIdxLim && this.cellMatrix[curIdx]) {
                ++curIdx;
                ++this.cellMatrixCurCol;
            }
        }
        int newCellMatrixHeight = this.cellMatrixHeight;
        int newCellMatrixWidth = this.cellMatrixWidth;
        if (this.cellMatrixHeight <= this.cellMatrixCurRow + rowSpan - 1) {
            newCellMatrixHeight = (this.cellMatrixCurRow + rowSpan) * 2;
        }
        if (this.cellMatrixWidth <= this.cellMatrixCurCol + colSpan - 1) {
            newCellMatrixWidth = (this.cellMatrixCurCol + colSpan) * 2;
        }
        if (newCellMatrixHeight != this.cellMatrixHeight || newCellMatrixWidth != this.cellMatrixWidth) {
            boolean[] newCellMatrix = new boolean[newCellMatrixHeight * newCellMatrixWidth];
            for (int row = 0; row < this.cellMatrixHeight; ++row) {
                System.arraycopy(this.cellMatrix, row * this.cellMatrixWidth, newCellMatrix, row * newCellMatrixWidth, this.cellMatrixWidth);
            }
            this.cellMatrix = newCellMatrix;
            this.cellMatrixWidth = newCellMatrixWidth;
            this.cellMatrixHeight = newCellMatrixHeight;
            curIdx = this.cellMatrixCurRow * this.cellMatrixWidth + this.cellMatrixCurCol;
        }
        for (int relRow = 0; relRow < rowSpan; ++relRow) {
            int brushIdx = curIdx + relRow * this.cellMatrixWidth;
            for (int relCol = 0; relCol < colSpan; ++relCol) {
                if (this.cellMatrix[brushIdx]) {
                    throw new DocgenException(XMLUtil.theSomethingElement(this.table, true) + " has overlapping cells; check if \"" + "rowspan" + "\"-s and/or \"" + "colspan" + "\"-s are correct.");
                }
                this.cellMatrix[brushIdx++] = true;
            }
        }
        return this.cellMatrixCurCol;
    }

    private void initCellMatrix() throws DocgenException {
        this.cellMatrix = null;
        this.cellMatrixWidth = 0;
        this.cellMatrixHeight = 0;
        this.cellMatrixCurRow = -1;
        this.cellMatrixCurCol = 0;
    }

    private void checkFinishedCellMatrix() throws DocgenException {
        int firstRowUtilizedWidth = -1;
        for (int row = 0; row < this.cellMatrixHeight; ++row) {
            int currentRowUtilizedWidth = 0;
            boolean lastCell = true;
            for (int col = 0; col < this.cellMatrixWidth; ++col) {
                boolean cell = this.cellMatrix[row * this.cellMatrixWidth + col];
                if (cell) {
                    if (!lastCell) {
                        throw this.newNonRectangularTableException();
                    }
                    ++currentRowUtilizedWidth;
                }
                lastCell = cell;
            }
            if (firstRowUtilizedWidth == -1) {
                firstRowUtilizedWidth = currentRowUtilizedWidth;
                continue;
            }
            if (currentRowUtilizedWidth == firstRowUtilizedWidth || currentRowUtilizedWidth == 0) continue;
            throw this.newNonRectangularTableException();
        }
    }

    private DocgenException newNonRectangularTableException() {
        return new DocgenException("Wrong cell layout in " + XMLUtil.theSomethingElement(this.table) + ". Due to the bad number of cells in" + " some rows (or due to wrong \"" + "colspan" + "\" and/or \"" + "rowspan" + "\" values) the contour of the " + "table, or the contour of some of its row-groups (\"" + "thead" + "\" or \"" + "tbody" + "\" or \"" + "tfoot" + "\") is not rectangular. That is, some cells protrude " + "out at the edge. (Visual editors may hide this error by " + "chopping protruding cells or by adding blind cells.)");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum VAlignment {
        TOP{

            public String toString() {
                return "top";
            }
        }
        ,
        MIDDLE{

            public String toString() {
                return "middle";
            }
        }
        ,
        BOTTOM{

            public String toString() {
                return "bottom";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Alignment {
        LEFT{

            public String toString() {
                return "left";
            }
        }
        ,
        CENTER{

            public String toString() {
                return "center";
            }
        }
        ,
        RIGHT{

            public String toString() {
                return "right";
            }
        };

    }
}

