/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.ValidationDriver;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.prop.rng.RngProperty;
import com.thaiopensource.xml.sax.DraconianErrorHandler;
import com.thaiopensource.xml.sax.Jaxp11XMLReaderCreator;
import com.thaiopensource.xml.sax.XMLReaderCreator;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.freemarker.docgen.BugException;
import org.freemarker.docgen.CollectingErrorHandler;
import org.freemarker.docgen.DocBook5Constants;
import org.freemarker.docgen.DocgenRestrictionsValidator;
import org.freemarker.docgen.DocgenValidationOptions;
import org.freemarker.docgen.ValidatingDOMBuilderWithLocations;
import org.freemarker.docgen.XMLUtil;
import org.w3c.dom.Document;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

final class RelaxNGValidator {
    private static final Set<String> ELEMENTS_WITH_LOCATION;

    private RelaxNGValidator() {
    }

    public static Document load(File f, DocgenValidationOptions validationOps) throws IOException, SAXException {
        ValidatingDOMBuilderWithLocations domBuilder;
        CollectingErrorHandler collErrorHandler;
        block11: {
            SAXParser sp;
            Schema schema;
            collErrorHandler = new CollectingErrorHandler(15);
            PropertyMapBuilder schemaProps = new PropertyMapBuilder();
            ValidateProperty.XML_READER_CREATOR.put(schemaProps, (XMLReaderCreator)new Jaxp11XMLReaderCreator());
            ValidateProperty.ERROR_HANDLER.put(schemaProps, (ErrorHandler)new DraconianErrorHandler());
            RngProperty.CHECK_ID_IDREF.add(schemaProps);
            AutoSchemaReader scemaReader = new AutoSchemaReader();
            try {
                schema = scemaReader.createSchema(ValidationDriver.uriOrFileInputSource((String)RelaxNGValidator.class.getResource("schema/docbook.rng").toString()), schemaProps.toPropertyMap());
            }
            catch (IncorrectSchemaException e) {
                throw new BugException("Failed to load DocBook Realx NG schema (see cause exception).", e);
            }
            PropertyMapBuilder valiadtorProps = new PropertyMapBuilder();
            ValidateProperty.XML_READER_CREATOR.put(valiadtorProps, (XMLReaderCreator)new Jaxp11XMLReaderCreator());
            ValidateProperty.ERROR_HANDLER.put(valiadtorProps, (ErrorHandler)collErrorHandler);
            RngProperty.CHECK_ID_IDREF.add(valiadtorProps);
            Validator validator = schema.createValidator(valiadtorProps.toPropertyMap());
            SAXParserFactory spf = XMLUtil.newSAXParserFactory();
            try {
                sp = spf.newSAXParser();
            }
            catch (ParserConfigurationException e) {
                throw new BugException("Failed to create SAXParser (see cause exception).", e);
            }
            XMLReader xr = sp.getXMLReader();
            xr.setErrorHandler(collErrorHandler);
            try {
                domBuilder = new ValidatingDOMBuilderWithLocations(new DocgenRestrictionsValidator(validator.getContentHandler(), collErrorHandler, collErrorHandler, validationOps), "http://docbook.org/ns/docbook", ELEMENTS_WITH_LOCATION);
            }
            catch (ParserConfigurationException e) {
                throw new BugException("Failed to create DOM builder (see cause exception).", e);
            }
            xr.setContentHandler(domBuilder);
            DTDHandler dh = validator.getDTDHandler();
            if (dh != null) {
                xr.setDTDHandler(dh);
            }
            try {
                xr.parse(ValidationDriver.fileInputSource((File)f));
            }
            catch (SAXParseException e) {
                if (collErrorHandler.getErrors().size() != 0) break block11;
                throw e;
            }
        }
        if (collErrorHandler.getErrors().size() != 0) {
            List<String> errors = collErrorHandler.getErrors();
            StringBuilder sb = new StringBuilder("The XML wasn't valid:\n\n");
            for (String error : errors) {
                sb.append(error);
                sb.append('\n');
            }
            throw new SAXException(sb.toString());
        }
        return domBuilder.getDocument();
    }

    static {
        HashSet<String> elemWithLocation = new HashSet<String>();
        elemWithLocation.addAll(DocBook5Constants.DOCUMENT_STRUCTURE_ELEMENTS);
        elemWithLocation.add("table");
        elemWithLocation.add("informaltable");
        elemWithLocation.add("imagedata");
        ELEMENTS_WITH_LOCATION = Collections.unmodifiableSet(elemWithLocation);
    }
}

