/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import org.freemarker.docgen.Transform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FileUtil {
    private static final int READ_BUFFER_SIZE = 4096;
    private static final int COPY_BUFFER_SIZE = 65536;

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyResourceIntoFile(Class<?> srcBaseClass, String srcBaseDir, String srcRelativePath, File destDir) throws IOException {
        File dstFile = new File(destDir, srcRelativePath.replace('/', File.separatorChar));
        File curDestDir = dstFile.getParentFile();
        if (!curDestDir.isDirectory() && !curDestDir.mkdirs()) {
            throw new IOException("Failed to create destination directory: " + curDestDir.getAbsolutePath());
        }
        byte[] buffer = new byte[65536];
        String finalResourcePath = srcBaseDir == null || srcBaseDir.length() == 0 ? srcRelativePath : srcBaseDir + "/" + srcRelativePath;
        InputStream in = srcBaseClass.getResourceAsStream(finalResourcePath);
        if (in == null) {
            throw new IOException("Failed to open class-loader resource: " + finalResourcePath + " relatively to " + Transform.class.getPackage().getName());
        }
        try {
            FileOutputStream out = new FileOutputStream(dstFile);
            try {
                int ln;
                while ((ln = in.read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, ln);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
        }
        finally {
            in.close();
        }
    }

    static int copyDir(File srcDir, File destDir) throws IOException {
        return FileUtil.copyDir(srcDir, destDir, false);
    }

    static int copyDir(File srcDir, File destDir, boolean skipTopLevelXMLs) throws IOException {
        File[] ls;
        int fileCounter = 0;
        destDir = destDir.getAbsoluteFile();
        srcDir = srcDir.getAbsoluteFile();
        if (!destDir.isDirectory()) {
            if (destDir.exists()) {
                throw new IOException("Can't create directory, because a file with the same name already exists: " + destDir.getAbsolutePath());
            }
            if (!destDir.mkdir()) {
                throw new IOException("Failed to create directory: " + destDir.getAbsolutePath());
            }
        }
        if ((ls = srcDir.listFiles()) == null) {
            throw new IOException("Failed to list directory: " + srcDir.getAbsolutePath());
        }
        for (File f : srcDir.listFiles()) {
            String fName = f.getName();
            if (FileUtil.isUsualIgnorableFileOrDirectory(fName) || FileUtil.isDocgenFile(fName)) continue;
            File dest = new File(destDir, fName);
            if (f.isFile()) {
                if (skipTopLevelXMLs && fName.toLowerCase().endsWith(".xml")) continue;
                FileUtil.copyFile(f, dest);
                ++fileCounter;
                continue;
            }
            if (f.isDirectory()) {
                fileCounter += FileUtil.copyDir(f, dest);
                continue;
            }
            throw new IOException("Failed decide if it's a file or a directory: " + f.getAbsolutePath());
        }
        return fileCounter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File src, File dst) throws IOException {
        byte[] buffer = new byte[65536];
        FileInputStream in = new FileInputStream(src);
        try {
            long srcLMD = 0L;
            srcLMD = src.lastModified();
            if (srcLMD == 0L) {
                throw new IOException("Failed to get the last modification time of " + src.getAbsolutePath());
            }
            FileOutputStream out = new FileOutputStream(dst);
            try {
                int ln;
                while ((ln = ((InputStream)in).read(buffer)) != -1) {
                    ((OutputStream)out).write(buffer, 0, ln);
                }
            }
            finally {
                ((OutputStream)out).close();
            }
            if (srcLMD != 0L && !dst.setLastModified(srcLMD)) {
                throw new IOException("Failed to set last-modification-date for: " + dst.getAbsolutePath());
            }
        }
        finally {
            ((InputStream)in).close();
        }
    }

    static boolean isDocgenFile(String fName) {
        return (fName = fName.toLowerCase()).startsWith("docgen-") || fName.startsWith("docgen.") || fName.equals("docgen");
    }

    static boolean isUsualIgnorableFileOrDirectory(String fName) {
        int i = (fName = fName.toLowerCase()).lastIndexOf(".");
        String fExt = i == -1 ? "" : fName.substring(i + 1);
        if (fName.equals(".cvsignore") || fName.equals("cvs") || fName.length() > 2 && fName.startsWith(".#")) {
            return true;
        }
        if (fName.equals(".svn")) {
            return true;
        }
        return fExt.equals("bak") || fExt.equals("lock") || fExt.startsWith("~") || fName.length() > 2 && (fName.startsWith("#") && fName.endsWith("#") || fName.startsWith("%") && fName.endsWith("%") || fName.startsWith("._")) || fName.length() > 1 && (fName.endsWith("~") || fName.startsWith("~"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(File f, Charset charset) throws IOException {
        FileInputStream in = new FileInputStream(f);
        try {
            String string = FileUtil.loadString(in, charset);
            return string;
        }
        finally {
            in.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadString(InputStream in, Charset charset) throws IOException {
        InputStreamReader r = new InputStreamReader(in, charset);
        StringBuilder sb = new StringBuilder(256);
        try {
            int ln;
            char[] buf = new char[4096];
            while ((ln = r.read(buf)) != -1) {
                sb.append(buf, 0, ln);
            }
        }
        finally {
            ((Reader)r).close();
        }
        return sb.toString();
    }
}

