/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.util.LinkedList;
import java.util.List;
import org.freemarker.docgen.MessageStreamActivityMonitor;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CollectingErrorHandler
implements ErrorHandler,
MessageStreamActivityMonitor {
    private final int maxErrorMessages;
    private boolean hadNewErrorMessage;
    private final List<String> errors = new LinkedList<String>();

    CollectingErrorHandler(int maxErrors) {
        this.maxErrorMessages = maxErrors;
    }

    @Override
    public void warning(SAXParseException spe) {
    }

    @Override
    public void error(SAXParseException spe) throws SAXParseException {
        this.addError("ERROR", spe);
    }

    @Override
    public void fatalError(SAXParseException spe) throws SAXParseException {
        this.addError("FATAL ERROR", spe);
    }

    public List<String> getErrors() {
        return this.errors;
    }

    private void addError(String type, SAXParseException spe) {
        int ln = this.errors.size();
        if (ln < this.maxErrorMessages) {
            this.hadNewErrorMessage = true;
            this.errors.add(type + ": " + spe.getMessage() + "\n" + "(at line " + spe.getLineNumber() + ", column " + spe.getColumnNumber() + " of " + spe.getSystemId() + ")");
        } else if (ln == this.maxErrorMessages) {
            this.hadNewErrorMessage = true;
            this.errors.add("TOO MANY ERRORS: Some error messages were discarded.");
        }
    }

    @Override
    public boolean hadNewErrorMessage() {
        return this.hadNewErrorMessage;
    }

    @Override
    public void reset() {
        this.hadNewErrorMessage = false;
    }
}

