/*
 * Decompiled with CFR 0.152.
 */
package org.freemarker.docgen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.freemarker.docgen.BugException;
import org.freemarker.docgen.TextUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CJSONInterpreter {
    public static final EvaluationEnvironment SIMPLE_EVALUATION_ENVIRONMENT = new EvaluationEnvironment(){

        public Object evalFunctionCall(FunctionCall f, CJSONInterpreter ip) {
            return f;
        }

        public Object notify(EvaluationEvent event, CJSONInterpreter ip, String name, Object extra) {
            return null;
        }
    };
    private static final boolean[] UQSTR_CHARS = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, false, false, false, true, true, false, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, false, false, false, false, false};
    private int p;
    private int ln;
    private EvaluationEnvironment ee;
    private String tx;
    private String fileName;
    private boolean skipWSFoundNL;
    private static final String ENCODING_COMMENT_1 = "encoding";
    private static final String ENCODING_COMMENT_2 = "charset";
    private static final String LINE_BREAK = "\n";

    private CJSONInterpreter() {
    }

    public static Object eval(String text, EvaluationEnvironment ee, boolean forceStringValues, String fileName) throws EvaluationException {
        CJSONInterpreter ip = new CJSONInterpreter();
        ip.init(text, fileName, ee);
        ip.skipWS();
        if (ip.p == ip.ln) {
            throw ip.newSyntaxError("The text is empty.");
        }
        Object res = ip.fetchExpression(forceStringValues, false);
        ip.skipWS();
        if (ip.p < ip.ln) {
            throw ip.newSyntaxError("Extra character(s) after the expression.");
        }
        return res;
    }

    public static Object eval(Fragment fragment, EvaluationEnvironment ee, boolean forceStringValues) throws EvaluationException {
        CJSONInterpreter ip = new CJSONInterpreter();
        ip.init(fragment, ee);
        ip.skipWS();
        if (ip.p == ip.ln) {
            throw ip.newSyntaxError("The text is empty.");
        }
        Object res = ip.fetchExpression(forceStringValues, false);
        ip.skipWS();
        if (ip.p < ip.ln) {
            throw ip.newSyntaxError("Extra character(s) after the expression.");
        }
        return res;
    }

    public static Object eval(String text, String fileName) throws EvaluationException {
        return CJSONInterpreter.eval(text, null, false, fileName);
    }

    public static Object eval(String text) throws EvaluationException {
        return CJSONInterpreter.eval(text, null, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> evalAsMap(String text, EvaluationEnvironment ee, boolean forceStringValues, String fileName) throws EvaluationException {
        CJSONInterpreter ip = new CJSONInterpreter();
        ip.init(text, fileName, ee);
        LinkedHashMap<String, Object> res = new LinkedHashMap<String, Object>();
        boolean done = false;
        try {
            try {
                ip.ee.notify(EvaluationEvent.ENTER_MAP, ip, null, res);
                done = true;
            }
            catch (Throwable e) {
                throw ip.newWrappedError(e);
            }
            Map<String, Object> map = ip.fetchMapInner(res, ' ', forceStringValues);
            return map;
        }
        finally {
            if (done) {
                try {
                    ip.ee.notify(EvaluationEvent.LEAVE_MAP, ip, null, res);
                }
                catch (Throwable e) {
                    throw ip.newWrappedError(e);
                }
            }
        }
    }

    public static Map<String, Object> evalAsMap(File f) throws EvaluationException, IOException {
        String s;
        FileInputStream in = new FileInputStream(f);
        try {
            s = CJSONInterpreter.loadCJSONFile(in, f.getAbsolutePath());
        }
        finally {
            ((InputStream)in).close();
        }
        return CJSONInterpreter.evalAsMap(s, f.getAbsolutePath());
    }

    public static Map<String, Object> evalAsMap(String text) throws EvaluationException {
        return CJSONInterpreter.evalAsMap(text, null, false, null);
    }

    public static Map<String, Object> evalAsMap(String text, String fileName) throws EvaluationException {
        return CJSONInterpreter.evalAsMap(text, null, false, fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Object> evalAsList(String text, EvaluationEnvironment ee, boolean forceStringValues, String fileName) throws EvaluationException {
        CJSONInterpreter ip = new CJSONInterpreter();
        ip.init(text, fileName, ee);
        ArrayList<Object> res = new ArrayList<Object>();
        boolean done = false;
        try {
            try {
                ip.ee.notify(EvaluationEvent.ENTER_LIST, ip, null, res);
                done = true;
            }
            catch (Throwable e) {
                throw ip.newWrappedError(e);
            }
            List<Object> list = ip.fetchListInner(res, ' ', forceStringValues);
            return list;
        }
        finally {
            if (done) {
                try {
                    ip.ee.notify(EvaluationEvent.LEAVE_LIST, ip, null, res);
                }
                catch (Throwable e) {
                    throw ip.newWrappedError(e);
                }
            }
        }
    }

    public static List<Object> evalAsList(String text) throws EvaluationException {
        return CJSONInterpreter.evalAsList(text, null, false, null);
    }

    public static List<Object> evalAsList(String text, String fileName) throws EvaluationException {
        return CJSONInterpreter.evalAsList(text, null, false, fileName);
    }

    public static String loadCJSONFile(InputStream in, String source) throws IOException {
        byte[] b = CJSONInterpreter.loadByteArray(in);
        return CJSONInterpreter.loadCJSONFile(b, source);
    }

    public static String loadCJSONFile(byte[] b, String source) throws IOException {
        String charset = CJSONInterpreter.extractCharsetComment(b);
        try {
            return new String(b, charset == null ? "UTF-8" : charset);
        }
        catch (UnsupportedEncodingException e) {
            String msg = "Unsupported character encoding, " + TextUtil.jQuote(charset) + " was specifed in ";
            msg = source != null ? msg + "this CJSON file: " + source : msg + "the CJSON file.";
            throw new IOException(msg);
        }
    }

    public static String dump(Object value) {
        StringBuilder buf = new StringBuilder();
        CJSONInterpreter.dumpValue(buf, value, "");
        return buf.toString();
    }

    public static String cjsonTypeOf(Object value) {
        if (value instanceof String) {
            return "string";
        }
        if (value instanceof Number) {
            return "number";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof List) {
            return "list";
        }
        if (value instanceof LinkedHashMap) {
            return "map";
        }
        if (value instanceof Map) {
            return "map (unordered)";
        }
        if (value instanceof FunctionCall) {
            return "function call";
        }
        if (value != null) {
            return value.getClass().getName();
        }
        return "null";
    }

    public int getPosition() {
        return this.p;
    }

    public String getText() {
        return this.tx;
    }

    public String getFileName() {
        return this.fileName;
    }

    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.ee;
    }

    private List<Object> fetchListInner(List<Object> list, char terminator, boolean forceStringValues) throws EvaluationException {
        char c;
        int listP = this.p - 1;
        this.skipWS();
        if (terminator == ' ') {
            listP = this.p;
        }
        do {
            if (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == terminator) {
                    return list;
                }
                if (c == ',') {
                    throw this.newSyntaxError("List item is missing before the comma.");
                }
            } else {
                if (terminator == ' ') {
                    return list;
                }
                throw this.newSyntaxError("Reached the end of the text, but the list was not closed with " + TextUtil.jQuoteOrName(terminator) + ".", listP);
            }
            list.add(this.fetchExpression(forceStringValues, false));
        } while ((c = this.skipSeparator(terminator, null, "This is a list, and not a map.")) != terminator);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Map<String, Object> fetchMapInner(Map<String, Object> map, char terminator, boolean forceStringValues) throws EvaluationException {
        mapP = this.p - 1;
        this.skipWS();
        if (terminator == ' ') {
            mapP = this.p;
        }
        do {
            if (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == terminator) {
                    return map;
                }
                if (c == ',') {
                    throw this.newSyntaxError("Key-value pair is missing before the comma.");
                }
            } else {
                if (terminator == ' ') {
                    return map;
                }
                throw this.newSyntaxError("Reached the end of the text, but the map was not closed with " + TextUtil.jQuoteOrName(terminator) + ".", mapP);
            }
            keyP = this.p;
            o1 = this.fetchExpression(false, true);
            if (o1 instanceof FunctionCall) {
                keyFunc = (FunctionCall)o1;
                try {
                    o1 = this.ee.evalFunctionCall(keyFunc, this);
                }
                catch (Throwable e) {
                    throw this.newError("Failed to evaluate function " + TextUtil.jQuote(keyFunc.getName()) + ".", keyP, e);
                }
            } else {
                keyFunc = null;
            }
            c = this.skipSeparator(terminator, null, null);
            if (c == ':') {
                if (!(o1 instanceof String)) {
                    if (keyFunc != o1) {
                        throw this.newError("The key must be a String, but it is a(n) " + CJSONInterpreter.cjsonTypeOf(o1) + ".", keyP);
                    }
                    throw this.newError("You can't use the function here, because it can't be evaluated in this context.", keyP);
                }
                if (this.p == this.ln) {
                    throw this.newSyntaxError("The key must be followed by a value because colon was used.", keyP);
                }
                done = false;
                try {
                    try {
                        nr = this.ee.notify(EvaluationEvent.ENTER_MAP_KEY, this, (String)o1, null);
                        done = true;
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e, keyP);
                    }
                    if (nr == null) {
                        o2 = this.fetchExpression(forceStringValues, false);
                        map.put((String)o1, o2);
                    } else {
                        p2 = this.p;
                        this.skipExpression();
                        if (nr == EvaluationEnvironment.RETURN_FRAGMENT) {
                            map.put((String)o1, new Fragment(this.tx, p2, this.p, this.fileName));
                        }
                    }
                }
                finally {
                    if (done) {
                        try {
                            this.ee.notify(EvaluationEvent.LEAVE_MAP_KEY, this, (String)o1, null);
                        }
                        catch (Throwable e) {
                            throw this.newWrappedError(e);
                        }
                    }
                }
                c = this.skipSeparator(terminator, null, "Colon is for separating the key from the value, and the value was alredy given previously.");
                continue;
            }
            if (c != ',' && c != terminator && c != ' ') continue;
            if (keyFunc == null) {
                if (o1 instanceof String) {
                    done = false;
                    try {
                        try {
                            nr = this.ee.notify(EvaluationEvent.ENTER_MAP_KEY, this, (String)o1, null);
                            done = true;
                        }
                        catch (Throwable e) {
                            throw this.newWrappedError(e, keyP);
                        }
                        if (nr != null && nr != EvaluationEnvironment.RETURN_FRAGMENT) ** GOTO lbl100
                        map.put((String)o1, Boolean.TRUE);
                    }
                    finally {
                        if (done) {
                            try {
                                this.ee.notify(EvaluationEvent.LEAVE_MAP_KEY, this, (String)o1, null);
                            }
                            catch (Throwable e) {
                                throw this.newWrappedError(e);
                            }
                        }
                    }
                }
                if (o1 instanceof Map) {
                    map.putAll((Map)o1);
                    continue;
                }
                throw this.newError("This expression should be either a string or a map, but it is a(n) " + CJSONInterpreter.cjsonTypeOf(o1) + ".", keyP);
            }
            if (o1 instanceof Map) {
                map.putAll((Map)o1);
                continue;
            }
            if (keyFunc == o1) {
                throw this.newError("You can't use the function here, because it can't be evaluated in this context.", keyP);
            }
            throw this.newError("Function doesn't evalute to a map, but to " + CJSONInterpreter.cjsonTypeOf(o1) + ", so it can't be merged into the map.", keyP);
lbl100:
            // 6 sources

        } while (c != terminator);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object fetchExpression(boolean forceStr, boolean mapKey) throws EvaluationException {
        if (this.p >= this.ln) {
            throw new BugException("Calling fetchExpression when p >= ln.");
        }
        char c = this.tx.charAt(this.p);
        if (c == '{') {
            Object res;
            ++this.p;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            boolean done = false;
            try {
                Object nr;
                try {
                    nr = this.ee.notify(EvaluationEvent.ENTER_MAP, this, null, map);
                    done = true;
                }
                catch (Throwable e) {
                    throw this.newWrappedError(e);
                }
                if (nr == null) {
                    this.fetchMapInner(map, '}', forceStr);
                    res = map;
                } else {
                    --this.p;
                    int p2 = this.p;
                    this.skipExpression();
                    res = new Fragment(this.tx, p2, this.p, this.fileName);
                    --this.p;
                }
            }
            finally {
                if (done) {
                    try {
                        this.ee.notify(EvaluationEvent.LEAVE_MAP, this, null, map);
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e);
                    }
                }
            }
            ++this.p;
            return res;
        }
        if (c == '[') {
            ++this.p;
            ArrayList<Object> res = new ArrayList<Object>();
            boolean done = false;
            try {
                try {
                    this.ee.notify(EvaluationEvent.ENTER_LIST, this, null, res);
                    done = true;
                }
                catch (Throwable e) {
                    throw this.newWrappedError(e);
                }
                this.fetchListInner(res, ']', forceStr);
            }
            finally {
                if (done) {
                    try {
                        this.ee.notify(EvaluationEvent.LEAVE_LIST, this, null, res);
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e);
                    }
                }
            }
            ++this.p;
            return res;
        }
        int b = this.p;
        if (c == '\"' || c == '\'') {
            char q = c;
            ++this.p;
            while (this.p < this.ln && (c = this.tx.charAt(this.p)) != '\\') {
                ++this.p;
                if (c != q) continue;
                return this.tx.substring(b + 1, this.p - 1);
            }
            if (this.p == this.ln) {
                throw this.newSyntaxError("The closing " + TextUtil.jQuoteOrName(q) + " of the string is missing.", b);
            }
            int bidx = b + 1;
            StringBuilder buf = new StringBuilder();
            block50: while (true) {
                buf.append(this.tx.substring(bidx, this.p));
                if (this.p == this.ln - 1) {
                    throw this.newSyntaxError("The closing " + TextUtil.jQuoteOrName(q) + " of the string is missing.", b);
                }
                c = this.tx.charAt(this.p + 1);
                switch (c) {
                    case '\"': {
                        buf.append('\"');
                        bidx = this.p + 2;
                        break;
                    }
                    case '\'': {
                        buf.append('\'');
                        bidx = this.p + 2;
                        break;
                    }
                    case '\\': {
                        buf.append('\\');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'n': {
                        buf.append('\n');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'r': {
                        buf.append('\r');
                        bidx = this.p + 2;
                        break;
                    }
                    case 't': {
                        buf.append('\t');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'f': {
                        buf.append('\f');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'b': {
                        buf.append('\b');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'g': {
                        buf.append('>');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'l': {
                        buf.append('<');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'a': {
                        buf.append('&');
                        bidx = this.p + 2;
                        break;
                    }
                    case '{': {
                        buf.append('{');
                        bidx = this.p + 2;
                        break;
                    }
                    case '/': {
                        buf.append('/');
                        bidx = this.p + 2;
                        break;
                    }
                    case 'u': 
                    case 'x': {
                        int z;
                        this.p += 2;
                        int x = this.p;
                        int y = 0;
                        int n = z = this.ln - this.p > 4 ? this.p + 4 : this.ln;
                        while (this.p < z) {
                            char c2 = this.tx.charAt(this.p);
                            if (c2 >= '0' && c2 <= '9') {
                                y <<= 4;
                                y += c2 - 48;
                            } else if (c2 >= 'a' && c2 <= 'f') {
                                y <<= 4;
                                y += c2 - 97 + 10;
                            } else {
                                if (c2 < 'A' || c2 > 'F') break;
                                y <<= 4;
                                y += c2 - 65 + 10;
                            }
                            ++this.p;
                        }
                        if (x >= this.p) {
                            throw this.newSyntaxError("Invalid hexadecimal UNICODE escape in the string literal.", x - 2);
                        }
                        buf.append((char)y);
                        bidx = this.p;
                        break;
                    }
                    default: {
                        if (CJSONInterpreter.isWS(c)) {
                            boolean hasWS = false;
                            bidx = this.p + 1;
                            do {
                                if (c != '\n' && c != '\r') continue;
                                if (hasWS) break;
                                hasWS = true;
                                if (c != '\r' || bidx >= this.ln - 1 || this.tx.charAt(bidx + 1) != '\n') continue;
                                ++bidx;
                            } while (++bidx != this.ln && CJSONInterpreter.isWS(c = this.tx.charAt(bidx)));
                            if (hasWS) break;
                            throw this.newSyntaxError("Invalid usage of escape sequence \\white-space. This escape sequence can be used only before line-break.");
                        }
                        throw this.newSyntaxError("Invalid escape sequence \\" + c + " in the string literal.");
                    }
                }
                this.p = bidx;
                while (true) {
                    if (this.p == this.ln) {
                        throw this.newSyntaxError("The closing " + TextUtil.jQuoteOrName(q) + " of the string is missing.", b);
                    }
                    c = this.tx.charAt(this.p);
                    if (c == '\\') continue block50;
                    if (c == q) {
                        buf.append(this.tx.substring(bidx, this.p));
                        ++this.p;
                        return buf.toString();
                    }
                    ++this.p;
                }
                break;
            }
        }
        char c2 = this.p < this.ln - 1 ? (char)this.tx.charAt(this.p + 1) : (char)' ';
        if (c == 'r' && (c2 == '\"' || c2 == '\'')) {
            char q = c2;
            this.p += 2;
            while (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                ++this.p;
                if (c != q) continue;
                return this.tx.substring(b + 2, this.p - 1);
            }
            throw this.newSyntaxError("The closing " + TextUtil.jQuoteOrName(q) + " of the string is missing.", b);
        }
        while (CJSONInterpreter.isUnquotedStringChar(c = this.tx.charAt(this.p)) || this.p == b && c == '+') {
            ++this.p;
            if (this.p != this.ln) continue;
        }
        if (b == this.p) {
            throw this.newSyntaxError("Unexpected character.", b);
        }
        String s = this.tx.substring(b, this.p);
        int funcP = b;
        int oldP = this.p++;
        c = this.skipWS();
        if (c == '(') {
            List<Object> params;
            boolean done = false;
            try {
                try {
                    this.ee.notify(EvaluationEvent.ENTER_FUNCTION_PARAMS, this, s, null);
                }
                catch (Throwable e) {
                    throw this.newWrappedError(e, funcP);
                }
                done = true;
                params = this.fetchListInner(new ArrayList<Object>(), ')', forceStr);
            }
            finally {
                if (done) {
                    try {
                        this.ee.notify(EvaluationEvent.LEAVE_FUNCTION_PARAMS, this, s, null);
                    }
                    catch (Throwable e) {
                        throw this.newWrappedError(e);
                    }
                }
            }
            ++this.p;
            FunctionCall func = new FunctionCall(s, params);
            if (!mapKey) {
                try {
                    return this.ee.evalFunctionCall(func, this);
                }
                catch (Throwable e) {
                    throw this.newError("Failed to evaluate function " + TextUtil.jQuote(func.getName()) + ".", b, e);
                }
            }
            return func;
        }
        this.p = oldP;
        if (!forceStr && !mapKey) {
            if (s.equals("true")) {
                return Boolean.TRUE;
            }
            if (s.equals("false")) {
                return Boolean.FALSE;
            }
            c = s.charAt(0);
            if (c >= '0' && c <= '9' || c == '+' || c == '-') {
                String s2 = c == '+' ? s.substring(1) : s;
                try {
                    return new Integer(s2);
                }
                catch (NumberFormatException exc) {
                    try {
                        return new BigDecimal(s2);
                    }
                    catch (NumberFormatException exc2) {
                        // empty catch block
                    }
                }
            }
        }
        return s;
    }

    private void skipExpression() throws EvaluationException {
        if (this.p >= this.ln) {
            throw new BugException("Calling fetchExpression when p >= ln.");
        }
        char c = this.tx.charAt(this.p);
        if (c == '{') {
            ++this.p;
            this.skipListing('}');
            ++this.p;
            return;
        }
        if (c == '[') {
            ++this.p;
            this.skipListing(']');
            ++this.p;
            return;
        }
        if (c == '<') {
            ++this.p;
            this.skipListing('>');
            ++this.p;
            return;
        }
        if (c == '(') {
            ++this.p;
            this.skipListing(')');
            ++this.p;
            return;
        }
        int b = this.p;
        if (c == '\"' || c == '\'') {
            char q = c;
            ++this.p;
            while (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == '\\' && this.p != this.ln - 1) {
                    ++this.p;
                }
                ++this.p;
                if (c != q) continue;
                return;
            }
            throw this.newSyntaxError("The closing " + TextUtil.jQuoteOrName(q) + " of the string is missing.", b);
        }
        char c2 = this.p < this.ln - 1 ? (char)this.tx.charAt(this.p + 1) : (char)' ';
        if (c == 'r' && (c2 == '\"' || c2 == '\'')) {
            char q = c2;
            this.p += 2;
            while (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                ++this.p;
                if (c != q) continue;
                return;
            }
            throw this.newSyntaxError("The closing " + TextUtil.jQuoteOrName(q) + " of the string is missing.", b);
        }
        while (CJSONInterpreter.isUnquotedStringChar(c = this.tx.charAt(this.p)) || this.p == b && c == '+') {
            ++this.p;
            if (this.p != this.ln) continue;
        }
        if (b == this.p) {
            throw this.newSyntaxError("Unexpected character.", b);
        }
        int oldP = this.p++;
        c = this.skipWS();
        if (c == '(') {
            this.skipListing(')');
            ++this.p;
        } else {
            this.p = oldP;
        }
    }

    private void skipListing(char terminator) throws EvaluationException {
        char c;
        int listP = this.p - 1;
        this.skipWS();
        if (terminator == ' ') {
            listP = this.p;
        }
        do {
            if (this.p < this.ln) {
                c = this.tx.charAt(this.p);
                if (c == terminator) {
                    return;
                }
            } else {
                if (terminator == ' ') {
                    return;
                }
                throw this.newSyntaxError("Reached the end of the text, but the closing " + TextUtil.jQuoteOrName(terminator) + " is missing.", listP);
            }
            if (c == ',' || c == ':' || c == ';' || c == '=') {
                ++this.p;
                continue;
            }
            this.skipExpression();
        } while ((c = this.skipWS()) != terminator);
    }

    private char skipSeparator(char terminator, String commaBadReason, String colonBadReason) throws EvaluationException {
        int intialP = this.p;
        char c = this.skipWS();
        boolean plusConverted = false;
        if (c == '+') {
            throw this.newSyntaxError("The + operator is not supported. (Hint: if you want to break a string into multiple lines, use a quoted string literal, finish the line with \\, then just continue the literal in the next line with optional indentation.");
        }
        if (c == ',' || c == ':') {
            if (commaBadReason != null && c == ',') {
                if (!plusConverted) {
                    throw this.newSyntaxError("Comma (,) shouldn't be used here. " + commaBadReason);
                }
                throw this.newSyntaxError("Plus sign (+), which is treated as comma (,) in this case, shouldn't be used here. " + commaBadReason);
            }
            if (colonBadReason != null && c == ':') {
                throw this.newSyntaxError("Colon (:) shouldn't be used here. " + colonBadReason);
            }
            ++this.p;
            this.skipWS();
            return c;
        }
        if (c == terminator) {
            return terminator;
        }
        if (c == ';') {
            throw this.newSyntaxError("Semicolon (;) was unexpected here. If you want to separate items in a listing then use comma (,) instead.");
        }
        if (c == '=') {
            throw this.newSyntaxError("Equals sign (=) was unexpected here. If you want to associate a key with a value then use colon (:) instead.");
        }
        if (c == ' ') {
            return c;
        }
        if (this.skipWSFoundNL) {
            if (commaBadReason != null) {
                throw this.newSyntaxError("Line-break shouldn't be used before this iteam as separator (which is the same as using comma). " + commaBadReason);
            }
            return ',';
        }
        if (this.p == intialP) {
            throw this.newSyntaxError("Character " + TextUtil.jQuoteOrName(this.tx.charAt(this.p)) + " shouldn't occur here.");
        }
        throw this.newSyntaxError("No separator was used before the item. Items in listings should be separated with comma (,) or line-break. Keys and values in maps should be separated with colon (:).");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private char skipWS() throws EvaluationException {
        this.skipWSFoundNL = false;
        while (this.p < this.ln) {
            char c = this.tx.charAt(this.p);
            if (!CJSONInterpreter.isWS(c)) {
                if (c == '/' && this.p + 1 < this.ln && this.tx.charAt(this.p + 1) == '/') {
                    do {
                        ++this.p;
                        if (this.p != this.ln) continue;
                        return ' ';
                    } while ((c = this.tx.charAt(this.p)) != '\n' && c != '\r');
                } else {
                    if (c != '/' || this.p + 1 >= this.ln || this.tx.charAt(this.p + 1) != '*') return c;
                    int commentP = this.p++;
                    do {
                        ++this.p;
                        if (this.p + 1 < this.ln) continue;
                        throw this.newSyntaxError("Comment was not closed with \"*/\".", commentP);
                    } while (this.tx.charAt(this.p) != '*' || this.tx.charAt(this.p + 1) != '/');
                    ++this.p;
                }
            } else if (c == '\r' || c == '\n') {
                this.skipWSFoundNL = true;
            }
            ++this.p;
        }
        return ' ';
    }

    private void init(String text, String fileName, EvaluationEnvironment ee) {
        this.p = 0;
        this.skipWSFoundNL = false;
        this.tx = text;
        this.ln = text.length();
        this.fileName = fileName;
        this.ee = ee == null ? SIMPLE_EVALUATION_ENVIRONMENT : ee;
    }

    private void init(Fragment fr, EvaluationEnvironment ee) {
        this.p = fr.getFragmentStart();
        this.skipWSFoundNL = false;
        this.tx = fr.getText();
        this.ln = fr.getFragmentEnd();
        this.fileName = fr.getFileName();
        this.ee = ee == null ? SIMPLE_EVALUATION_ENVIRONMENT : ee;
    }

    private static boolean isWS(char c) {
        return Character.isWhitespace(c) || c == '\ufeff';
    }

    private static boolean isUnquotedStringChar(char c) {
        return c < '\u0080' ? UQSTR_CHARS[c] : Character.isLetterOrDigit(c);
    }

    private static String extractCharsetComment(byte[] b) {
        String s;
        char c;
        int p = 0;
        int ln = b.length;
        if (p + 2 < ln && CJSONInterpreter.toChar(b[p]) == '\u00ef' && CJSONInterpreter.toChar(b[p + 1]) == '\u00bb' && CJSONInterpreter.toChar(b[p + 2]) == '\u00bf') {
            p += 3;
        }
        while (p < ln && Character.isWhitespace(CJSONInterpreter.toChar(b[p]))) {
            ++p;
        }
        if (p + 1 >= ln || CJSONInterpreter.toChar(b[p]) != '/' || CJSONInterpreter.toChar(b[p + 1]) != '/') {
            return null;
        }
        p += 2;
        int bp = p = CJSONInterpreter.extractCharsetComment_skipNonNLWS(b, p);
        while (p < ln && ((c = CJSONInterpreter.toChar(b[p])) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z')) {
            ++p;
        }
        if (p - bp != ENCODING_COMMENT_1.length() && p - bp != ENCODING_COMMENT_2.length()) {
            return null;
        }
        try {
            s = new String(b, bp, p - bp, "ISO-8859-1").toLowerCase();
        }
        catch (UnsupportedEncodingException e) {
            throw new BugException("ISO-8859-1 decoding failed.", e);
        }
        if (!s.equals(ENCODING_COMMENT_1) && !s.equals(ENCODING_COMMENT_2)) {
            return null;
        }
        if ((p = CJSONInterpreter.extractCharsetComment_skipNonNLWS(b, p)) == ln) {
            return null;
        }
        c = CJSONInterpreter.toChar(b[p]);
        if (c != ':') {
            return null;
        }
        ++p;
        if ((p = CJSONInterpreter.extractCharsetComment_skipNonNLWS(b, p)) == ln) {
            return null;
        }
        bp = p;
        while (p < ln && (c = CJSONInterpreter.toChar(b[p])) != '\n' && c != '\r') {
            ++p;
        }
        try {
            s = new String(b, bp, p - bp, "ISO-8859-1").trim();
            if (s.length() == 0) {
                return null;
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BugException("ISO-8859-1 decoding failed.", e);
        }
        return s;
    }

    private static int extractCharsetComment_skipNonNLWS(byte[] b, int p) {
        char c;
        int ln = b.length;
        while (p < ln && Character.isWhitespace(c = CJSONInterpreter.toChar(b[p])) && c != '\r' && c != '\n') {
            ++p;
        }
        return p;
    }

    private static char toChar(byte b) {
        return (char)(0xFF & b);
    }

    private static void dumpMap(StringBuilder out, Map<String, Object> m, String indent) {
        for (Map.Entry<String, Object> ent : m.entrySet()) {
            out.append(indent + TextUtil.jQuote(ent.getKey()) + ": ");
            CJSONInterpreter.dumpValue(out, ent.getValue(), indent);
            out.append(LINE_BREAK);
        }
    }

    private static void dumpMapSL(StringBuilder out, Map<String, Object> m) {
        Iterator<Map.Entry<String, Object>> it = m.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Object> ent = it.next();
            out.append(TextUtil.jQuote(ent.getKey()) + ":");
            CJSONInterpreter.dumpValueSL(out, ent.getValue());
            if (!it.hasNext()) continue;
            out.append(", ");
        }
    }

    private static void dumpList(StringBuilder out, List<?> ls, String indent) {
        for (Object obj : ls) {
            out.append(indent);
            CJSONInterpreter.dumpValue(out, obj, indent);
            out.append(LINE_BREAK);
        }
    }

    private static void dumpListSL(StringBuilder out, List<?> ls) {
        Iterator<?> it = ls.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            CJSONInterpreter.dumpValueSL(out, obj);
            if (!it.hasNext()) continue;
            out.append(", ");
        }
    }

    private static void dumpValue(StringBuilder out, Object o, String indent) {
        if (o instanceof Number || o instanceof Boolean) {
            out.append(o);
        } else if (o instanceof String) {
            out.append(TextUtil.jQuote((String)o));
        } else if (o instanceof Map) {
            out.append("{");
            out.append(LINE_BREAK);
            CJSONInterpreter.dumpMap(out, (Map)o, indent + "    ");
            out.append(indent + "}");
        } else if (o instanceof List) {
            out.append("[");
            out.append(LINE_BREAK);
            CJSONInterpreter.dumpList(out, (List)o, indent + "    ");
            out.append(indent + "]");
        } else if (o instanceof FunctionCall) {
            FunctionCall dir = (FunctionCall)o;
            out.append(dir.getName());
            out.append("(");
            CJSONInterpreter.dumpListSL(out, dir.getParams());
            out.append(")");
        } else if (o == null) {
            out.append("<null>");
        } else {
            out.append("<");
            out.append(o.getClass().getName());
            out.append(" ");
            out.append(TextUtil.jQuote(o.toString()));
            out.append(">");
        }
    }

    private static void dumpValueSL(StringBuilder out, Object o) {
        if (o instanceof Number || o instanceof Boolean) {
            out.append(o);
        } else if (o instanceof String) {
            out.append(TextUtil.jQuote((String)o));
        } else if (o instanceof Map) {
            out.append("{");
            CJSONInterpreter.dumpMapSL(out, (Map)o);
            out.append("}");
        } else if (o instanceof List) {
            out.append("[");
            CJSONInterpreter.dumpListSL(out, (List)o);
            out.append("]");
        } else if (o instanceof FunctionCall) {
            FunctionCall dir = (FunctionCall)o;
            out.append(dir.getName());
            out.append("(");
            CJSONInterpreter.dumpListSL(out, dir.getParams());
            out.append(")");
        } else {
            out.append("<");
            out.append(o.getClass().getName());
            out.append(" ");
            out.append(TextUtil.jQuote(o.toString()));
            out.append(">");
        }
    }

    private EvaluationException newSyntaxError(String message) {
        return this.newSyntaxError(message, this.p);
    }

    private EvaluationException newSyntaxError(String message, int position) {
        return new EvaluationException("CJSON syntax error: " + message, this.tx, position, this.fileName);
    }

    private EvaluationException newError(String message, int position) {
        return new EvaluationException("CJSON error: " + message, this.tx, position, this.fileName);
    }

    private EvaluationException newError(String message, int position, Throwable cause) {
        return new EvaluationException("CJSON error: " + message, this.tx, position, this.fileName, cause);
    }

    private EvaluationException newWrappedError(Throwable e) {
        return this.newWrappedError(e, this.p);
    }

    private EvaluationException newWrappedError(Throwable e, int p) {
        if (e instanceof EvaluationException) {
            return (EvaluationException)e;
        }
        return new EvaluationException("Error while evaluating CJSON: " + e.getMessage(), this.tx, p, this.fileName, e.getCause());
    }

    private static String createSourceCodeErrorMessage(String message, String srcCode, int position, String fileName, int maxQuotLength) {
        int ln2;
        int rowEnd;
        char c;
        int i;
        int ln = srcCode.length();
        if (position < 0) {
            position = 0;
        }
        if (position >= ln) {
            if (position == ln) {
                return message + LINE_BREAK + "Error location: The very end of " + (fileName == null ? "the text" : fileName) + ".";
            }
            return message + LINE_BREAK + "Error location: ??? (after the end of " + (fileName == null ? "the text" : fileName) + ")";
        }
        int rowBegin = 0;
        int row = 1;
        int lastChar = 0;
        for (i = 0; i <= position; ++i) {
            c = srcCode.charAt(i);
            if (lastChar == 10) {
                rowBegin = i;
                ++row;
            } else if (lastChar == 13 && c != '\n') {
                rowBegin = i;
                ++row;
            }
            lastChar = c;
        }
        for (i = position; i < ln; ++i) {
            c = srcCode.charAt(i);
            if (c != '\n' && c != '\r') continue;
            if (c != '\n' || i <= 0 || srcCode.charAt(i - 1) != '\r') break;
            --i;
            break;
        }
        if (position > (rowEnd = i - 1) + 1) {
            position = rowEnd + 1;
        }
        int col = position - rowBegin + 1;
        if (rowBegin > rowEnd) {
            return message + LINE_BREAK + "Error location: line " + row + ", column " + col + (fileName == null ? ":" : " in " + fileName + ":") + LINE_BREAK + "(Can't show the line because it is empty.)";
        }
        String s1 = srcCode.substring(rowBegin, position);
        String s2 = srcCode.substring(position, rowEnd + 1);
        int ln1 = (s1 = CJSONInterpreter.expandTabs(s1, 8)).length();
        if (ln1 + (ln2 = (s2 = CJSONInterpreter.expandTabs(s2, 8, ln1)).length()) > maxQuotLength) {
            int newLn2 = ln2 - (ln1 + ln2 - maxQuotLength);
            if (newLn2 < 6) {
                newLn2 = 6;
            }
            if (newLn2 < ln2) {
                s2 = s2.substring(0, newLn2 - 3) + "...";
                ln2 = newLn2;
            }
            if (ln1 + ln2 > maxQuotLength) {
                s1 = "..." + s1.substring(ln1 + ln2 - maxQuotLength + 3);
            }
        }
        StringBuilder res = new StringBuilder(message.length() + 80);
        res.append(message);
        res.append(LINE_BREAK);
        res.append("Error location: line ");
        res.append(row);
        res.append(", column ");
        res.append(col);
        if (fileName != null) {
            res.append(" in ");
            res.append(fileName);
        }
        res.append(":");
        res.append(LINE_BREAK);
        res.append(s1);
        res.append(s2);
        res.append(LINE_BREAK);
        for (int x = s1.length(); x != 0; --x) {
            res.append(' ');
        }
        res.append('^');
        return res.toString();
    }

    private static String expandTabs(String text, int tabWidth) {
        return CJSONInterpreter.expandTabs(text, tabWidth, 0);
    }

    private static String expandTabs(String text, int tabWidth, int startCol) {
        int e = text.indexOf(9);
        if (e == -1) {
            return text;
        }
        int b = 0;
        int tln = text.length();
        StringBuilder buf = new StringBuilder(tln + 16);
        do {
            buf.append(text.substring(b, e));
            int col = buf.length() + startCol;
            for (int i = tabWidth * (1 + col / tabWidth) - col; i > 0; --i) {
                buf.append(' ');
            }
        } while ((e = text.indexOf(9, b = e + 1)) != -1);
        buf.append(text.substring(b));
        return buf.toString();
    }

    private static byte[] loadByteArray(InputStream in) throws IOException {
        return CJSONInterpreter.loadByteArray(in, 512, false, 2.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] loadByteArray(InputStream in, int initialSize, boolean sizeExpected, double multipier) throws IOException {
        int size = 0;
        int bcap = initialSize;
        byte[] b = new byte[bcap];
        try {
            int rdn;
            while ((rdn = in.read(b, size, bcap - size)) != -1) {
                if (bcap != (size += rdn)) continue;
                int nextByte = -1;
                if (sizeExpected && (nextByte = in.read()) == -1) {
                    break;
                }
                bcap = (int)((double)bcap * multipier) + 64;
                byte[] newB = new byte[bcap];
                System.arraycopy(b, 0, newB, 0, size);
                b = newB;
                if (nextByte == -1) continue;
                b[size] = (byte)nextByte;
                ++size;
            }
        }
        finally {
            in.close();
        }
        if (b.length != size) {
            byte[] newB = new byte[size];
            System.arraycopy(b, 0, newB, 0, size);
            return newB;
        }
        return b;
    }

    public static class EvaluationException
    extends Exception {
        public EvaluationException(String message) {
            super(message);
        }

        public EvaluationException(String message, Throwable cause) {
            super(message, cause);
        }

        public EvaluationException(String message, int position) {
            super(message + CJSONInterpreter.LINE_BREAK + "Error location: character " + (position + 1));
        }

        public EvaluationException(String message, int position, Throwable cause) {
            super(message + CJSONInterpreter.LINE_BREAK + "Error location: character " + (position + 1), cause);
        }

        public EvaluationException(String message, String text, int position, String fileName) {
            super(CJSONInterpreter.createSourceCodeErrorMessage(message, text, position, fileName, 56));
        }

        public EvaluationException(String message, String text, int position, String fileName, Throwable cause) {
            super(CJSONInterpreter.createSourceCodeErrorMessage(message, text, position, fileName, 56), cause);
        }
    }

    public static interface EvaluationEnvironment {
        public static final Object RETURN_SKIP = new Object();
        public static final Object RETURN_FRAGMENT = new Object();

        public Object evalFunctionCall(FunctionCall var1, CJSONInterpreter var2) throws Exception;

        public Object notify(EvaluationEvent var1, CJSONInterpreter var2, String var3, Object var4) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EvaluationEvent {
        ENTER_MAP_KEY,
        LEAVE_MAP_KEY,
        ENTER_FUNCTION_PARAMS,
        LEAVE_FUNCTION_PARAMS,
        ENTER_LIST,
        LEAVE_LIST,
        ENTER_MAP,
        LEAVE_MAP;

    }

    public static class Fragment {
        private final String text;
        private final int fragmentStart;
        private final int fragmentEnd;
        private final String fileName;

        public Fragment(String text, int fragmentStart, int fragmentEnd, String fileName) {
            this.text = text;
            this.fragmentStart = fragmentStart;
            this.fragmentEnd = fragmentEnd;
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }

        public String getText() {
            return this.text;
        }

        public int getFragmentStart() {
            return this.fragmentStart;
        }

        public int getFragmentEnd() {
            return this.fragmentEnd;
        }

        public String toString() {
            return this.text.substring(this.fragmentStart, this.fragmentEnd);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FunctionCall {
        private final String name;
        private final List<Object> params;

        public FunctionCall(String name, List<Object> params) {
            this.name = name;
            this.params = params;
        }

        public String getName() {
            return this.name;
        }

        public List<Object> getParams() {
            return this.params;
        }

        public String toString() {
            return CJSONInterpreter.dump(this);
        }
    }
}

